C******************************************************************************
	SUBROUTINE AK$PRINT(USERNAME,START_STR,END_STR,STATUS)
C******************************************************************************
C AKPRINT.FOR
C
C  written by:  K. Trumbley
C  date:        May 1984
C
C    This routine formats the information for all displays.
C
	INCLUDE 'AK.INC/NOLIST'
	LOGICAL*1 STATUS
	CHARACTER USERNAME*12
	REAL*4 COST,TOTAL_COST
	EQUIVALENCE (DUMMY_LOG,DUMMY_STR)
C
	TOTAL_DSK_BLK=0
	TOTAL_PRT_PAG=0
	TOTAL_LOG_CNT=0
	TOTAL_LOG_FAL=0
	TOTAL_P_CON_TIM=0
	TOTAL_N_CON_TIM=0
	TOTAL_P_INT_TIM=0
	TOTAL_N_INT_TIM=0
	TOTAL_P_BAT_TIM=0
	TOTAL_N_BAT_TIM=0
	TOTAL_COST=0.0
C
	IF (TOT_USR.EQ.0) CALL AK$SUM
C
	DO I = 1,TOT_USR
	   AK$RECORD=AK$SUMMARY(I)
	   CALL AK$COST(COST,0)
	   AK$CHARGE=COST
	   AK$SUMMARY(I)=AK$RECORD
	END DO
C
	CALL AK$SORT
C

	IF (SUMMARY_FLAG) THEN
C
C--------------------------------------------------------------------
C		SUMMARY PRINTOUT
C--------------------------------------------------------------------
C
C  Print header
C
	  USER=1
 10	  WRITE(OUT_DEV,20,IOSTAT=JSTAT) HEADER_STR,START_STR,END_STR
 20	  FORMAT(/,T49,'ACCOUNTING SUMMARY',
     &	         /,T49,'------------------',
     &	        //,T44,A80,
     &	         /,T34,'For time period from ',A12,' to ',A12)
C
	  IF (LAST_LOGIN_FLAG) THEN
	    WRITE(OUT_DEV,22,IOSTAT=JSTAT)
	  ELSE
	    WRITE(OUT_DEV,21,IOSTAT=JSTAT)
	  END IF
C
 21	  FORMAT(//,T4,' Username',5X,'Account',3X,'Diskusage',
     &	       2X,'Print',3X,'Log',
     &	       2X,'Log  |',7X,'Prime time',15X,'Nonprime time',
     &	       6X,'|',7X,'Charges',/,T4,
     &	       25X,'(blocks)',2X,'Pages',2X,'Count',1X,'Fail',
     &         1X,'|',2X,'CONNECT   CPU   BATCH','  |',
     &	       2X,'CONNECT   CPU   BATCH','  |',/,T4,122('-'))
C
 22	  FORMAT(//,T4,' Username',5X,'Account',3X,'Diskusage',
     &	       2X,'Print',2X,' Date of   |',
     &	       7X,'Prime time',15X,'Nonprime time',
     &	       6X,'|',7X,'Charges',/,T4,
     &	       25X,'(blocks)',2X,'Pages',2X,'Last login |',
     &         2X,'CONNECT   CPU   BATCH','  |',
     &	       2X,'CONNECT   CPU   BATCH','  |',/,T4,122('-'))

C
C  Print line for each user
C
	  LINE_COUNT=1
30	  IF (LINE_COUNT.GT.48) GOTO 45
C
	    AK$RECORD=AK$SUMMARY(USER)
	    USER=USER+1
	    IF (USER.GT.TOT_USR+1) GOTO 50
	    IF ((ACCOUNT_NAME.EQ.'*').OR.
     &	         (ACCOUNT_NAME(1:ACC_NAME_LEN).EQ.
     &	                 AK$USR_ACC(1:ACC_NAME_LEN))) THEN
C
	      LINE_COUNT=LINE_COUNT+1
C
	      PHOUR=INT(AK$P_CON_TIM/3600.0)
	      PMIN=((AK$P_CON_TIM/3600.0)-INT(AK$P_CON_TIM/3600.0))*60
	      NHOUR=INT(AK$N_CON_TIM/3600.0)
	      NMIN=((AK$N_CON_TIM/3600.0)-INT(AK$N_CON_TIM/3600.0))*60
C
	      TOTAL_COST=TOTAL_COST+AK$CHARGE
	      TOTAL_DSK_BLK=TOTAL_DSK_BLK+AK$DSK_BLK
	      TOTAL_PRT_PAG=TOTAL_PRT_PAG+AK$PRT_PAG
	      TOTAL_LOG_CNT=TOTAL_LOG_CNT+AK$LOG_CNT
	      TOTAL_LOG_FAL=TOTAL_LOG_FAL+AK$LOG_FAL
	      TOTAL_P_CON_TIM=TOTAL_P_CON_TIM+AK$P_CON_TIM
	      TOTAL_N_CON_TIM=TOTAL_N_CON_TIM+AK$N_CON_TIM
	      TOTAL_P_INT_TIM=TOTAL_P_INT_TIM+AK$P_INT_TIM
	      TOTAL_N_INT_TIM=TOTAL_N_INT_TIM+AK$N_INT_TIM
	      TOTAL_P_BAT_TIM=TOTAL_P_BAT_TIM+AK$P_BAT_TIM
	      TOTAL_N_BAT_TIM=TOTAL_N_BAT_TIM+AK$N_BAT_TIM
C
	      IF (LAST_LOGIN_FLAG) THEN
	        WRITE(OUT_DEV,51,IOSTAT=JSTAT) AK$USR_NAM
     &	              ,AK$USR_ACC,AK$DSK_BLK
     &	              ,AK$PRT_PAG,AK$LST_LOG
     &	              ,PHOUR,PMIN,AK$P_INT_TIM,AK$P_BAT_TIM
     &	              ,NHOUR,NMIN,AK$N_INT_TIM,AK$N_BAT_TIM
     &	              ,AK$CHARGE
	      ELSE
	        WRITE(OUT_DEV,52,IOSTAT=JSTAT) AK$USR_NAM
     &	              ,AK$USR_ACC,AK$DSK_BLK
     &	              ,AK$PRT_PAG,AK$LOG_CNT,AK$LOG_FAL
     &	              ,PHOUR,PMIN,AK$P_INT_TIM,AK$P_BAT_TIM
     &	              ,NHOUR,NMIN,AK$N_INT_TIM,AK$N_BAT_TIM
     &	              ,AK$CHARGE
	      END IF
	    END IF
	    IF (USERNAME.NE.'*') GOTO 50
	    GOTO 30
45	  CONTINUE
C
C  Check if more users to do
C
	  IF (USER.LE.TOT_USR) THEN
	    IF (PAGE_FLAG) WRITE(OUT_DEV,'(1X,A1)',IOSTAT=JSTAT) 12
	    GOTO 10
	  END IF

C
 51	  FORMAT(4X,A12,1X,A8,2X,I8,2X,I5,2X,A11,1X,'|',
     &	         I5,':',I2.2,I8,I7,2X,'|',I5,':',I2.2,I8,I7,
     &	         2X,'| ',F13.2)
C
 52	  FORMAT(4X,A12,1X,A8,2X,I8,2X,I5,2X,I4,2X,I4,2X,'|',
     &	         I5,':',I2.2,I8,I7,2X,'|',I5,':',I2.2,I8,I7,
     &	         2X,'| ',F13.2)
C
C
C  Print total charges and charge rate table if required.
C
50	CONTINUE
C
	PHOUR=INT(TOTAL_P_CON_TIM/3600.0)
	PMIN=((TOTAL_P_CON_TIM/3600.0)-INT(TOTAL_P_CON_TIM/3600.0))*60
	NHOUR=INT(TOTAL_N_CON_TIM/3600.0)
	NMIN=((TOTAL_N_CON_TIM/3600.0)-INT(TOTAL_N_CON_TIM/3600.0))*60
C
	WRITE(OUT_DEV,25,IOSTAT=JSTAT) TOTAL_DSK_BLK,
     &		TOTAL_PRT_PAG,TOTAL_LOG_CNT,TOTAL_LOG_FAL,
     &		PHOUR,PMIN,TOTAL_P_INT_TIM,TOTAL_P_BAT_TIM,
     &		NHOUR,NMIN,TOTAL_N_INT_TIM,TOTAL_N_BAT_TIM,
     &		TOTAL_COST
C
 25	FORMAT(T4,122('-'),//,10X,'TOTALS = ',
     &	         8X,I8,2X,I5,2X,I4,2X,I4,3X,
     &	         I5,':',I2.2,I8,I7,3X,I5,':',I2.2,I8,I7,
     &	         4X,F13.2)
C
	  IF (RATE_TABLE_FLAG) THEN
	    IF (PAGE_FLAG) WRITE(OUT_DEV,'(1X,A1)',IOSTAT=JSTAT) 12
	    CALL AK$COST(COST,1)
	  END IF
C
	  STATUS=.TRUE.
	ELSE

C--------------------------------------------------------------------
C		DETAILED SINGLE USER PRINTOUT
C--------------------------------------------------------------------
C
C
	  ACC_COUNT=0
	  USER=1
C
87	  AK$RECORD=AK$SUMMARY(USER)
	  USER=USER+1
	  IF (USER.GT.TOT_USR+1) GOTO 88
	  IF (ACCOUNT_NAME.EQ.'*'.OR.ACCOUNT_NAME(1:ACC_NAME_LEN)
     &	       .EQ.AK$USR_ACC(1:ACC_NAME_LEN)) THEN
	    IF (ACC_COUNT.NE.0.AND.PAGE_FLAG) THEN
	       WRITE(OUT_DEV,'(1X,A1)',IOSTAT=JSTAT) 12
	    END IF
	    ACC_COUNT=ACC_COUNT+1
	    IF(.NOT.OUTPUT_FLAG) CALL LIB$ERASE_PAGE(1,1)
	    WRITE(OUT_DEV,100,IOSTAT=JSTAT)
 100	    FORMAT('------------------------------------------------'
     &	        ,'----------------------')
 110	    FORMAT(' ')
	    WRITE(OUT_DEV,150,IOSTAT=JSTAT) HEADER_STR
 150	    FORMAT(' ',A80)
	    WRITE(OUT_DEV,200,IOSTAT=JSTAT)AK$USR_NAM
     &	            ,AK$USR_ACC,AK$USR_GRP,AK$USR_MEM
 200	    FORMAT(' Username : ',A12,T27,'Account : ',A8,T50
     &	           'UIC : ['I3','I3']')
	    WRITE(OUT_DEV,110,IOSTAT=JSTAT)
	    WRITE(OUT_DEV,205,IOSTAT=JSTAT)START_STR,END_STR
 205	    FORMAT(T14,'Record for  ',A12,' to  ',A12)
	    WRITE(OUT_DEV,100,IOSTAT=JSTAT)
C
	    PHOUR=INT(AK$P_CON_TIM/3600)
	    PMIN=((AK$P_CON_TIM/3600.0)-INT(AK$P_CON_TIM/3600))*60
C
	    NHOUR=INT(AK$N_CON_TIM/3600)
	    NMIN=((AK$N_CON_TIM/3600.0)-INT(AK$N_CON_TIM/3600))*60
C
	    WRITE(OUT_DEV,240,IOSTAT=JSTAT)
 240	    FORMAT('      PRIME TIME   'T40'       NONPRIME TIME')
	    WRITE(OUT_DEV,110,IOSTAT=JSTAT)
	    WRITE(OUT_DEV,242,IOSTAT=JSTAT)PHOUR,PMIN,NHOUR,NMIN
 242	    FORMAT(' Connect time (h:m) :  'I5,':',I2.2,T40,
     &	           ' Connect time (h:m) :  'I5,':',I2.2)
	    WRITE(OUT_DEV,245,IOSTAT=JSTAT)AK$P_INT_TIM,AK$N_INT_TIM
 245	    FORMAT(' CPU time     (sec) : 'I9,T40,
     &	           ' CPU time     (sec) : 'I9)
	    WRITE(OUT_DEV,246,IOSTAT=JSTAT)AK$P_BAT_TIM,AK$N_BAT_TIM
 246	    FORMAT(' BATCH time   (sec) : 'I9,T40,
     &	           ' BATCH time   (sec) : 'I9)
C
	    WRITE(OUT_DEV,110,IOSTAT=JSTAT)

	    WRITE(OUT_DEV,210,IOSTAT=JSTAT)AK$DSK_BLK,AK$VOL_MNT
 210	    FORMAT(' Disk usage  (blks) : 'I9,T40,
     &	           ' Volumes mounted    : 'I9)
	    WRITE(OUT_DEV,220,IOSTAT=JSTAT)AK$PRT_JOB,AK$PRT_PAG
 220	    FORMAT(' Print jobs         : 'I9,T40,
     &	           ' Pages printed      : 'I9)
	    WRITE(OUT_DEV,230,IOSTAT=JSTAT)AK$LOG_CNT,AK$LOG_FAL
 230	    FORMAT(' Log count          : 'I9,T40,
     &	           ' Login failures     : 'I9)
	    WRITE(OUT_DEV,250,IOSTAT=JSTAT)AK$DIR_IO,AK$BUF_IO
 250	    FORMAT(' Direct I/O count   : 'I9,T40,
     &	           ' Buffered I/O count : 'I9)
	    WRITE(OUT_DEV,260,IOSTAT=JSTAT)AK$PAG_FLT
 260	    FORMAT(' Page fault count   : 'I9)
	    WRITE(OUT_DEV,270,IOSTAT=JSTAT)AK$LST_LOG
 270	    FORMAT(' Date of last login : 'A11)
	    WRITE(OUT_DEV,100,IOSTAT=JSTAT)
	    WRITE(OUT_DEV,280,IOSTAT=JSTAT)AK$CHARGE
 280	    FORMAT(' CHARGES            $ 'F9.2)
	    WRITE(OUT_DEV,100,IOSTAT=JSTAT)
	    IF (RATE_TABLE_FLAG) CALL AK$COST(COST,1)
C
C
C  If display to terminal and USERNAME='*' then print one
C  screen full and wait.
C
 300	    FORMAT(/)
	    IF (USERNAME.EQ.'*') THEN
 350	      IF (.NOT.BATCH_FLAG.AND..NOT.OUTPUT_FLAG) THEN
	        WRITE(OUT_DEV,300,IOSTAT=JSTAT)
	        WRITE(OUT_DEV,400,IOSTAT=JSTAT)
 400	        FORMAT(' <Return> to continue, E to quit ........ '$)
	        READ(OUT_DEV,'(A12)') EXIT_CHAR
	        IF (EXIT_CHAR.EQ.'E'.OR.EXIT_CHAR.EQ.'e') GOTO 999
	      END IF
	    ELSE
	      IF (BEGIN_FLAG) GOTO 350
	      GOTO 999
	    END IF
	  END IF
	  IF (USERNAME.EQ.'*') GOTO 87
 88	  STATUS=.TRUE.
	  RETURN
 999	  STATUS=.FALSE.
C
	END IF
	RETURN
	END
