C******************************************************************************
	PROGRAM AK$REPORT
C******************************************************************************
C AKREPORT.FOR
C
C  written by:  K. Trumbley
C  date:        April 1984
C  modified:    K. Trumbley, July 1986, - added HELP facility
C                                       - replaced ak$switch parsing
C
C   This program provides the means by which the system manager can obtain
C  detailed or summary type displays of the information collected by AKCOUNT
C  software.
C
C******************************************************************************
C
	INCLUDE 'AK.INC/NOLIST'
	EXTERNAL LIB$PUT_OUTPUT,LIB$GET_INPUT,LBR$OUTPUT_HELP
	INCLUDE '($RMSDEF)/NOLIST'
	INCLUDE '($HLPDEF)/NOLIST'
	CHARACTER USERNAME*12,PROMPT*16,LINE*132
	LOGICAL*1 FIRST_BLOCK,STATUS
	REAL*4 COST
	EQUIVALENCE (DUMMY_LOG,DUMMY_STR)
C
	DATA OUT_DEV/6/
	DATA TOT_USR/0/
	DATA TOT_FIL/11/
	INCLUDE 'AKCONFIG.INC/LIST'
C
	CALL LIB$GET_FOREIGN(LINE,,LINE_LEN)
C
100	HELP_FLAG = .FALSE.
	INPUT_FLAG = .FALSE.
	OUTPUT_FLAG = .FALSE.
	BEGIN_FLAG = .FALSE.
	END_FLAG = .FALSE.
	PAGE_FLAG = .FALSE.
	RATE_TABLE_FLAG = .FALSE.
	SUMMARY_FLAG = .FALSE.
	BATCH_FLAG = .FALSE.
	TOTAL_FLAG = .FALSE.
	LINE_PRINTER_FLAG = .FALSE.
	ACCOUNT_FLAG = .FALSE.
	SORT_FLAG = .FALSE.
	ASCEND_FLAG = .FALSE.
	LAST_LOGIN_FLAG = .FALSE.

C
	IF (LINE_LEN.GT.0) THEN
C
C  Parse command switches in command line
C
	  CALL STR$UPCASE(LINE(1:LINE_LEN),LINE(1:LINE_LEN))
	  CALL AK$SWITCH(FORM_REPORT,USERNAME,LINE,LINE_LEN)
	ELSE
	  WRITE(6,101)
101	  FORMAT(/,'$akreport> ')
	  READ(5,102,END=9999,ERR=9999) LINE_LEN,LINE
102	  FORMAT(Q,A)
	  IF (LINE_LEN.EQ.0) GOTO 100
	  CALL STR$UPCASE(LINE(1:LINE_LEN),LINE(1:LINE_LEN))
	  IF (LINE.EQ.'EX'.OR.LINE.EQ.'EXI'.OR.
     &	      LINE.EQ.'EXIT') GOTO 9999
	  IF (LINE.EQ.'QU'.OR.LINE.EQ.'QUI'.OR.
     &	      LINE.EQ.'QUIT') GOTO 9999
	  IF (LINE.NE.'HELP'.AND.LINE.NE.'?') GOTO 100
	  HELP_FLAG = .TRUE.
	END IF
c
c  Print help documentation if selected
c
	IF (HELP_FLAG) THEN
	  STATUS = LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,,'AKREPORT',
     &	                           'SYS$ACCOUNT:AKCOUNT.HLB',,
     &	                           LIB$GET_INPUT)
	  IF (.NOT.STATUS) CALL LIB$SIGNAL(%VAL(STATUS))
	  LINE_LEN = 0
	  GOTO 100
	END IF
C
C  Open AKCOUNT.TOT file and output listing file
C
	OPEN(TOT_FIL,NAME=AKCOUNT_FILENAME,STATUS='OLD',
     &	     CARRIAGECONTROL='LIST')
	IF (OUTPUT_FLAG) THEN
	  OUT_DEV=10
	  OPEN(OUT_DEV,NAME=OUTPUT_FILENAME,STATUS='NEW',
     &	       CARRIAGECONTROL='LIST')
	END IF

C
C  Position AKCOUNT.TOT file to proper starting block depending on
C  BEGIN_DATE as set by command switches. When starting block found
C  set starting date from date in this block. If END_DATE is in same
C  block, set ending date.
C
 1	IF (BEGIN_FLAG) THEN
 5	  READ(TOT_FIL,'(128A1)',END=999) (DUMMY_LOG(I),I=1,128)
	  IF (DUMMY_LOG(1).EQ.1) GOTO 6
	  IF (DUMMY_LOG(1).NE.-1) GOTO 5
 6	  AK$HEADER=DUMMY_STR
	  IF(.NOT.CMP_DATE(AK$END_DATE,BEGIN_DATE)) GOTO 5
	  IF(.NOT.FIRST_BLOCK) THEN
	    ISTAT=SYS$ASCTIM(,START_STR,AK$START_DATE,)
	    FIRST_BLOCK=.TRUE.
	  END IF
	  IF (.NOT.TOTAL_FLAG) THEN
	    ISTAT=SYS$ASCTIM(,START_STR,AK$START_DATE,)
	  END IF
	  IF (END_FLAG) THEN
	    IF(CMP_DATE(AK$START_DATE,END_DATE)) GOTO 5
	    ISTAT=SYS$ASCTIM(,END_STR,AK$END_DATE,)
	  ELSE
	    ISTAT=SYS$ASCTIM(,END_STR,AK$END_DATE,)
	  END IF
	ELSE
 7	  READ(TOT_FIL,'(128A1)',END=999) (DUMMY_LOG(I),I=1,128)
	  IF (DUMMY_LOG(1).NE.1) GOTO 7
	  AK$HEADER=DUMMY_STR
	  ISTAT=SYS$ASCTIM(,START_STR,AK$START_DATE,)
	  ISTAT=SYS$ASCTIM(,END_STR,AK$END_DATE,)
	END IF

C
C  Read each record from AKCOUNT.TOT file for the current block
C  and do display as requested by user. When finished with block
C  go and position file to next block.
C
  10	READ(TOT_FIL,'(128A1)',END=999) (DUMMY_LOG(I),I=1,128)
C
	IF (DUMMY_LOG(1).EQ.0) THEN
	  AK$RECORD=DUMMY_STR
	  IF (USERNAME.NE.'*') THEN
	    IF (USERNAME.NE.AK$USR_NAM) GOTO 10
	    IF (TOTAL_FLAG) THEN
	      CALL AK$SUM
	      I_CHECK=1
	    ELSE
	      I_CHECK=0
	      CALL AK$PRINT(USERNAME,START_STR,END_STR,STATUS)
	      IF (.NOT.STATUS) GOTO 999
	    END IF
	  ELSE
	    CALL AK$SUM
	    I_CHECK=1
	  END IF
	ELSE
	  IF (.NOT.TOTAL_FLAG.AND.I_CHECK.EQ.1) THEN
	    I_CHECK=0
	    CALL AK$PRINT(USERNAME,START_STR,END_STR,STATUS)
	    IF (.NOT.STATUS) GOTO 999
	    TOT_USR=0
	    TOTAL_COST=0.0
	  END IF
	  BACKSPACE(TOT_FIL)
	  GOTO 1
	END IF
C
	GOTO 10
C
C  All jobs finished except check to see if last display has been
C  printed, if no then do this job.
C
 999	CONTINUE
	IF (TOTAL_FLAG.OR.I_CHECK.EQ.1) THEN
	  CALL AK$PRINT(USERNAME,START_STR,END_STR,STATUS)
	END IF
C
C  Close all files and exit
C
	CLOSE(TOT_FIL)
	IF (OUTPUT_FLAG) THEN
	  IF (LINE_PRINTER_FLAG) THEN
	    CLOSE(UNIT=OUT_DEV,DISPOSE='PRINT/DELETE')
	  ELSE
	    CLOSE(UNIT=OUT_DEV)
	  END IF
	END IF
9999	CONTINUE
	END
