C
C******************************************************************************
	PROGRAM AKTIME
C******************************************************************************
C AKTIME.FOR
C
C	Written By : M. Serrer  DME/NRC  Systems Lab.
C	Date       : Nov/83
C
C------------------------------------------------------------------------------
C
C	  This program accepts as input a day-of-the-week and
C	a time in the format  MONDAY,12:00:00 . It then defines
C	the symbols DELTA_DATE and ABSOL_DATE in the local
C	symbol table.
C	  These symbol definitions are in the proper format for
C	use by such DCL commands as  SUBMIT/AFTER='ABSOL_DATE
C
C	DELTA_DATE  - This is the number of days,hours,minutes 
C		     and seconds from the current SYSTEM time
C		     to the time specified in the input.
C
C	ABSOL_DATE  - This is the day,month,year and time
C		     specified in the input.
C
C	AK_DATE     - Day,month,year and time for AKCOUNTing, where
C		      if the fiscal year changes then AK_DATE is
C		      set to the end of the fiscal year.
C
C	AK_FISCAL   - Flag = YES when end of fiscal year crossed.
C
C	AK_START    - Day,month,year for start of current fiscal year
C
C	CURRENT_DAY - This Symbol contains the current DAY-OF-WEEK
C	               ( ie. TODAY )
C
C	NEXT_DAY    - This Symbol contains the DAY-OF-WEEK for tomorrow
C
C------------------------------------------------------------------------------
C_Building and Linking:
C
C	  This program must be linked with the COMPILED message
C	file  AKTIMERR.MSG ,
C
C	eg.  ' $ LINK/NOTRACE AKTIME,AKTIMERR
C
C------------------------------------------------------------------------------
C_Installation:
C
C	  This program must be installed as a foreign command.
C
C	eg.  ' $ AKTIME:==$SYS$ACCOUNT:AKTIME.EXE '
C
C------------------------------------------------------------------------------

C------------------------------------------------------------------------------
C_Variable INITIALIZATION and DECLARATION
C
	INCLUDE 'AK.INC/NOLIST'
	EXTERNAL TOFS__INVDT,TOFS__INVD,TOFS__INVT,TOFS__ILLT
C
	REAL*4 R_DAY,R_MONTH,R_YEAR
C
	INTEGER*4 TARGET_DAY,TARGET_TIME,TARGET_WEEK_DAY
	INTEGER*4 NOW_MONTH,NOW_DAY,NOW_YEAR,NOW_TIME,NOW_WEEK_DAY
	INTEGER*4 TIME_POSN,INPUT_LENGTH,DELTA_DAY,DELTA_TIME
	INTEGER*4 MONTH_END,NEXT_WEEK_DAY,CURRENT_MONTH,SAVE_YEAR
C
	LOGICAL*1 ISTAT,COMMAND_INPUT_BYTES(20),TARGET_TIME_BYTES(8)
	LOGICAL*1 LOG_VAR(6)
	LOGICAL*1 LOG_CURRENT_DAY_STRING(9)
	LOGICAL*1 LOG_NEXT_DAY_STRING(9),LOG_AK_START_STRING(11)
	LOGICAL*1 LOG_DELTA_STRING(11),LOG_AK_FISCAL_STRING(3)
	LOGICAL*1 LOG_ABSOL_STRING(20),LOG_AK_DATE_STRING(20)
C
	CHARACTER*9 DAYS(7),TARGET_DAY_STRING
	CHARACTER*8 NOW_TIME_STRING,TARGET_TIME_STRING,DELTA_TIME_STRING
	CHARACTER*3 MONTHS(12),CHAR_VAR*6
	CHARACTER COMMAND_INPUT_STRING*20,PROMPT*54
	CHARACTER DELTA_SYMBOL_NAME*10,DELTA_STRING*11
	CHARACTER ABSOL_SYMBOL_NAME*10,ABSOL_STRING*20
	CHARACTER CURRENT_DAY_SYMBOL*11,CURRENT_DAY_STRING*9
	CHARACTER NEXT_DAY_SYMBOL*11,NEXT_DAY_STRING*9
	CHARACTER AK_DATE_SYMBOL_NAME*7,AK_DATE_STRING*20
	CHARACTER AK_FISCAL_SYMBOL_NAME*9,AK_FISCAL_STRING*3
	CHARACTER AK_START_SYMBOL_NAME*8,AK_START_STRING*11
C
	EQUIVALENCE (CHAR_VAR,LOG_VAR)
	EQUIVALENCE (TARGET_TIME_STRING,TARGET_TIME_BYTES)
	EQUIVALENCE (COMMAND_INPUT_STRING,COMMAND_INPUT_BYTES)
	EQUIVALENCE (CURRENT_DAY_STRING,LOG_CURRENT_DAY_STRING)
	EQUIVALENCE (NEXT_DAY_STRING,LOG_NEXT_DAY_STRING)
	EQUIVALENCE (DELTA_STRING,LOG_DELTA_STRING)
	EQUIVALENCE (ABSOL_STRING,LOG_ABSOL_STRING)
	EQUIVALENCE (AK_DATE_STRING,LOG_AK_DATE_STRING)
	EQUIVALENCE (AK_FISCAL_STRING,LOG_AK_FISCAL_STRING)
	EQUIVALENCE (AK_START_STRING,LOG_AK_START_STRING)
C
	DATA (MONTHS(I),I=1,6)/'JAN','FEB','MAR','APR','MAY','JUN'/
	DATA (MONTHS(I),I=7,12)/'JUL','AUG','SEP','OCT','NOV','DEC'/
	DATA DAYS(1),DAYS(2),DAYS(3)/'SUNDAY','MONDAY','TUESDAY'/
	DATA DAYS(4),DAYS(5),DAYS(6)/'WEDNESDAY','THURSDAY','FRIDAY'/
	DATA DAYS(7)/'SATURDAY'/
	INCLUDE 'AKCONFIG.INC/NOLIST'
C
	CURRENT_DAY_SYMBOL='CURRENT_DAY'
	NEXT_DAY_SYMBOL='NEXT_DAY'
	DELTA_SYMBOL_NAME='DELTA_DATE'
	ABSOL_SYMBOL_NAME='ABSOL_DATE'
	AK_DATE_SYMBOL_NAME='AK_DATE'
	AK_FISCAL_SYMBOL_NAME='AK_FISCAL'
	AK_START_SYMBOL_NAME='AK_START'
C

C
C------------------------------------------------------------------------------
C_Get FOREIGN COMMAND line
C
	PROMPT='$_ENTER  Day,Time  -  Format=  DDDDDDDDD,00:00:00   >'
	CALL LIB$GET_FOREIGN(COMMAND_INPUT_STRING,PROMPT,INPUT_LENGTH,)
C
C------------------------------------------------------------------------------
C_Parse COMMAND line
C
	NCHAR=0
	DO I=1,INPUT_LENGTH
	 IF(COMMAND_INPUT_BYTES(I).NE.' ')THEN
C
	  NCHAR=NCHAR+1
	  IF(COMMAND_INPUT_BYTES(I).EQ.','.AND.NCHAR.LE.10)THEN
	    TARGET_DAY_STRING=COMMAND_INPUT_STRING(1:I-1)
	    TIME_POSN=I+1
	    TARGET_TIME_STRING=COMMAND_INPUT_STRING(TIME_POSN:INPUT_LENGTH)
	    GOTO 10
	  END IF
C
	 END IF
	END DO
	CALL LIB$STOP(TOFS__INVDT,%VAL(0))
C
C------------------------------------------------------------------------------
C_Get TARGET day of the week and verify VALID day name
C
  10	DO I=1,7
	  IF(TARGET_DAY_STRING.EQ.DAYS(I))GOTO 20
	END DO
	CALL LIB$STOP(TOFS__INVD,%VAL(0))
C
  20	TARGET_WEEK_DAY=I
C
C------------------------------------------------------------------------------
C_Verify for valid time string input
C
	IF  (TARGET_TIME_BYTES(1).GE.48.AND.TARGET_TIME_BYTES(1).LE.50
     &	.AND.TARGET_TIME_BYTES(2).GE.48.AND.TARGET_TIME_BYTES(2).LE.57
     &	.AND.TARGET_TIME_BYTES(3).EQ.58
     &	.AND.TARGET_TIME_BYTES(4).GE.48.AND.TARGET_TIME_BYTES(4).LE.54
     &	.AND.TARGET_TIME_BYTES(5).GE.48.AND.TARGET_TIME_BYTES(5).LE.57
     &	.AND.TARGET_TIME_BYTES(6).EQ.58
     &	.AND.TARGET_TIME_BYTES(7).GE.48.AND.TARGET_TIME_BYTES(7).LE.54
     &	.AND.TARGET_TIME_BYTES(8).GE.48.AND.TARGET_TIME_BYTES(8).LE.57
     &	 ) GOTO 30
C
	CALL LIB$STOP(TOFS__INVT,%VAL(0))
C

C
C------------------------------------------------------------------------------
C_Convert TARGET TIME character-string to INTEGER seconds
C
  30	CALL TIME_STR_TO_SEC(TARGET_TIME_STRING,TARGET_TIME)
C
C------------------------------------------------------------------------------
C_Get current DATE and TIME
C
	CALL FOR$JDATE(NOW_MONTH,NOW_DAY,NOW_YEAR)
	NOW_YEAR=NOW_YEAR+1900
	CURRENT_MONTH=NOW_MONTH
C
	CALL FOR$TIME_T_DS(NOW_TIME_STRING)
C
C------------------------------------------------------------------------------
C_Convert CURRENT TIME character-string to INTEGER seconds
C
	CALL TIME_STR_TO_SEC(NOW_TIME_STRING,NOW_TIME)
C
C------------------------------------------------------------------------------
C_Calculate CURRENT day of the week
C
	R_DAY=NOW_DAY			!_Must be REAL
	R_MONTH=NOW_MONTH
	R_YEAR=NOW_YEAR
C
	ZK=INT(0.6+(1.0/R_MONTH))
	ZL=R_YEAR-ZK
	O=R_MONTH+12.0*ZK
	P=ZL/100.0
	Z1=INT(P/4.0)
	Z2=INT(P)
	Z3=INT((5.0*ZL)/4.0)
	Z4=INT(13.0*(O+1.0)/5.0)
	Z0=Z4+Z3-Z2+Z1+R_DAY-1.0
C
	NOW_WEEK_DAY=Z0-(7.0*INT(Z0/7.0))+1.0
C
C------------------------------------------------------------------------------
C_Set CURRENT_DAY and NEXT_DAY symbol's
C
	CURRENT_DAY_STRING=DAYS(NOW_WEEK_DAY)
	NEXT_WEEK_DAY=NOW_WEEK_DAY+1
	IF (NEXT_WEEK_DAY.EQ.8) NEXT_WEEK_DAY=1
	NEXT_DAY_STRING=DAYS(NEXT_WEEK_DAY)
C
	DO I=1,9
	  IF(LOG_CURRENT_DAY_STRING(I).EQ.' ')THEN
	   LOG_CURRENT_DAY_STRING(I)=0
	  END IF
	  IF(LOG_NEXT_DAY_STRING(I).EQ.' ')THEN
	   LOG_NEXT_DAY_STRING(I)=0
	  END IF
	END DO
C
	ISTAT=LIB$SET_SYMBOL(CURRENT_DAY_SYMBOL,CURRENT_DAY_STRING,1)
	ISTAT=LIB$SET_SYMBOL(NEXT_DAY_SYMBOL,NEXT_DAY_STRING,1)
C

C
C------------------------------------------------------------------------------
C_Build ABSOL_DATE
C
	IF (TARGET_WEEK_DAY.LT.NOW_WEEK_DAY) THEN
	  DELTA_DAY=(TARGET_WEEK_DAY+7)-NOW_WEEK_DAY
	ELSE IF (TARGET_WEEK_DAY.EQ.NOW_WEEK_DAY) THEN
	  IF (TARGET_TIME.GT.NOW_TIME) THEN
	    DELTA_DAY=0
	  ELSE
	    DELTA_DAY=7
	  END IF
	ELSE
	  DELTA_DAY=TARGET_WEEK_DAY-NOW_WEEK_DAY
	END IF
C
	CALL SET_MONTH_END(MONTH_END,NOW_MONTH,NOW_YEAR)
C
	TARGET_DAY=NOW_DAY+DELTA_DAY
	IF(TARGET_DAY.GT.MONTH_END)THEN
	  IF(NOW_MONTH.EQ.12)THEN
	    NOW_MONTH=0
	    NOW_YEAR=NOW_YEAR+1
	  END IF
	  NOW_MONTH=NOW_MONTH+1
	  TARGET_DAY=TARGET_DAY-MONTH_END
	END IF
C

C
C------------------------------------------------------------------------------
C_Set SYMBOL ABSOL_DATE
C
	LOG_VAR(1)=INT(TARGET_DAY/10)+48
	LOG_VAR(2)=TARGET_DAY-INT(TARGET_DAY/10)*10+48
C
	LOG_VAR(3)=INT(NOW_YEAR/1000)+48
C
	SAVE_YEAR=NOW_YEAR
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/1000)*1000
	LOG_VAR(4)=INT(NOW_YEAR/100)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/100)*100
	LOG_VAR(5)=INT(NOW_YEAR/10)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/10)*10
	LOG_VAR(6)=NOW_YEAR-INT(NOW_YEAR/10)*10+48
C
	ABSOL_STRING=CHAR_VAR(1:2)//'-'//MONTHS(NOW_MONTH)//'-'
     &		   //CHAR_VAR(3:6)//':'//TARGET_TIME_STRING
C
	ISTAT=LIB$SET_SYMBOL(ABSOL_SYMBOL_NAME,ABSOL_STRING,1)
C

C------------------------------------------------------------------------------
C_Set SYMBOL AK_DATE
C
C  If fiscal year has changed, then set AK_DATE to end of year
C
	IF (CURRENT_MONTH.EQ.END_FISCAL_MONTH) THEN
	  IF (NOW_MONTH.NE.END_FISCAL_MONTH) THEN
	    TARGET_DAY=END_FISCAL_DAY
	    NOW_MONTH=END_FISCAL_MONTH
	  END IF
	END IF
C
	NOW_YEAR=SAVE_YEAR
	LOG_VAR(1)=INT(TARGET_DAY/10)+48
	LOG_VAR(2)=TARGET_DAY-INT(TARGET_DAY/10)*10+48
C
	LOG_VAR(3)=INT(NOW_YEAR/1000)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/1000)*1000
	LOG_VAR(4)=INT(NOW_YEAR/100)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/100)*100
	LOG_VAR(5)=INT(NOW_YEAR/10)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/10)*10
	LOG_VAR(6)=NOW_YEAR-INT(NOW_YEAR/10)*10+48
C
	AK_DATE_STRING=CHAR_VAR(1:2)//'-'//MONTHS(NOW_MONTH)//'-'
     &		   //CHAR_VAR(3:6)//':'//TARGET_TIME_STRING
C
	ISTAT=LIB$SET_SYMBOL(AK_DATE_SYMBOL_NAME,AK_DATE_STRING,1)
C

C
C------------------------------------------------------------------------------
C_Build AK_START, set AK_FISCAL to "YES" if first day of new fiscal year
C
	NOW_YEAR=SAVE_YEAR
	NOW_MONTH=END_FISCAL_MONTH
	TARGET_DAY=END_FISCAL_DAY+1
	CALL SET_MONTH_END(MONTH_END,NOW_MONTH,NOW_YEAR)
	IF(TARGET_DAY.GT.MONTH_END)THEN
	  IF(NOW_MONTH.EQ.12)THEN
	    NOW_MONTH=0
	  END IF
	  NOW_MONTH=NOW_MONTH+1
	  TARGET_DAY=TARGET_DAY-MONTH_END
	END IF
C
	AK_FISCAL_STRING='NO'
	LOG_AK_FISCAL_STRING(3)=0
	IF (CURRENT_MONTH.EQ.NOW_MONTH.AND.NOW_DAY.EQ.TARGET_DAY) THEN
	    AK_FISCAL_STRING='YES'
	END IF
	ISTAT=LIB$SET_SYMBOL(AK_FISCAL_SYMBOL_NAME,AK_FISCAL_STRING,1)
C
	IF (CURRENT_MONTH.LE.END_FISCAL_MONTH) NOW_YEAR=NOW_YEAR-1
C
	LOG_VAR(1)=INT(TARGET_DAY/10)+48
	LOG_VAR(2)=TARGET_DAY-INT(TARGET_DAY/10)*10+48
C
	LOG_VAR(3)=INT(NOW_YEAR/1000)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/1000)*1000
	LOG_VAR(4)=INT(NOW_YEAR/100)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/100)*100
	LOG_VAR(5)=INT(NOW_YEAR/10)+48
C
	NOW_YEAR=NOW_YEAR-INT(NOW_YEAR/10)*10
	LOG_VAR(6)=NOW_YEAR-INT(NOW_YEAR/10)*10+48
C
	AK_START_STRING=CHAR_VAR(1:2)//'-'//MONTHS(NOW_MONTH)//'-'
     &		   //CHAR_VAR(3:6)
C
	ISTAT=LIB$SET_SYMBOL(AK_START_SYMBOL_NAME,AK_START_STRING,1)

C
C------------------------------------------------------------------------------
C_Build DELTA_DATE
C_Find number of days to TARGET day , save in DELTA_DAY and DELTA_TIME
C
	IF(TARGET_TIME.LT.NOW_TIME.AND.TARGET_WEEK_DAY.EQ.NOW_WEEK_DAY)THEN
	  DELTA_DAY=6
	  DELTA_TIME=24*3600-(NOW_TIME-TARGET_TIME)
	ELSE IF(TARGET_WEEK_DAY.LT.NOW_WEEK_DAY)THEN
	  DELTA_DAY=(TARGET_WEEK_DAY+7)-NOW_WEEK_DAY
	  IF(TARGET_TIME.LT.NOW_TIME)THEN
	    DELTA_DAY=DELTA_DAY-1
	    DELTA_TIME=24*3600-(NOW_TIME-TARGET_TIME)
	  ELSE
	    DELTA_TIME=TARGET_TIME-NOW_TIME
	  END IF
	ELSE
	  DELTA_DAY=TARGET_WEEK_DAY-NOW_WEEK_DAY
	  IF(TARGET_TIME.LT.NOW_TIME)THEN
	    DELTA_DAY=DELTA_DAY-1
	    DELTA_TIME=24*3600-(NOW_TIME-TARGET_TIME)
	  ELSE
	    DELTA_TIME=TARGET_TIME-NOW_TIME
	  END IF
	END IF
C
C------------------------------------------------------------------------------
C_Convert integer seconds to character string
C
	CALL INT_TIME_TO_STR(DELTA_TIME,DELTA_TIME_STRING)
C
C------------------------------------------------------------------------------
C_Set SYMBOL DELTA_DATE
C
	LOG_VAR(1)=DELTA_DAY+48
	IF(DELTA_DAY.EQ.0)THEN
	  DELTA_STRING=DELTA_TIME_STRING
	ELSE
	  DELTA_STRING=CHAR_VAR(1:1)//'-'//DELTA_TIME_STRING
	END IF
C
	DO I=1,11
	  IF(LOG_DELTA_STRING(I).EQ.' ')THEN
	   LOG_DELTA_STRING(I)=0
	  END IF
	END DO
C
	ISTAT=LIB$SET_SYMBOL(DELTA_SYMBOL_NAME,DELTA_STRING,1)
C
C------------------------------------------------------------------------------
C_Finished
C
	CALL EXIT
	END
C

C
C******************************************************************************
	SUBROUTINE TIME_STR_TO_SEC(TIME_STRING,TIME_SECS)
C******************************************************************************
C
C	  This Subroutine converts the time of day from a CHARACTER*8
C	variable string in the format  00:00:00  to an INTEGER*4 number
C	representing the elapsed seconds since mid-night.
C
C	TIME_STRING - (INPUT)  Character Variable
C	TIME_SECS   - (OUTPUT) Integer value
C
C	Written By : M. Serrer  DME/NRC  Systems Lab.
C	Date       : Nov/83
C
C------------------------------------------------------------------------------
C_Variable INITIALIZATION and DECLARATION
C
	CHARACTER*8 TIME_STRING,DUMMY
	LOGICAL*1 TIME_BYTE(8)
	INTEGER*4 TIME_SECS,HOURS,MINUTES,SECONDS
	EQUIVALENCE (TIME_BYTE,DUMMY)
C
	DUMMY=TIME_STRING
C
C------------------------------------------------------------------------------
C_Convert the string to SECONDS  and make sure all characters 
C_in the string are VALID.
C
	HOURS=((TIME_BYTE(1)-48)*10)+(TIME_BYTE(2)-48)
	 IF(HOURS.GT.24) GOTO 99
	MINUTES=((TIME_BYTE(4)-48)*10)+(TIME_BYTE(5)-48)
	 IF(MINUTES.GT.60) GOTO 99
	SECONDS=((TIME_BYTE(7)-48)*10)+(TIME_BYTE(8)-48)
	 IF(SECONDS.GT.60) GOTO 99
	TIME_SECS=SECONDS+(MINUTES*60)+(HOURS*3600)
C
	RETURN
C
  99	CALL LIB$STOP(TOFS__ILLT,%VAL(0))
	END
C

C
C******************************************************************************
	SUBROUTINE INT_TIME_TO_STR(TIME_SECS,TIME_STRING)
C******************************************************************************
C
C	  This Subroutine converts the time of day from an INTEGER*4
C	number representing the elapsed seconds since mid-night to
C	a CHARACTER*8 string in the format  00:00:00  
C	
C
C	TIME_SECS   - (INPUT) Integer value
C	TIME_STRING - (OUTPUT)  Character Variable
C
C	Written By : M. Serrer  DME/NRC  Systems Lab.
C	Date       : Nov/83
C
C------------------------------------------------------------------------------
C_Variable INITIALIZATION and DECLARATION
C
	CHARACTER*8 TIME_STRING,DUMMY
	LOGICAL*1 TIME_BYTE(8)
	INTEGER*4 TIME_SECS,HOURS,MINUTES,SECONDS
	EQUIVALENCE (TIME_BYTE,DUMMY)
C
C------------------------------------------------------------------------------
C_Convert seconds to HOURS,MINUTES,SECONDS
C
	HOURS=INT(TIME_SECS/3600)
	TIME_SECS=TIME_SECS-HOURS*3600
	MINUTES=INT(TIME_SECS/60)
	SECONDS=TIME_SECS-MINUTES*60
C
C------------------------------------------------------------------------------
C_Fill out string
C
	TIME_BYTE(1)=INT(HOURS/10)+48
	TIME_BYTE(2)=HOURS-INT(HOURS/10)*10+48
	TIME_BYTE(3)=58
	TIME_BYTE(4)=INT(MINUTES/10)+48
	TIME_BYTE(5)=MINUTES-INT(MINUTES/10)*10+48
	TIME_BYTE(6)=58
	TIME_BYTE(7)=INT(SECONDS/10)+48
	TIME_BYTE(8)=SECONDS-INT(SECONDS/10)*10+48
C
	TIME_STRING=DUMMY
C
	RETURN
	END

C
C----------------------------------------------------------------------
	SUBROUTINE SET_MONTH_END(MONTH_END,NOW_MONTH,NOW_YEAR)
C----------------------------------------------------------------------
C
	IMPLICIT INTEGER(A-Z)
	IF(NOW_MONTH.EQ.1)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.2)THEN
	  IF(INT(NOW_YEAR/4.0).EQ.(NOW_YEAR/4.0))THEN
	    MONTH_END=29
	  ELSE
	    MONTH_END=28
	  END IF
	ELSE IF(NOW_MONTH.EQ.3)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.4)THEN
	  MONTH_END=30
	ELSE IF(NOW_MONTH.EQ.5)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.6)THEN
	  MONTH_END=30
	ELSE IF(NOW_MONTH.EQ.7)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.8)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.9)THEN
	  MONTH_END=30
	ELSE IF(NOW_MONTH.EQ.10)THEN
	  MONTH_END=31
	ELSE IF(NOW_MONTH.EQ.11)THEN
	  MONTH_END=30
	ELSE IF(NOW_MONTH.EQ.12)THEN
	  MONTH_END=31
	END IF
	RETURN
	END
