 $!
 $! Establish a place to write scratch files.
 $!
 $ define scratch_dir sys$disk:[]
 $!
 $check_file:
 $ if p1 .nes "" then $ goto got_file
 $ inquire p1 "File"
	 $ goto check_file

 $got_file:
 $ file_name = f$parse (p1,,,"name")
 $!

 $! The ANALYZE/IMAGE will create a file with global symbols and
 $! routine names, plus a lot of other stuff.
 $!
 $ analyze/image/noheader/gst/nofixup/nopatch/output=scratch_dir:'file_name'.anl  -
    'p1'
 $!
 $! Extract just the information we will need (global symbols and 
 $! routine names).
 $!
 $ search/match=or/output='file_name'.1st_scan  scratch_dir:'file_name'.anl  -
            "symbol:", "entry mask", "value:"
 $ search/window=(0,1)/output=scratch_dir:'file_name'.symbols  -
          scratch_dir:'file_name'.1st_scan   "value:"
 $ search/window=(0,1)/output=scratch_dir:'file_name'.routines  -
          scratch_dir:'file_name'.1st_scan   "entry mask"
 $!
 $! Save just the routine names in a file.
 $!
 $ open/write symbol scratch_dir:'file_name'.routine_names
  $ open/read imgfile scratch_dir:'file_name'.routines
! $read_loop:
" $ read/end=imgfile_eof imgfile imgrec
# $ if f$locate ("entry mask",imgrec) .eq. f$length (imgrec) then $ goto read_loop
$ $ read imgfile imgrec
% $ rtn_name=imgrec-"symbol: " - """" - """" - "<HT><HT>"
& $ rtn_name=f$edit(rtn_name,"collapse")
' $ write symbol rtn_name
( $ goto read_loop
) $imgfile_eof:
* $ close imgfile
+ $ close symbol
, $!
- $! Begin constructing the macro source file, and reading
. $! the symbols.
/ $!
0 $ open/read symbol scratch_dir:'file_name'.symbols
1 $ rs := read/end=symbol_eof0 symbol
2 $ open/write code  'file_name'.mar
3 $ wc := write code
4 $ wc "	.TITLE	''file_name' fake to call real ''file_name'"
5 $ wc "	.IDENT	/1.0/"
6 $ wc "	.PSECT	''file_name'_DATA,RD,WRT,NOEXE,LONG,SHR,PIC"
7 $ wc "ADDR:	.BLKL	1"
8 $ wc "FILE:	.ASCID	/''file_name'/
9 $symb_loop:
: $ rs rec
; $ val = f$element (1," ",rec)
< $ rs rec
= $ rec_len = f$length (rec)
> $ if f$locate ("entry mask:",rec) .eqs. rec_len then $ goto got_a_symbol
? $ goto symb_loop
@ $got_a_symbol:
A $ sym = f$element (1," ",rec) - """" - """"
B $ tab = ""
C $ if rec_len .lt. 26 then $ tab[0,8] = 9
D $ wc "''sym'	''tab'== ''val'"
E $ goto symb_loop
F $symbol_eof0:
G $ close symbol
H $!
I $! Now build the rest of the macro file, using the routine names.
J $!
K $ open/read symbol scratch_dir:'file_name'.routine_names
L $ rs := read/end=symbol_eof1 symbol
M $ sym_cnt = 1
N $data_loop:
O $ rs rtn_name
P $ wc "SYM''sym_cnt':	.ASCID	/''rtn_name'/
Q $ sym_cnt = sym_cnt + 1
R $ goto data_loop
S $symbol_eof1:
T $ close symbol
U $ open/read symbol scratch_dir:'file_name'.routine_names
V $ rs := read/end=symbol_eof2 symbol
W $ wc "	.PSECT	''file_name'_CODE,RD,NOWRT,EXE,LONG,SHR,PIC"
X $ sym_cnt = 1
Y $code_loop:
Z $ rs rtn_name
[ $ wc "	.ENTRY	''rtn_name',^M<R2,R3,R4,R5,R6,R7,R8,R9,R10,R11>"
\ $ wc "	PUSHAL	ADDR"
] $ wc "	PUSHAL	SYM''sym_cnt'"
^ $ wc "	PUSHAL	FILE"
_ $ wc "	CALLS	#3,G^LIB$FIND_IMAGE_SYMBOL"
` $ wc "	CALLG	(AP),@ADDR
a $ wc "	MOVL	#1,R0
b $ wc "	RET"
c $ sym_cnt = sym_cnt + 1
d $ goto code_loop
e $symbol_eof2:
f $ wc "	.END"
g $ close symbol
h $ close code
i $ delete scratch_dir:'file_name'.anl;*
j $ delete scratch_dir:'file_name'.routines;*
k $ delete scratch_dir:'file_name'.symbols;*
l $ delete scratch_dir:'file_name'.routine_names;*
m $ delete scratch_dir:'file_name'.1st_scan;*
n $ exit
o $!++
p $!
q $! Title:
r $!	BLD_DYM.COM - Build a routine to support dynamic linking.
s $!
t $! Version:
u $!	1.0
v $!
w $! Facility:
x $!	Support dynamic linking.
y $!
z $! Abstract:
{ $!	This procedure parses the output of an ANALYZE/IMAGE of a
| $!	shareable image, to construct a macro source program, that
} $!	can be used to dynamically link the shareable image. This
~ $!	procedure extracts the global symbols and routine names
 $!	from the shareable image, and builds the appropriate calls
 $!	to LIB$FIND_IMAGE_SYMBOL.
 $!
 $!	This macro file can be assembled and linked to the application
 $!	program, instead of linking the shareable image.
 $!
 $! Environment:
 $!	No special privileges.
 $!
 $! Author:
 $!	Mark Oakley	Battelle Memorial Institute	18-Sep-1986
 $!
 $! Modified:
 $!	
 $!
 $!--
