
	integer function write_it
	2  (grp_uic, mem_uic, b_used, b_alloc, file_name, file_num,
	3   dir_name, file_seq, file_rvn_by_value)
c..
c..	Routine to output file id, blocks used and allocated,
c..	group and member uic, file name, and directory spec.
c..

	parameter	max_file_name_length = 85

	byte		file_name(max_file_name_length)

	character	dir_name*(*)

	integer*2	file_num
	integer*2	file_seq
	integer*2	file_rvn
	integer*4	b_alloc
	integer*4	b_used
	integer*2	mem_uic
	integer*2	grp_uic

	integer*4	total_alloc
	integer*4	total_used
	integer*4	total_files
	integer*4	blks_alloc
	integer*4	blks_used
	integer*2	used(2)
	integer*2	alloc(2)
	integer*2	tmp
	integer*4	p, s
	integer*4	file_name_len

	logical*4	first_call
	logical*4	full

	common /pflags/ first_call, full
	common /totals/ total_alloc, total_used, total_files


	equivalence	(blks_alloc,alloc)
	equivalence	(blks_used,used)

	data first_call/.true./
	data total_alloc/0/
	data total_used/0/

	file_name_length = 0

	do while (file_name (file_name_length) .ne. ' ')  ! Determine file name
		file_name_length = file_name_length + 1   ! length.
		enddo

	file_rvn = %loc (file_rvn_by_value)	! This was passed by value,
						! need to get the real thing.

	blks_used = b_used		! Need to swap lo and hi words. They
	tmp     = used(1)		! are stored this in the file header
	used(1) = used(2)		! for PDP-11 compatibility.
	used(2) = tmp

	blks_alloc = b_alloc		! Swap again.
	tmp      = alloc(1)
	alloc(1) = alloc(2)
	alloc(2) = tmp

	if (first_call) then		! Write the headings on the first call.
		open (unit=6, recl=255, status='OLD')
		if (.not.full) write (6,5)
		if (full)      write (6,6)
		first_call = .false.
		endif

	if (blks_used .gt. blks_alloc) blks_alloc = blks_used

	p = 1				! Figure field size for blocks
					! allocated.
	if (blks_alloc .gt. 0) p = log10(float(blks_alloc)) + 1
	s = 7 - p

	if (full) then

		write (6, 8) file_num, file_seq, file_rvn, blks_used, 
	2		     blks_alloc, grp_uic, mem_uic, dir_name,
	2		     (file_name(ii),ii=1,file_name_length)
8		format (1h , '(', i5.5, ',',i3.3, ',',i1, ')', 1x, 
	2	       i6,'/',i<p>,<s>x, '[',o3.3,',',o3.3,']',1x, a, 85a1)

                   else

	write (6,10) file_num, blks_used, blks_alloc, grp_uic,
	2	     mem_uic, (file_name(ii),ii=1,20), dir_name
10	format (1h , i5,1x, i6,'/',i<p>,<s>x, '[',o3.3,',',o3.3,']',
	2       1x, 20a1,1x, a)

		   endif

	total_alloc = total_alloc + blks_alloc
	total_used  = total_used  + blks_used
	total_files = total_files + 1

	write_it = 1			! Assume success.
	return



5	format(1h1,' File    Blocks      Owner     File',
	2	           '                Directory',/,
	3	       1h ,'  Id    Used/Alloc   (UIC)     Name',/)

6	format(1h1,'    File          Blocks      Owner     ',
	2          'Directory and File Name', /, 1h ,
	3          '     Id         Used/Alloc    (UIC)', /)

	end

	integer function write_totals

	integer*4	p
	integer*4	total_alloc
	integer*4	total_used
	integer*4	total_files

	common /totals/ total_alloc, total_used, total_files

	p = 1
	if (total_alloc .gt. 0) p = log10(float(total_alloc)) + 1

	write (6,50) total_used, total_alloc, total_files
50	format (1h0,'Total ', i6,'/',i<p>, ' , total files = ', i6)

	write_totals = 1
	return

	end
