 	PROGRAM VBN
 C++
 C
 C Title:
 C	VBN.FOR - Modify a file, given a vbn into the file.
 C
 C Version:
 C	1.0
	 C

 C Facility:
 C	Editor.
 C

 C Abstract:
 C	This program edits the contents of a file, given the file-spec,
 C	vbn into the file, and offset into the vbn.
 C
 C Environment:
 C	Read/write access required to specified file.
 C
 C Author:
 C	Mark Oakley	Battelle Memorial Institute	04-Apr-1986
 C
 C Modified:
 C	
 C 26-Jun-1986	Mark Oakley	Corrected call to use SYS$QIOW.
 C
 C--
 
 	INCLUDE		'($SYSSRVNAM)/NOLIST'	! System service definitions.
 	INCLUDE		'($DCDEF)/NOLIST'	! Symbols for device classes.
 	INCLUDE		'($DVIDEF)/NOLIST'	! Symbols for $GETDVI's.
  	INCLUDE		'($FABDEF)/NOLIST'	! Symbols for File access block.
! 	INCLUDE		'($IODEF)/NOLIST'	! Symbols for $QIO's.
" 
# 	STRUCTURE /CHAR_BUF_STRUC/		! Structure to hold/set
$ 		BYTE		CLASS		! terminal characteristics.
% 		BYTE		TYPE
& 		INTEGER*2	PAGE_WIDTH
' 		INTEGER*4	REM
( 		END STRUCTURE
) 
* 	STRUCTURE /DVI_ITMLST_STRUC/		! Structure for GETDVI call,
+ 		INTEGER*2	BUF_SIZ		! to get device type.
, 		INTEGER*2	CODE
- 		INTEGER*4	BUF_ADDR
. 		INTEGER*4	RET_LEN
/ 		INTEGER*4	TERMINATOR
0 		END STRUCTURE
1 
2 	RECORD /CHAR_BUF_STRUC/ CHAR_BUF	! Terminal characteristics.
3 
4 	RECORD /DVI_ITMLST_STRUC/ DVI_ITMLST
5 
6 	RECORD /FABDEF/ FILE_FAB		! FAB for file we mangle.
7 
8 	BYTE		BUFFER(512)		! Put the block we want, here.
9 	BYTE		ASCII_BUF(512)		! Only printable char here.
: 	BYTE		REC(80)			! Input from terminal.
; 	CHARACTER	ASCII_REC*80		! Ditto.
< 	CHARACTER	FILE_NAME_BUF*256	! File we want to mangle.
= 	INTEGER*4	COL			! Column, used for printing.
> 	INTEGER*4	ROW			! Row, ditto.
? 	INTEGER*4	DEVCLASS		! Class of device (disk,etc.)
@ 	INTEGER*4	FILE_NAME_LEN		! Lenghth of file name.
A 	INTEGER*4	STATUS			! System service return status.
B 	INTEGER*4	CHANNEL			! Channel to SYS$OUTPUT.
C 	INTEGER*4	VBN_NR			! Block number to read/write.
D 	INTEGER*4	IOSB(2)			! Status from sys. serv.
E 	INTEGER*4	OFFSET			! Offset into block to mangle.
F 	INTEGER*4	REC_LEN			! Input record length.
G 
H 	INTEGER*4	STR$UPCASE		! RTL routine to uppercase.
I 
J 	EQUIVALENCE (REC,ASCII_REC)
K 
L 	STATUS = SYS$ASSIGN ('SYS$INPUT',	! Get a channel to what we are
M 	2                    CHANNEL,		! listening to.
N 	3                     ,
O 	4                     )
P 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
Q 
R 	DVI_ITMLST.BUF_SIZ    = 4		! Determine what we are 
S 	DVI_ITMLST.CODE       = DVI$_DEVCLASS	! to (disk,terminal,etc.).
T 	DVI_ITMLST.BUF_ADDR   = %LOC(DEVCLASS)
U 	DVI_ITMLST.RET_LEN    = 0
V 	DVI_ITMLST.TERMINATOR = 0
W 	STATUS = SYS$GETDVI ( ,
X 	2                    %VAL(CHANNEL),
Y 	3                     ,
Z 	4                    DVI_ITMLST,
[ 	5                    IOSB,
\ 	6                     ,
] 	7                     ,
^ 	8                     )
_ 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
` 	STATUS = IOSB(1)
a 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
b 
c 	IF (DEVCLASS .EQ. DC$_TERM) THEN	! If it's a terminal, then
d 		STATUS = SYS$QIOW ( ,		! get the screen length.
e 	2	                   %VAL(CHANNEL),
f 	3	                   %VAL(IO$_SENSEMODE),
g 	4	                   IOSB,
h 	5                           ,
i 	6                           ,
j 	1                          CHAR_BUF,
k 	2                          %VAL(8),
l 	3	                    ,
m 	4	                    ,
n 	5	                    ,
o 	6	                    )
p 		IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
q 		STATUS = IOSB(1)
r 		IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
s 		END IF
t 
u 	STATUS = SYS$DASSGN ( %VAL(CHANNEL))	! Don't need the channel now.
v 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
w 	CHANNEL = -1
x 
y 	ROW = 32		! Assume 80 column output device, until we
z 	COL = 16		! determine otherwise.
{ 	IF (CHAR_BUF.PAGE_WIDTH .EQ. 132) THEN
| 		ROW = 16	! Output device is 132 columns, adjust row
} 		COL = 32	! and column accordingly.
~ 		ENDIF
 	COLM1 = COL - 1
 
 5	WRITE (6,10)		! Prompt for a file to mangle.
 10	FORMAT ('$Enter file spec: ')
 	READ (5,20) FILE_NAME_LEN, FILE_NAME_BUF
 20	FORMAT (Q,A)
 	IF (FILE_NAME_LEN .EQ. 0) CALL SYS$EXIT (%VAL(10000001))
 
 	IF (CHANNEL .NE. -1) THEN	! Get rid of the channel, if we have
 		STATUS = SYS$DASSGN ( %VAL(CHANNEL))	! not yet done this.
 		IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 		END IF
 
 	FILE_FAB.FAB$B_BID = FAB$C_BID	! Setup to access the file via QIO.
 	FILE_FAB.FAB$B_BLN = FAB$C_BLN
 	FILE_FAB.FAB$B_FAC = FILE_FAB.FAB$B_FAC .OR. FAB$M_PUT
 	FILE_FAB.FAB$L_FOP = FAB$M_UFO
 	FILE_FAB.FAB$L_FNA = %LOC (FILE_NAME_BUF)
 	FILE_FAB.FAB$B_FNS = FILE_NAME_LEN
 	STATUS = SYS$OPEN (FILE_FAB)
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 	CHANNEL = FILE_FAB.FAB$L_STV
 
 25	WRITE (6,30)		! Prompt for a virtual block number.
 30	FORMAT ('$Enter VBN (decimal): ')
 	READ (5,40) REC_LEN,VBN_NR
 40	FORMAT (Q,I5)
 	IF (REC_LEN .EQ. 0) GOTO 5
 	STATUS = SYS$QIOW ( , 		! Now, read that block.
 	2                  %VAL(CHANNEL), 
 	3                  %VAL(IO$_READVBLK),
 	4                  IOSB,
 	5                   ,
 	6                   ,
 	1                  BUFFER,
 	2                  %VAL(512),
 	3                  %VAL(VBN_NR),
 	4                   ,
 	5                   ,
 	6                   )
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 	STATUS = IOSB (1)
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 
 	DO 55 I=1,512			! Print that block, replacing non-
 	ASCII_BUF(I) = BUFFER(I)	! printables with a period.
 	IF (BUFFER(I) .LT.  32) ASCII_BUF(I) = 46
 	IF (BUFFER(I) .GT. 126) ASCII_BUF(I) = 46
 55	CONTINUE
 	WRITE (6,60) (I,I=0,COLM1)
 60	FORMAT (1H0,3X,<COL>(1X,Z2.2),/)
 	I1 = 1
 	DO 90 J = 1,ROW
 	I2 = I1 + COLM1
 	WRITE (6,70) (J-1)*COL,(BUFFER(I),I=I1,I2),(ASCII_BUF(I),I=I1,I2)
 70	FORMAT (1H ,Z3.3,<COL>(1X,Z2.2),1X,<COL>A1)
 90	I1 = I2 + 1
 
 	WRITE (6,120)		! Prompt for where in block we want to start
 120	FORMAT (/,'$Enter offset (hex): ')	! mangling.
 	READ (5,130) REC_LEN,OFFSET
 	IF (REC_LEN .EQ. 0) GOTO 25
 130	FORMAT (Q,Z5.0)
 	OFFSET = OFFSET + 1
 	DO 135  I = 1,80
 135	REC(I) = 32
 	WRITE (6,140)		! Prompt for value to mangle with.
 140	FORMAT ('$Enter new value (hex or ascii): ')
 	READ (5,150) REC_LEN,(REC(I),I=1,REC_LEN)
 150	FORMAT (Q,80A1)
 	IF (REC(1) .EQ. '''') THEN 	! If it starts with a single quote,
 		DO 200 I = 2,REC_LEN-1	! assume we have character input.
 			BUFFER(OFFSET) = REC(I)
 			ASCII_BUF(OFFSET) = REC(I)
 			OFFSET = OFFSET + 1
 200			CONTINUE
 	ELSE
 		READ (ASCII_REC,'(Z2)') J	! Not string input, 
 		BUFFER(OFFSET) = J		! must be hex.
 		ASCII_BUF(OFFSET) = J
 		IF (J .LT.  32) ASCII_BUF(OFFSET) = 46
 		IF (J .GT. 126) ASCII_BUF(OFFSET) = 46
 	ENDIF
 		
 	I1 = 1
 	DO 220 J = 1,ROW
 	I2 = I1 + COLM1
 	WRITE (6,70) (J-1)*COL,(BUFFER(I),I=I1,I2),(ASCII_BUF(I),I=I1,I2)
 220	I1 = I2 + 1
 
 	WRITE (6,250)		! Prompt to see if we really want to mangle.
 250	FORMAT (/,'$Ok to write back to file (Y/N)? ')
 	READ (5,'(A)') ASCII_REC
 	STATUS = STR$UPCASE (ASCII_REC, ASCII_REC)
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 	IF (ASCII_REC(1:1) .NE. 'Y') CALL SYS$EXIT (%VAL(1))
 
 	STATUS = SYS$QIOW ( , 		! Mangle the file.
 	2                  %VAL(CHANNEL), 
 	3                  %VAL(IO$_WRITEVBLK),
 	4                  IOSB,
 	5                   ,
 	6                   ,
 	1                  BUFFER,
 	2                  %VAL(512),
 	3                  %VAL(VBN_NR),
 	4                   ,
 	5                   ,
 	6                   )
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 	STATUS = IOSB (1)
 	IF (.NOT. STATUS) CALL SYS$EXIT (%VAL(STATUS))
 
 	GOTO 25
 
 	END
