C***********************************************************************
C
C  PROGRAM MEASSTAT
C
C  Calculate statistical information from individual measurements.
C
C  18-Feb-1985 / JA Lloyd
C    Add calculation of 80 percentile
C  14-Feb-1985 / JA Lloyd
C    Transform data in another way
C  20-Dec-1984 / JA Lloyd
C
C  INPUTS
C
C  OUTPUTS
C
C  COMMON
C
C  SUBROUTINES CALLED
C
C  FILES
C    MEASURE - input of raw, sorted by hour then measurement magnitude
C    DISKRESP - output of processed
C
C***********************************************************************
C
	PROGRAM MEASSTAT
C
	parameter	maxdev = 8
	parameter	percentile = 80
	parameter	maxdays = 100
C
	character*80	inline
	integer		inlen
	integer		hour
	character*5	device
	integer		c, i, j, jprime
	integer		sum(24,maxdev)
	integer		cnt(24,maxdev)
	integer		lrg(24,maxdev)
	integer		ssq(24,maxdev)
	integer		pct(maxdays,24,maxdev)
	character*(4) 	csum(24,maxdev)
	character*(4) 	ccnt(24,maxdev)
	character*(4) 	clrg(24,maxdev)
	character*(4) 	cssq(24,maxdev)
	character*(4)	cpct(maxdays,24,maxdev)
	character*(4)	cj
	equivalence (csum(1,1), sum(1,1))
	equivalence (ccnt(1,1), cnt(1,1))
	equivalence (clrg(1,1), lrg(1,1))
	equivalence (cssq(1,1), ssq(1,1))
	equivalence (cpct(1,1,1), pct(1,1,1))
	equivalence (cj, jprime)
	character*5	list(maxdev)
	integer		listlen
	integer		s,p
C
	listlen=0
	s=loc_iofast$open(1,'MEASURE_FILE','.DAT')
	if( .not. s ) call lib$signal( %val(s) )
C
	s=loc_iofast$get(1,inline,len)
	do while (s)
	read( inline(:len), 9, err=10 ) hour, device, c
9	format( 12x, i2, 10x, a5, i9 )
	list(listlen+1)=device
	i=1
	   do while( device .ne. list(i) )
	   i=i+1
	   end do
	if( i .gt. listlen ) listlen = i
C
	sum( hour+1, i ) = sum( hour+1, i ) + c
	cnt( hour+1, i ) = cnt( hour+1, i ) + 1
	pct( cnt(hour+1,i), hour+1, i ) = c
	if( c .gt. lrg( hour+1, i ) ) lrg(hour+1,i) = c
C**	ssq( hour+1, i ) = ssq( hour+1, i ) + c*c
10	s=loc_iofast$get(1,inline,len)
	end do
	s=loc_iofast$openw( 2, 'MEASSTAT_FILE', '.DAT' )
	do i = 1, listlen
	   do j=1,24
	   jprime = j - 1
	   p = max( 1, (percentile * cnt(j,i) + 50) / 100 )
	   s=loc_iofast$put( 2, cj // list(i) // csum(j,i) // 
     *  					 CCNT(j,i) // 
     *  					 CLRG(j,i) //
     *  					 CPCT(p,j,i)
     *  		    )
	   end do
	end do
	end
