$! ************************************************************************
$! ***									***
$! ***	CLOSE_VMS_ACCT.COM						***
$! ***	Automatically closes the VAX/VMS system accounting file		***
$! ***	every monthend.							***
$! ***									***
$! ************************************************************************
$!
$!
$!
$	set	noon
$	set	process -
		/priv = ( bypass, oper )
$!
$	set	accounting -
		/new
$!
$	set	accounting -
		/disable = login_failure
$!
$	request	"VAX/VMS SYSTEM ACCOUNTING FILE CLOSED.  NEW FILE OPENED."
$!
$!
$!
$!
$! Move and rename the old file
$!
$	set	default -
		sys$manager
$!
$	creation_date = f$file_attributes( "accountng.dat;-1", "cdt" )
$	creation_date_2 = f$cvtime( creation_date )
$	new_file_name = f$extract( 2, 2, creation_date_2 ) + -
			f$extract( 5, 2, creation_date_2 ) + -
			".DAT"
$!
$	rename	accountng.dat;-1 -
		'new_file_name'
$!
$!
$!
$! Do it again next month.
$!
$	this_month_year = f$extract ( 3, 8, f$time ( ) )
$	this_month = f$extract ( 0, 3, this_month_year )
$	this_year = f$integer ( f$extract ( 4, 4, this_month_year ) )
$!
$	if this_month .nes. "JAN" then goto feb
$	next_month = "FEB"
$	goto submit_job
$!
$ feb:
$	if this_month .nes. "FEB" then goto mar
$	next_month = "MAR"
$	goto submit_job
$!
$ mar:
$	if this_month .nes. "MAR" then goto apr
$	next_month = "APR"
$	goto submit_job
$!
$ apr:
$	if this_month .nes. "APR" then goto may
$	next_month = "MAY"
$	goto submit_job
$!
$ may:
$	if this_month .nes. "MAY" then goto jun
$	next_month = "JUN"
$	goto submit_job
$!
$ jun:
$	if this_month .nes. "JUN" then goto jul
$	next_month = "JUL"
$	goto submit_job
$!
$ jul:
$	if this_month .nes. "JUL" then goto aug
$	next_month = "AUG"
$	goto submit_job
$!
$ aug:
$	if this_month .nes. "AUG" then goto sep
$	next_month = "SEP"
$	goto submit_job
$!
$ sep:
$	if this_month .nes. "SEP" then goto oct
$	next_month = "OCT"
$	goto submit_job
$!
$ oct:
$	if this_month .nes. "OCT" then goto nov
$	next_month = "NOV"
$	goto submit_job
$!
$ nov:
$	if this_month .nes. "NOV" then goto dec
$	next_month = "DEC"
$	goto submit_job
$!
$ dec:
$	next_month = "JAN"
$	this_year = this_year + 1
$!
$!
$!
$ submit_job:
$	submit	ci$command:close_vms_acct -
		/queue = sys$batch -
		/after = "01-''next_month'-''f$string ( this_year )'"
