$! ********************************************************
$! ***							***
$! ***	INIT_DIALUPS.COM				***
$! ***	Initializes the dialup modem to quiet mode	***
$! ***	(no RING or CONNECT messages sent to VMS)	***
$! ***							***
$! ***	This is a self-submitting batch job.		***
$! ***							***
$! ***	It is submitted often (not just at system	***
$! ***	startup) because the modem could become reset	***
$! ***	after a power-failure or other event.		***
$! ***							***
$! ********************************************************
$!
$!
$! *** Do it again.	***
$!
$	SUBMIT	CI$COMMAND:INIT_DIALUPS -
		/QUEUE = SYS$BATCH -
		/AFTER="+0-1:0:0" -
		/NOLOG
$!
$!
$	SET NOON
$	SET PROCESS /PRIVILEGE=ALL
$!
$!
$!	Initialize the dialup modem to quiet mode
$!	(no RING or CONNECT messages sent to VMS)
$!
$	DIALUP_LINE_NUMBER = 0
$!
$ DIALUP_INITIALIZATION_LOOP:
$	DIALUP_LINE_NUMBER = DIALUP_LINE_NUMBER + 1
$	IF F$LOGICAL ( "CI$DIALUP_''DIALUP_LINE_NUMBER'" ) .EQS. "" -
		THEN GOTO DONE_INITIALIZING_DIALUPS
$	WRITE SYS$OUTPUT ""
$	WRITE SYS$OUTPUT "Initializing CI$DIALUP_''DIALUP_LINE_NUMBER':"
$	ALLOCATE CI$DIALUP_'DIALUP_LINE_NUMBER' DIALUP
$	IF .NOT. $STATUS THEN GOTO DIALUP_INITIALIZATION_LOOP
$!
$	SET TERM /SPEED=300 DIALUP
$	RUN CI$IMAGES:DIALUPINI
$	DEALLOCATE DIALUP
$	GOTO DIALUP_INITIALIZATION_LOOP
$!
$ DONE_INITIALIZING_DIALUPS:
$	EXIT
