$! ***********************************************************************
$! **									**
$! **	ci$command:laser2.com						**
$! **									**
$! **	Send text files to laser$print_2 and laser$print_1		**
$! **									**
$! ***********************************************************************
$!
$	set control = y
$!
$	space = " "
$!
$!
$ get_file_name:
$	on	control_y then goto exit
$	write	sys$output "[2J[1;1H#6[1mSend a File to the Letterhead Printer[0m"
$ prompt_for_filename:
$	write	sys$output ""
$	write	sys$output "(Press RETURN to exit.)"
$	write	sys$output ""
$	inquire /nopunc filename "Filename:    "
$	if	filename .eqs. "" then goto exit
$	full_filename = f$parse ( filename, "." )
$	open	test_file 'full_filename' -
		/read -
		/error = file_error
$!
$	close	test_file
$	define	ci$input	'full_filename' -
		/user
$	goto	request_command
$!
$ file_error:
$	write	sys$output "''f$message ( $status )'"
$	goto	prompt_for_filename
$!
$!
$!
$ request_command:
$	on	control_y then goto get_file_name
$	write	sys$output "[2J[1;1H#6[1mSend a File to the Letterhead Printer[0m"
$	write	sys$output ""
$	write	sys$output "Filename:    [1m''FILENAME'[0m"
$	write	sys$output ""
$	write	sys$output "[1m  1[0m  Exit"
$	write	sys$output "[1m  2[0m  Send to the printer"
$	write	sys$output "[1m  3[0m  Output a different file"
$	write	sys$output ""
$	inquire /nopunc command_type "     Your choice?  "
$!
$	if	command_type .eqs. "" then goto request_command
$	if	f$extract ( 0, 1, command_type ) .eqs. "1" then goto exit
$	if	f$extract ( 0, 1, command_type ) .eqs. "2" then goto laser
$	if	f$extract ( 0, 1, command_type ) .eqs. "3" then goto get_file_name
$	write	sys$output "[2J[8;1H#6[1m            ''command_type' ?[0m"
$	write	sys$output ""
$	inquire /nopunc command_type "[22;1H[7mPress RETURN when ready[0m"
$	goto	request_command
$!
$!
$!
$ laser:
$	on	control_y then goto request_command
$	write	sys$output "[2J[1;1H#6[1mSend a File to the Letterhead Printer[0m"
$	write	sys$output ""
$	write	sys$output "Filename:    [1m''filename'[0m"
$	write	sys$output ""
$!
$	define	ci$input	'full_filename' -
		/user
$!
$ get_page_format:
$	inquire /nopunc page_format		"Page format (portrait or landscape) [portrait]:  "
$	if	page_format .eqs. "" -
	then -
		page_format = "P"
$	if	f$extract ( 0, 1, page_format ) .eqs. "P" -
	then -
		goto	got_page_format
$!
$	if	f$extract ( 0, 1, page_format ) .eqs. "L" -
	then -
		goto	got_page_format
$!
$	write	sys$output "Please enter a valid page format."
$	goto	get_page_format
$!
$ got_page_format:
$!
$ get_margins:
$	inquire /nopunc top_margin		"Top margin (lines) [6]:                          "
$	if	top_margin .eqs. "" then top_margin = "6"
$!
$	inquire /nopunc left_margin		"Left margin (characters) [10]:                   "
$	if	left_margin .eqs. "" then left_margin = "10"
$!
$ get_pitches:
$	if	f$extract ( 0, 1, page_format ) .eqs. "P" -
	then -
		best_default_vertical_pitch = 6
$!
$	if	f$extract ( 0, 1, page_format ) .eqs. "L" -
	then -
		best_default_vertical_pitch = 8
$!
$	inquire /nopunc vertical_pitch		"Vertical pitch (lines per inch) [''best_default_vertical_pitch']:             "
$	if	vertical_pitch .eqs. "" then vertical_pitch = "''best_default_vertical_pitch'"
$!
$	inquire /nopunc horizontal_pitch	"Horizontal pitch (characters per inch) [12]:     "
$	if	horizontal_pitch .eqs. "" then horizontal_pitch = "12"
$!
$ get_text_lines_per_page:
$	if	f$extract ( 0, 1, page_format ) .eqs. "P" -
	then -
		vertical_inches = 10
$!
$	if	f$extract ( 0, 1, page_format ) .eqs. "L" -
	then -
		vertical_inches = 8
$!
$	best_default_text_lines = vertical_inches * vertical_pitch - top_margin
$	inquire /nopunc text_lines		"Text lines per page [''best_default_text_lines']:                        "
$	if	text_lines .eqs. "" then text_lines = "''best_default_text_lines'"
$!
$ get_type_family:
$	inquire /nopunc type_family		"Type-family (DEC, Courier, or Elite) [DEC]:      "
$	if	type_family .eqs. "" -
	then -
		type_family = "DEC"
$!
$	if	f$extract ( 0, 1, type_family ) .nes. "D" -
	then -
		goto check_courier
$!
$	type_family = "DBULTN1"
$	goto	got_type_family
$!
$ check_courier:
$	if	f$extract ( 0, 1, type_family ) .nes. "C" -
	then -
		goto check_elite
$!
$	type_family = "RCOURIR"
$	goto	got_type_family
$!
$ check_elite:
$	if	f$extract ( 0, 1, type_family ) .nes. "E" -
	then -
		goto	report_bad_type_family
$!
$	type_family = "RELITE0"
$	goto	got_type_family
$!
$ report_bad_type_family:
$	write	sys$output "Please enter a valid type-family."
$	goto	get_type_family
$!
$ got_type_family:
$!
$ check_valid_type_size_for_elite:
$	if	type_family .nes. "RELITE0" -
	then -
		goto	get_type_size
$!
$	write	sys$output "For the Elite type-family, 10-point is the only supported type size."
$	type_size = "10"
$	goto	got_type_size
$!
$ get_type_size:
$	inquire /nopunc type_size		"Type-size in points (6.7 or 10) [10]:            "
$	if	type_size .eqs. "" -
	then -
		type_size = "10"
$!
$	if	type_size .eqs. "10" -
	then -
		goto	got_type_size
$!
$	if	type_size .eqs. "6.7" -
	then -
		goto	got_type_size
$!
$	write	sys$output "Please enter a valid type-size."
$	goto	get_type_size
$!
$ got_type_size:
$!
$ get_secondary_paging:
$	inquire /nopunc secondary_output_file	"Send second and subsequent pages to the plain-bond printer [yes]:  "
$	if	secondary_output_file .eqs. ""	then	secondary_output_file = "T"
$	if	secondary_output_file		then	secondary_output_file = "T"
$	if	.NOT. secondary_output_file	then	secondary_output_file = "F"
$!
$!
$ get_copies:
$	inquire /nopunc copies			"Number of copies [1]:                            "
$	if	copies .eqs. "" then copies = "1"
$	copies = f$integer ( copies )
$	if	copies .gt. 0 -
		.and. -
		copies .le. 100 -
	then -
		goto	run_the_enpage_utility
$!
$	write	sys$output "Please choose between 1 and 100 copies."
$	goto	get_copies
$!
$!
$!
$!
$ run_the_enpage_utility:
$	write	sys$output ""
$	write	sys$output "Working . . ."
$	write	sys$output ""
$!
$	username := 'f$getjpi ( "", "username" )
$	ascii_time	=	  f$time ( )
$	current_time	=	  f$cvtime ( ascii_time )
$	if	f$extract ( 0, 1, current_time ) .eqs. space -
	then -
		current_time[0,1] := "0"
$	filename_root	=	username -
				+ "_" -
				+ f$extract( 2, 2, current_time ) -
				+ f$extract( 5, 2, current_time ) -
				+ f$extract( 8, 2, current_time ) -
				+ "_" -
				+ f$extract(11, 2, current_time ) -
				+ f$extract(14, 2, current_time ) -
				+ f$extract(17, 2, current_time )
$!
$	define	ci$output	ci$workfiles:'filename_root'_2.lis -
		/user
$!
$	define	ci$output_2	ci$workfiles:'filename_root'_1.lis -
		/user
$!
$	enpage	:= $ci$images:enpage
$	enpage	'left_margin' 'top_margin' 'text_lines' TRUE 'secondary_output_file' -
		'vertical_pitch' 'horizontal_pitch' 'page_format' 'type_family' 'type_size'
$	write	sys$output ""
$!
$	print	ci$workfiles:'filename_root'_2.lis -
		/queue = laser$print_2 -
		/form = letter1 -
		/copies = 'copies' -
		/nofeed -
		/notify -
		/delete
$!
$	if	secondary_output_file -
		.and. -
		f$search ( "ci$workfiles:''filename_root'_1.lis" ) .nes. "" -
	then -
		print	ci$workfiles:'filename_root'_1.lis -
			/queue = laser$print_1 -
			/form = plain_bond -
			/copies = 'copies' -
			/nofeed -
			/notify -
			/delete
$!
$	write	sys$output ""
$!
$	inquire /nopunc pause "[7mDone.  Press RETURN when ready[0m"
$	goto	request_command
$!
$!
$!
$ exit:
$!	set	term /width = 80
$	exit
