$! ********************************************************
$! ***							***
$! ***	VMSDOWNUP.COM					***
$! ***							***
$! ***	Shuts down VMS, and brings it back up.		***
$! ***							***
$! ***	This is submitted as a batch job on HOLD	***
$! ***	status.  The operators can release this job	***
$! ***	if they need to shut the system down.		***
$! ***	Thus, they don't need the privileges normally	***
$! ***	required to shut down the system.		***
$! ***							***
$! ***	Since shutting down the system zaps the batch	***
$! ***	queues, this job runs itself as a detached	***
$! ***	process.					***
$! ***							***
$! ********************************************************
$!
$	set	process /priv = all
$	if	f$mode ( ) .nes. "BATCH" then goto not_batch
$!
$! ***  Do it again.  ***
$!
$	submit	ci$command:vmsdownup.com -
		/queue = normal$batch -
		/hold -
		/nolog
$!
$ determine_opa0_status:
$	opa0_already_allocated = f$getdvi ( "_opa0:", "ALL" )
$	if	.not. opa0_already_allocated -
	then -
		goto	run_detached_process
$!
$	request "VMSDOWNUP requires device opa0: - please log off opa0:"
$	wait	0:1:0
$	goto	determine_opa0_status
$!
$!
$ run_detached_process:
$	run	sys$system:loginout -
		/authorize -
		/detached -
		/input = 'f$environment ( "procedure" )' -
		/output = _opa0:
$!
$! Go into a wait state (to keep our batch slot so other jobs don't start up)
$!
$	wait	12:0:0
$!
$	exit
$!
$!
$ not_batch:
$!	How many minutes?
$!	Reason:
$!	Spin down disks?
$!	Invoke site-specific shutdown procedure?
$!	Expected uptime
$!	Automatic reboot?
$!	Shutdown options? [none]
$!
$!
$	@SYS$SYSTEM:SHUTDOWN.COM -
5 -
"Taking the system down & up." -
NO -
YES -
"immediately" -
YES -
NONE
