$	VER  =  F$VERIFY("NO")
$	CUR_DIR = F$LOGICAL("SYS$DISK") + F$DIRECTORY()
$	ON CONTROL_Y THEN $ GOTO CNTRLY
$!WIPEOUT.COM	-	Command procedure to delete from a specified
$!			disk a specified directory (UFD or SFD) and
$!			all its associated files.
$!
$!
$!		Written by:	Clair Garman
$!				Digital Equipment Corporation
$!				Educational Services
$!				Washington, DC
$!
$!
$!		Sample Execution:	WIPEOUT DMA1:[XYZ]
$!					WIPEOUT [MYDIR]
$!					WIPEOUT MYDIR
$!					WIPEOUT [USER.QED]
$!					WIPEOUT [.QED]
$!					WIPEOUT .QED
$!					WIPEOUT
$!
$!
$!
$!Setup
$!
$	SET MESSAGE/NOSEVERITY/NOTEXT/NOFACILITY/NOIDENTIFICATION
$	SET NOON
$!
$!
$!
$!Obtain the directory to be deleted
$!
$	IF P1 .NES. "" THEN GOTO DISK_LOCATE
$!
$	INQUIRE P1 "Directory to delete? (e.g. DMA1:[XYZ.DIR])"
$!
$!
$!Use default disk if disk name not given
$!
$DISK_LOCATE:
$!
$	IF F$LOCATE(":",P1) .EQ. F$LENGTH(P1) THEN GOTO NO_DISK_GIVEN
$		DISK = F$EXTRACT(0,F$LOCATE(":",P1)+1,P1)
$		P1   = P1 - DISK
$		GOTO BRACKET_CHECK
$NO_DISK_GIVEN:
$		DISK = F$LOGICAL("SYS$DISK")
$!
$!Strip brackets from directory name if they were specified
$!
$BRACKET_CHECK:
$	IF F$LOCATE("[",P1) .EQ. F$LENGTH(P1) THEN GOTO SET_DIR
$		P1  =  P1  - "["  - "]"
$SET_DIR:
$	SET DEFAULT 'DISK'['P1']
$	P1 = F$DIRECTORY() - "["  - "]"
$!
$!First get the name field of the directory file to be deleted
$!
$	DIR_NAME = P1
$	DIR_LOCATION=""
$	TEMP=0
$PERIOD_CHECK:
$	PERIOD = F$LOCATE(".",DIR_NAME)	
$	IF PERIOD .EQS. F$LENGTH(DIR_NAME) THEN GOTO CHECK_EXISTENCE
$	TEMP=TEMP+PERIOD
$	DIR_LOCATION=F$EXTRACT(0,TEMP,P1)
	TEMP	= TEMP+1
$	DIR_NAME = F$EXTRACT(PERIOD+1,F$LENGTH(DIR_NAME)-PERIOD,DIR_NAME)
$	GOTO PERIOD_CHECK
$!
$!Does the directory exist?  If not, exit
$!
$CHECK_EXISTENCE:
$	IF F$SEARCH("''DISK'[-]''DIR_NAME'.DIR",1) .EQS. "" THEN -
							GOTO NO_SUCH_DIR
$!
$!First change the protection for all the included files to allow DELETE
$!
$	SET PROTECTION=(S:RWED,O:RWED) 'DISK'['P1'...]*.*;*
$!
$	ON ERROR THEN CONTINUE
$	N = 1
$!
$!Loop 7 times to do wild card delete on specified directory
$!	Note that .DIR files will not actually be deleted until all their
$!	files have been deleted. That is why we loop 7 times.
$LOOP:
$	DELETE 'DISK'['P1'...]*.*;*
$	IF $STATUS THEN GOTO SUB_DIR_DONE
$	N = N + 1
$	IF N .LE. 7 THEN GOTO LOOP
$!
$!Now delete directory file given
$!
$SUB_DIR_DONE:
$	SET PROTECTION=S:RWED [-]'DIR_NAME'.DIR
$	DELETE [-]'DIR_NAME'.DIR;1
$!
$!Directory deletion completed 
$!
$	WRITE SYS$OUTPUT -
     "Directory ""''DIR_NAME'"" deleted from ""''DISK'[''DIR_LOCATION']"""
$	SET DEFAULT 'CUR_DIR'
$	GOTO END
$!
$!Error Routine - Directory does not exist
$!
$NO_SUCH_DIR:
$	WRITE SYS$OUTPUT -
	"***** ""''DIR_NAME'"" does not exist on ""''DISK'[''DIR_LOCATION']"""
$	GOTO END
$!
$!
$!Debugging routine
$!
$!
$	SHOW SYMBOL/ALL
$CNTRLY:
$	WRITE SYS$OUTPUT "***** Directory removal incomplete"
$END:
$	SET MESSAGE/SEVERITY/FACILITY/IDENTIFICATION/TEXT
$	SET DEFAULT 'CUR_DIR'
$	IF VER .EQ. 1 THEN SET VERIFY
