C*****************************************************************************
C
C  Help Menus for DM			August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-7159
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Write the keypad help message.                                    C
C-------------------------------------------------------------------C
	Subroutine DM_Help (Initial_Menu)
	Implicit Integer*4 (A - Z)
	Character*1 Com, UCom
	Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Paste_Virtual_Display (Window2_Display,
	1	Pasteboard_ID,1,1)

	Go To (10,20,30,40) Initial_Menu

10	Call Keypad_Help 
	Go To 50

20	Call Function_Help 
	Go To 50

30	Call Normal_Help 
	Go To 50

40	Call Gold_Help 
	Go To 50

50	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Call Mess_Line (' Press: N for Normal Keys, G for Gold Keys,'//
	1	' F for Function Keys, K for Keypad')

   	Call WriteTerm (Cursor_Off)
100     Call Get1Char(Com)

	Call Str$UpCase (%Descr(UCom),%Descr(Com))

        If ( UCom .EQ. 'K' ) then     
		Call Keypad_Help 
		GoTo 100       	

        Else If ( UCom .EQ. 'F' ) then     
		Call Function_Help 
		GoTo 100       	

        Else If ( UCom .EQ. 'G' ) then     
		Call Gold_Help 
		GoTo 100       	

        Else If ( UCom .EQ. 'N' ) then     
		Call Normal_Help 
		GoTo 100       	

        End If

500	Call SMG$UnPaste_Virtual_Display (Window2_Display,Pasteboard_ID)
   	Call WriteTerm (Cursor_On)

        Return          
        End
                                               
C-------------------------------------------------------------------C
C	Help for Normal Keys
C-------------------------------------------------------------------C
	Subroutine Normal_Help 
	Implicit Integer*4 (A - Z)
	Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Erase_Display (Window2_Display)

C		LABEL FOR THIS SCREEN
	Call SMG$Put_Line (Window2_Display,
	1	'        Directory Management Single Letter'//
	2	' Commands (Normal Keys)                       '
	3	,,SMG$M_Reverse)

        Call SMG$Put_Chars (Window2_Display,
	1	'$ - Spawn one DCL command (more efficient than %)'
	2   	,2,2)
        Call SMG$Put_Chars (Window2_Display,
	1   '% - Leave DM and run one DCL command, then reenter DM'
	2   	,3,2)                                        
        Call SMG$Put_Chars (Window2_Display,
	1	'@ - Execute this .COM file',4,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'A - Go to Top of screen',5,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'Z - Go to Bottom of screen',6,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'W - Select a Wildcard for file display',7,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'T - Tag this file - Used in D, C, P, '//
	2	'and <Gold>I Commands',8,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'U - Untag this file',9,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'Q - Quit - Exit to starting directory',10,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'X - Quit to current directory',11,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'R - Rename - Prompts for new file name',12,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'V - View either a file or this directory',13,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'E - Edit this file',14,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'F - FMS edit this file',15,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'M - Show More file information for all files',16,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'I - Show file information for this file',17,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'L - Show Less file information',18,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'D - Delete File(s) or Dir(s)',19,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'C - Copy - Prompts for file(s) to copy into',20,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'G - Purge "This Directory"',21,2)
        Call SMG$Put_Chars (Window2_Display,
	1	'P - Print File(s) to default printer',22,2)
                 
	Call SMG$Change_Rendition (Window2_Display,2,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,3,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,4,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,5,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,6,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,7,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,8,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,9,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,10,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,11,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,12,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,13,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,14,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,15,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,16,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,17,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,18,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,19,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,20,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,21,2,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Window2_Display,22,2,1,1,SMG$M_Bold)

	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	Return
	End

C-------------------------------------------------------------------C
C	Help for Keypad Keys (main help)
C-------------------------------------------------------------------C
	Subroutine Keypad_Help 
	Implicit Integer*4 (A - Z)
	Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Erase_Display (Window2_Display)

	Call SMG$Draw_Rectangle (Window2_Display,1,1,21,33)
	Call SMG$Draw_Line (Window2_Display,1,9,17,9)
	Call SMG$Draw_Line (Window2_Display,1,17,21,17)
	Call SMG$Draw_Line (Window2_Display,1,25,21,25)
	Call SMG$Draw_Line (Window2_Display,5,1,5,33)
	Call SMG$Draw_Line (Window2_Display,9,1,9,33)
	Call SMG$Draw_Line (Window2_Display,13,1,13,33)
	Call SMG$Draw_Line (Window2_Display,17,1,17,25)

C		TOP KEY ROW
	Call SMG$Put_Chars (Window2_Display,'       ',2,2
	1	,,SMG$M_Reverse)
	Call SMG$Put_Chars (Window2_Display,' GOLD  ',3,2
	1	,,SMG$M_Reverse)
	Call SMG$Put_Chars (Window2_Display,'       ',4,2
	1	,,SMG$M_Reverse)

	Call SMG$Put_Chars (Window2_Display,' HELP  ',3,10)

	Call SMG$Put_Chars (Window2_Display,'FIND NX',2,18)
	Call SMG$Put_Chars (Window2_Display,' FIND  ',4,18
	1	,,SMG$M_Reverse)

	Call SMG$Put_Chars (Window2_Display,'  GOLD  ',2,35
	1	,,SMG$M_Reverse)
	Call SMG$Put_Chars (Window2_Display,'  HELP  ',3,35)
	Call SMG$Put_Chars (Window2_Display,' FIND NX',4,35)
	Call SMG$Put_Chars (Window2_Display,'  FIND  ',5,35
	1	,,SMG$M_Reverse)

	Call SMG$Put_Chars (Window2_Display,
	1	'- Gold Functions',2,45)
	Call SMG$Put_Chars (Window2_Display,
	1	'- Display This Screen',3,45)
	Call SMG$Put_Chars (Window2_Display,
	1	'- Find next occurrance of string',4,45)
	Call SMG$Put_Chars (Window2_Display,
	1	'- Find string',5,45)

C		SECOND KEY ROW
	Call SMG$Put_Chars (Window2_Display,'   1   ',6,2)
	Call SMG$Put_Chars (Window2_Display,' LINE  ',7,2)

	Call SMG$Put_Chars (Window2_Display,'   1   ',6,10)
	Call SMG$Put_Chars (Window2_Display,' LINE  ',7,10)

	Call SMG$Put_Chars (Window2_Display,' 1 LINE ',7,35)

	Call SMG$Put_Chars (Window2_Display,
	1	'- Move 1 line in current direction',7,45)

C		THIRD KEY ROW
	Call SMG$Put_Chars (Window2_Display,'   1   ',10,2)
	Call SMG$Put_Chars (Window2_Display,' LINE  ',11,2)

	Call SMG$Put_Chars (Window2_Display,'  PAGE ',10,10)
	Call SMG$Put_Chars (Window2_Display,'   UP/ ',11,10)
	Call SMG$Put_Chars (Window2_Display,'  DOWN ',12,10)

	Call SMG$Put_Chars (Window2_Display,'   PAGE ',11,35)

	Call SMG$Put_Chars (Window2_Display,
	1	'- Move 1 page in current direction',11,45)

C		FOURTH KEY ROW
	Call SMG$Put_Chars (Window2_Display,' BACKUP',15,2)
	Call SMG$Put_Chars (Window2_Display,'  TOP  ',16,2
	1	,,SMG$M_Reverse)

	Call SMG$Put_Chars (Window2_Display,'   1   ',14,10)
	Call SMG$Put_Chars (Window2_Display,' LINE  ',15,10)

	Call SMG$Put_Chars (Window2_Display,'  POP  ',15,18)

	Call SMG$Put_Chars (Window2_Display,'   1   ',16,26)
	Call SMG$Put_Chars (Window2_Display,' LINE  ',18,26)

	Call SMG$Put_Chars (Window2_Display,' BACKUP ',14,35)
	Call SMG$Put_Chars (Window2_Display,'    POP ',15,35)

	Call SMG$Put_Chars (Window2_Display,
	1	'- Set direction to Reverse and move 1 line',14,45)
	Call SMG$Put_Chars (Window2_Display,
	1	'- Go Up one Directory',15,45)

C		FIFTH KEY ROW
	Call SMG$Put_Chars (Window2_Display,'ADVANCE',19,6)
	Call SMG$Put_Chars (Window2_Display,'    BOTTOM     ',20,2
	1	,,SMG$M_Reverse)

	Call SMG$Put_Chars (Window2_Display,' VIEW  ',19,18)

	Call SMG$Put_Chars (Window2_Display,' ADVANCE',18,35)
	Call SMG$Put_Chars (Window2_Display,'    VIEW',19,35)

	Call SMG$Put_Chars (Window2_Display,
	1	'- Set direction to Forward and move 1 line',18,45)
	Call SMG$Put_Chars (Window2_Display,
	1	'- View File or Next Directory',19,45)

C		LABEL FOR THIS SCREEN
	Call SMG$Put_Chars (Window2_Display,
	1	'Keypad Keys for DM',22,9,,SMG$M_Bold)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	Return
	End

C-------------------------------------------------------------------C
C	Help for Gold Keys
C		$/[ B F G H K T W , .
C-------------------------------------------------------------------C
	Subroutine Gold_Help 
	Implicit Integer*4 (A - Z)
	Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Erase_Display (Window2_Display)

C		LABEL FOR THIS SCREEN
	Call SMG$Put_Line (Window2_Display,
	1	'  Directory Management Gold Commands:'//
	2	' - Type GOLD (PF1) followed by another key. '
	3	,,SMG$M_Reverse)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',3,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'T - Go to TOP of Directory Display.'
	2   	,3,6)                                        
	Call SMG$Change_Rendition (Window2_Display,3,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',4,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'B - Go to BOTTOM of Directory Display.'
	2   	,4,6)                                        
	Call SMG$Change_Rendition (Window2_Display,4,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',5,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'W - Write files (copy files out of this directory).'
	2   	,5,6)                                        
	Call SMG$Change_Rendition (Window2_Display,5,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',6,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'G - Get files (copy files into this directory).'
	2   	,6,6)                                        
	Call SMG$Change_Rendition (Window2_Display,6,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',7,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 '$ - Go to DCL (Subprocess).  Press Return to come back to DM.'
	2   	,7,6)                                        
	Call SMG$Change_Rendition (Window2_Display,7,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',8,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 '[ - Go to DCL (Subprocess).  Press Return to come back to DM.'
	2   	,8,6)                                        
	Call SMG$Change_Rendition (Window2_Display,8,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',9,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 ', (Srch) - Find a search string in file names.'
	2   	,9,6)                                        
	Call SMG$Change_Rendition (Window2_Display,9,6,1,8,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',10,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 '. (Cont Srch) - Find previous search string.'
	2   	,10,6)                                        
	Call SMG$Change_Rendition (Window2_Display,10,6,1,13,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',11,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'H - Help'
	2   	,11,6)                                        
	Call SMG$Change_Rendition (Window2_Display,11,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',12,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'P - Print DM Directory on Default Printer'
	2   	,12,6)                                        
	Call SMG$Change_Rendition (Window2_Display,12,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',13,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'A - Additional Options: '//
	2 'Change Default Options (Printer, etc.)'
	3   	,13,6)                                        
	Call SMG$Change_Rendition (Window2_Display,13,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',14,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'D - Change to another Disk Device (go to top level)'
	2   	,14,6)                                        
	Call SMG$Change_Rendition (Window2_Display,14,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',15,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'M - VMS Mail (Uses EDT Editor for Send)'
	2   	,15,6)                                        
	Call SMG$Change_Rendition (Window2_Display,15,6,1,1,SMG$M_Bold)
                                                     
        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',16,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'I - (Big I) DIR/FULL of current file or tagged files'
	2   	,16,6)                                        
	Call SMG$Change_Rendition (Window2_Display,16,6,1,1,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',17,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'K - Quit: Exit to starting directory'
	2   	,17,6)                                        
	Call SMG$Change_Rendition (Window2_Display,17,6,1,1,SMG$M_Bold)
                                                     
        Call SMG$Put_Chars (Window2_Display,
	1	'Gold',18,1,,SMG$M_Reverse)
        Call SMG$Put_Chars (Window2_Display,
	1 'F - Quit: Exit to starting directory'
	2   	,18,6)                                        
	Call SMG$Change_Rendition (Window2_Display,18,6,1,1,SMG$M_Bold)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	Return
	End
                   
C-------------------------------------------------------------------C
C	Help for Function Keys
C-------------------------------------------------------------------C
	Subroutine Function_Help 
	Implicit Integer*4 (A - Z)
	Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Erase_Display (Window2_Display)

C		F10
	Call SMG$Draw_Rectangle (Window2_Display,1,7,5,15)
	Call SMG$Draw_Line (Window2_Display,1,2,1,7)
	Call SMG$Draw_Line (Window2_Display,5,2,5,7)
	Call SMG$Put_Chars (Window2_Display,'>',2,2)
	Call SMG$Put_Chars (Window2_Display,'<',3,2)
	Call SMG$Put_Chars (Window2_Display,'>',4,2)

	Call SMG$Put_Chars (Window2_Display,'  EXIT ',3,8)
	Call SMG$Put_Chars (Window2_Display,' (QUIT)',4,8)


C		F11 - F14
	Call SMG$Draw_Rectangle (Window2_Display,1,17,5,49)
	Call SMG$Draw_Line (Window2_Display,1,25,5,25)
	Call SMG$Draw_Line (Window2_Display,1,33,5,33)
	Call SMG$Draw_Line (Window2_Display,1,41,5,41)

	Call SMG$Put_Chars (Window2_Display,'FORWARD',2,18)
	Call SMG$Put_Chars (Window2_Display,'REVERSE',3,18)
	Call SMG$Put_Chars (Window2_Display,' TOGGLE',4,18)
	Call SMG$Put_Chars (Window2_Display,'MOVE UP',3,26)
	Call SMG$Put_Chars (Window2_Display,' 1 LINE',4,26)
	Call SMG$Put_Chars (Window2_Display,' DELETE',3,34)

C		F15, F16
	Call SMG$Draw_Rectangle (Window2_Display,1,51,5,75)
	Call SMG$Draw_Line (Window2_Display,1,59,5,59)

	Call SMG$Put_Chars (Window2_Display,'  HELP ',3,52)
	Call SMG$Put_Chars (Window2_Display,'DO',3,67)
	Call SMG$Put_Chars (Window2_Display,'(SPAWN DCL CMD)',4,60)

C		CENTER KEYPAD
	Call SMG$Draw_Rectangle (Window2_Display,7,51,15,75)
	Call SMG$Draw_Line (Window2_Display,11,51,11,75)
	Call SMG$Draw_Line (Window2_Display,7,59,22,59)
	Call SMG$Draw_Line (Window2_Display,7,67,22,67)
	Call SMG$Draw_Line (Window2_Display,19,51,19,75)
	Call SMG$Draw_Line (Window2_Display,19,51,22,51)
	Call SMG$Draw_Line (Window2_Display,19,75,22,75)

	Call SMG$Put_Chars (Window2_Display,'  FIND ',9,52)
	Call SMG$Put_Chars (Window2_Display,'  COPY ',8,60)
	Call SMG$Put_Chars (Window2_Display,' FILES ',9,60)
	Call SMG$Put_Chars (Window2_Display,'   IN  ',10,60)
	Call SMG$Put_Chars (Window2_Display,' DELETE',9,68)

	Call SMG$Put_Chars (Window2_Display,' SELECT',13,52)
	Call SMG$Put_Chars (Window2_Display,'  PREV ',13,60)
	Call SMG$Put_Chars (Window2_Display,' SCREEN',14,60)
	Call SMG$Put_Chars (Window2_Display,'  NEXT ',13,68)
	Call SMG$Put_Chars (Window2_Display,' SCREEN',14,68)

	Call SMG$Put_Chars (Window2_Display,'   UP  ',17,60)
	Call SMG$Put_Chars (Window2_Display,'  DOWN ',21,60)


C		LABEL FOR THIS SCREEN
	Call SMG$Put_Chars (Window2_Display,
	1	'VT-200 Function Keys for DM',7,20,,SMG$M_Bold)


C		EXPLANATORY TEXT
	Call SMG$Put_Chars (Window2_Display,
	1 '         Find - Find string in file names',9,2)
	Call SMG$Change_Rendition (Window2_Display,9,11,1,4,SMG$M_Bold)

	Call SMG$Put_Chars (Window2_Display,
	1 'Copy Files In - Get Files (from another .dir)',10,2)
	Call SMG$Change_Rendition (Window2_Display,10,2,1,13,SMG$M_Bold)

	Call SMG$Put_Chars (Window2_Display,
	1 '       Select - Edit file, or go to Directory',13,2)
	Call SMG$Change_Rendition (Window2_Display,13,9,1,6,SMG$M_Bold)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	Return
	End

