C*****************************************************************************
C	Keystroke handling routines for DM
C  Version 6.x				            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-7159
C
C*****************************************************************************
	Subroutine Function_Keys

	Implicit Integer*4 (A - Z)
	Character*1 Com, Com2, Com3
	Logical*1 SavFor

	Include 'Common.Dat'


C-------------------------------------------------------------------C
C	Now: it's a FUNCTION key (CSI)
C
C	After_Escape was '[' (for CSI)
C-------------------------------------------------------------------C
C-------------------------------------------------------------------C
C	PROCESS KEYS STARTING WITH <CSI>
C-------------------------------------------------------------------C
     
	GOTO (286,287,288,289,290,291,292,293,294,295,296,297,298,299,
	1     300,9100,9100,9100,9100,9100,9100,9100,9100,9100,9100,
	2     311,312,313,314,315,316) Terminator - 285	

	GoTo 9100


C-------------------------------------------------------------------C
C	HANDLE TOP-ROW FUNCTION KEYS
C-------------------------------------------------------------------C

C}{}{}{}      {ESC}{[}{1}{7}{~} =  F6 = CANCEL =
286	CONTINUE
        	 Exit_Com = 'zzzz'!
		 DM_Exit = .TRUE.
		GoTo 9100


C}{}{}{}      {ESC}{[}{1}{8}{~} =  F7 = 
287	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{1}{9}{~} =  F8 = 
288	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{2}{0}{~} =  F9 = 
289	CONTINUE
		GoTo 9100
                             

C}{}{}{}      {ESC}{[}{2}{1}{~} =  F10 = EXIT (Quit)
290	CONTINUE
        	 Exit_Com = 'zzzz'!
		 DM_Exit = .TRUE.
		GoTo 9100


C}{}{}{}      {ESC}{[}{2}{3}{~} =  F11 = Toggle Direction
291	CONTINUE
	If (Forward) then      ! Was forward mode, so set reverse
	         Forward = .FALSE.     ! reverse mode
	Else
	         Forward = .TRUE.      ! forward mode
        End If
	Line23_Dirty = .TRUE.
	GOTO 9100


C}{}{}{}      {ESC}{[}{2}{4}{~} =  F12 = BS = Move Up One Line
292	CONTINUE
		Call UpArrow
		GoTo 9100


C}{}{}{}      {ESC}{[}{2}{5}{~} =  F13 = LF = Delete Files (Tagged)
293	CONTINUE
		Call DM_Delete
		GoTo 9100                           
                                   

C}{}{}{}      {ESC}{[}{2}{6}{~} =  F14 =
294	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{2}{8}{~} =  HELP
295	CONTINUE
		Call DM_Help (2) ! Function key help is first.
		GOTO 9100

C}{}{}{}      {ESC}{[}{2}{9}{~}  = DO = Go to DCL
296	CONTINUE
      	    Call DCL ! Do DCL Command
		GOTO 9100     !Get Next Command


C}{}{}{}      {ESC}{[}{3}{1}{~} =  F17 =
297	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{3}{2}{~} =  F18 =
298	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{3}{3}{~} =  F19 =
299	CONTINUE
		GoTo 9100


C}{}{}{}      {ESC}{[}{3}{4}{~} =  F20 =
300	CONTINUE
		GoTo 9100


C-------------------------------------------------------------------C
C		The "Editing Keys" (just above the arrow keys)
C
C-------------------------------------------------------------------C

C}{}{}{}      {ESC}{[}{1}{~} = FIND  
311		Call FindStrg ! GET 'SEARCH' & show it
		GoTo 9100


C}{}{}{}      {ESC}{[}{2}{~} = INSERT HERE =
312		Call Get_Files
		GoTo 9100


C}{}{}{}      {ESC}{[}{3}{~} = REMOVE = Delete Tagged Files
313		Call DM_Delete
		GoTo 9100


C}{}{}{}      {ESC}{[}{4}{~} =  SELECT = PUSH (Go to selected directory)
C					or EDIT (WPE) selected file.
C		NOTE: The difference between this key and KP. (Sel) is
C			that this key (Select) is equivalent to EDIT for
C			non-DIR files - where KP. defaults to VIEW.
                              
314        Call GetName(Current_Line, TempName, Itsa_Dir)
	       If (Itsa_Dir) then  ! 'DIR' type
		  Call PUSHSTACK
	       Else	
		  CMD = 'E'    !Fake this as a "EDIT"
        	  Call Envoke_DCL_Command( CMD )
	       End If
	   GoTo 9100
                                

C}{}{}{}      {ESC}{[}{5}{~} = PREV SCREEN = Page Back
315      SavFor = Forward
         Forward = .FALSE.
         Call Page
C		If it's not the "end" screen..
         If (Current_Line .NE. FirstUsed) Forward = SavFor
	 GoTo 9100


C}{}{}{}      {ESC}{[}{6}{~} = NEXT SCREEN = Page Forward
316      SavFor = Forward
         Forward = .TRUE.
         Call Page             
C		If it's not the "end" screen..
         If (Current_Line .NE. LastLine) Forward = SavFor
	 GoTo 9100

   
9100	CONTINUE

	Return
	End
