C*****************************************************************************
C	Keystroke handling routines for DM
C  Version 6.x				            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-7159
C
C*****************************************************************************
	Subroutine Gold_Keys

	Implicit Integer*4 (A - Z)
	Character*1 Com,UCMD 

	Include 'Common.Dat'



C}{}{}{}      {ESC}{[}{P} =  GOLD (PF1)
C	---------------------- This is a <GOLD> Key Sequence
C-------------------------------------------------------------------C
C	PROCESS <GOLD> KEY SEQUENCE
C-------------------------------------------------------------------C

C	Get the next character after <GOLD>

        Call GET1Char(Com) ! GET the character of interest
	Call Str$UpCase (%Descr(UCMD),%Descr(Com))

C-------------------------------------------------------------------C
C  Com, UCMD, and Terminator (in common) may now be used to determine
C	what action is required.
C-------------------------------------------------------------------C

C}{}{}{}      {GOLD}{T} = TOP
	If  (UCMD .EQ. 'T')  then
		Call GoTop ! Go to top of the files array

        
C}{}{}{}      {GOLD}{B} = BOTTOM
        Else If (UCMD .EQ. 'B')  then  ! Go to bottom of files array
		Call GoBot
        

                          
C}{}{}{}      {GOLD}{,} = SEARCH (FIND)
        Else If (Com .EQ. ',') then
		Call FindStrg ! GET 'SEARCH' & show it
        	


C}{}{}{}      {GOLD}{.} = CONTINUE SEARCH (FIND NEXT)
        Else If (Com .EQ. '.') then
		Call ShowSrch ! Show 'SEARCH' string
        

                                  
C}{}{}{}      {GOLD}{$} = DCL
C}{}{}{}      {GOLD}{[} = DCL
        Else If (lib$matchc (com, '$[') .gt. 0 ) then 
	Call GoTo_DCL

C}{}{}{}      {GOLD}{K} = Quit
C}{}{}{}      {GOLD}{F} = Quit
       Else If (lib$matchc (Com, 'KkFf') .gt. 0 ) then
             Exit_Com = 'zzzz'!
	     DM_Exit = .TRUE.
       

C}{}{}{}      {GOLD}{G} = GET FILE (REVERSE COPY)
       Else If  (UCMD .EQ. 'G')  then
		Call Get_Files


C}{}{}{}      {GOLD}{W} = WRITE FILES (COPY)
       Else If  (UCMD .EQ. 'W')  then
		Call DM_Copy


C}{}{}{}      {GOLD}{H} = HELP
       Else If  (UCMD .EQ. 'H')  then
		Call DM_Help (4) ! Gold key help is first.


C}{}{}{}      {GOLD}{P} = PRINT DIRECTORY (SCREENS)
       Else If  (UCMD .EQ. 'P')  then
		Call DM_Print_Dir


C}{}{}{}      {GOLD}{A} = ADDITIONAL OPTIONS (CHANGE PRINTER, ETC.)
       Else If  (UCMD .EQ. 'A')  then
		Call DM_Gold_A


C}{}{}{}      {GOLD}{PF3} = FIND
       Else If  (Terminator .EQ. 258)  then
		Call FindStrg


C}{}{}{}      {GOLD}{KP0} = Gold-Advance = Bottom
       Else If  (Terminator .EQ. 260)  then
		Call GoBot


C}{}{}{}      {GOLD}{KP1} = Gold-Backup = Top
       Else If  (Terminator .EQ. 261)  then
		Call GoTop


C}{}{}{}      {GOLD}{KP5} = Top/Bottom
       Else If  (Terminator .EQ. 265)  then
		If (Forward) then
			Call GoBot
		Else
			Call GoTop
		End If


C}{}{}{}      {GOLD}{D} = CHANGE DISK
       Else If  (UCMD .EQ. 'D')  then
		StkIndex = 0
		Current_Dir_FileName = '[000000]000000.DIR'
		Current_Dir = '[000000]'
		Call PopStack


C}{}{}{}      {GOLD}{M} = MAIL (VMS Mail)
       Else If  (UCMD .EQ. 'M')  then
		Exit_Com = 'MAIL/EDIT'
		Call Do_One_DCL


C}{}{}{}      {GOLD}{I} = DIR/FULL (Big I)
       Else If  (UCMD .EQ. 'I')  then
		Call DM_Gold_I


	END IF

	Return
	End

C----------------------------------------------------------------------
C GOLD_A - Change Default Settings for:
C	Editor, Viewer, Printer
C----------------------------------------------------------------------
	Subroutine DM_Gold_A

	Implicit Integer*4 (A - Z)
	Character*1 Com, UCMD 
	Character*80 Input_String
	Integer*2 NBytes
	Include 'Common.Dat'
C----------------------------------------------------------------------

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
	Call SMG$Paste_Virtual_Display (Window2_Display,
	1	Pasteboard_ID,1,1)

	Call SMG$Erase_Display (Window2_Display)

C		LABEL FOR THIS SCREEN
	Call SMG$Put_Line (Window2_Display,
	1	'        Directory Management Additional Options:'//
	2	'  Change settings for....                  '
	3	,,SMG$M_Reverse)

C		HEADINGS
        Call SMG$Put_Chars (Window2_Display,
	1	'#     Item           Current Value'
	2   	,3,2,,SMG$M_Bold)

C		Selections
100     Call SMG$Put_Chars (Window2_Display,
	1   '1  Edit Command   - '//Editor(:60)
	2   	,5,2)                                        
	Call SMG$Change_Rendition (Window2_Display,5,2,1,4,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1   '2  View Command   - '//Viewer(:60)
	2   	,6,2)                                        
	Call SMG$Change_Rendition (Window2_Display,6,2,1,4,SMG$M_Bold)

        Call SMG$Put_Chars (Window2_Display,
	1   '3  Print Command  - '//Print_Command(:60)
	2   	,7,2)                                        
	Call SMG$Change_Rendition (Window2_Display,7,2,1,4,SMG$M_Bold)


200	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Call Mess_Line (' Type the number or ''initial'' of '//
	1	'the item you want to change')

   	Call WriteTerm (Cursor_Off)
        Com = ' '
	Call Get1Char(Com)
   	Call WriteTerm (Cursor_On)

	Call Str$UpCase (%Descr(UCMD),%Descr(Com))

        If ((Com .EQ. '1') .OR. ( UCMD .EQ. 'E' )) then     
		Call Get_Initial_Line24 
	1	  (' New value for Edit Command:',Editor,
	2	    Input_String,NBytes)
		Call Fix24
		If (NBytes .LE. 0) then
			GoTo 200
		Else If ((Input_String(:NBytes) .EQ. ' ')
	1	    .OR. (Input_String(:Nbytes) .EQ. Editor)) then
			GoTo 200
		Else
			Editor = Input_String(:NBytes)
C				Set this as Global Symbol (Remember)
		        Call Lib$SET_Symbol(%Descr('DM$Editor'), 
	1				%Descr(Editor(:NBytes)),%Ref(2))
			Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
			GoTo 100
		End If

        Else If ((Com .EQ. '2') .OR. ( UCMD .EQ. 'V' )) then     
		Call Get_Initial_Line24 
	1	  (' New value for View Command:',Viewer,
	2	    Input_String,NBytes)
		Call Fix24
		If (NBytes .LE. 0) then                       
			GoTo 200
		Else If ((Input_String(:NBytes) .EQ. ' ')
	1	    .OR. (Input_String(:Nbytes) .EQ. Viewer)) then
			GoTo 200
		Else
			Viewer = Input_String(:NBytes)
C				Set this as Global Symbol (Remember)
		        Call Lib$SET_Symbol(%Descr('DM$Viewer'), 
	1				%Descr(Viewer(:NBytes)),%Ref(2))
			Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
			GoTo 100
		End If

        Else If ((Com .EQ. '3') .OR. ( UCMD .EQ. 'P' )) then     
		Call Get_Initial_Line24 
	1	  (' New value for Print Command:',Print_Command,
	2	    Input_String,NBytes)
		Call Fix24
		If (NBytes .LE. 0) then                       
			GoTo 200
		Else If ((Input_String(:NBytes) .EQ. ' ')
	1	    .OR. (Input_String(:Nbytes) .EQ. Print_Command)) 
	2			then
			GoTo 200
		Else
			Print_Command = Input_String(:NBytes)
C				Set this as Global Symbol (Remember)
		        Call Lib$SET_Symbol(%Descr('DM$Print_Command'), 
	1				%Descr(Print_Command(:NBytes)),
	2				%Ref(2))
			Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
			GoTo 100
		End If

	Else 
		GoTo 500
	End If


500	Call SMG$UnPaste_Virtual_Display (Window2_Display,Pasteboard_ID)

	Return
	End
