C*****************************************************************************
C	Keystroke handling routines for DM
C  Version 6.x				            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-7159
C
C*****************************************************************************
	Subroutine Keypad_Keys

	Implicit Integer*4 (A - Z)

	Include 'Common.Dat'


C-------------------------------------------------------------------C
C	PROCESS KEYS STARTING WITH <SS3>
C	(The arrow keys have already been done)
C	These are the "Keypad" keys.
C-------------------------------------------------------------------C

	GOTO (256,257,258,259,260,261,262,263,264,265,266,267,268,269,
	1     270,271,272,273)   Terminator - 255	
	GoTo 8200
                        
C}{}{}{}      {ESC}{[}{P} =  GOLD (PF1)
C	---------------------- 
C        IF (Com .EQ. 256) THEN
C	---------------------- This is a <GOLD> Key Sequence
C-------------------------------------------------------------------C
C	PROCESS <GOLD> KEY SEQUENCE
C-------------------------------------------------------------------C

256	Call Gold_Keys
	GoTo 8200

C-------------------------------------------------------------------C
C	Process non-<GOLD> Keypad Keys
C-------------------------------------------------------------------C
                                
C-------------------------------------------------------------------C
C	First, the rest of the keypad top row
C-------------------------------------------------------------------C
               
C}{}{}{}      {ESC}{[}{Q} =  PF2 (HELP)
C				It's PF2 (HELP)
257		Call DM_Help (1)  ! Keypad help is first menu.
		GoTo 8200


C}{}{}{}      {ESC}{[}{R} =  PF3 = FIND NX
258		Call ShowSrch ! SHOW NEXT 'SEARCH' 
		GoTo 8200


C		PF4 IS IGNORED
259		Continue
		Goto 8200	  

C-------------------------------------------------------------------C
C	And then the rest of the keypad.
C
C		  <,-. 0123456789
C	Possible: Mlmn pqrstuvwxy
C	    Used: Mlmn pqrstu wx
C
C	Keypad is mapped as follows:
C
C	GOLD	HELP                   
C	line	line		delete
C	line	page		copy from
C	backup	line	pop	line
C	advance----	view	 "
C
C-------------------------------------------------------------------C
C

C}{}{}{}      {ESC}{[}{q} =  KP0 = ADVANCE = Set Movement to Advance,
C				   		 and advance one line
260	 Call DnArrow
	 If (.NOT.Forward) then
	         Forward = .TRUE.     ! forward mode
		 Line23_Dirty = .TRUE.
	 End If
	 GoTo 8200
       

C}{}{}{}      {ESC}{[}{q} =  KP1 = BACKUP= Set Movement to Reverse,
C						 and back up one line
261	 Call UpArrow
	 If (Forward) then
	         Forward = .FALSE.     ! reverse mode
		 Line23_Dirty = .TRUE.
	 End If
	 GoTo 8200
       

C}{}{}{}      {ESC}{[}{r} =  KP2 = LINE = Move One Line (Up or Down)
262      If (Forward) then 
           Call DnArrow    ! blank, and <cr> are like the down arrow char
         Else      
           Call UpArrow    ! blank, and <cr> are like the up arrow char
         End If
	 GoTo 8200
                 

C}{}{}{}      {ESC}{[}{s} =  KP3 = UPPER = POP Stack (Go UP directory tree)
263		Call POPSTACK
		GoTo 8200
       	

C}{}{}{}      {ESC}{[}{t} =  KP4 = WORD = Move One Line (Up or Down)
264      If (Forward) then 
           Call DnArrow    ! blank, and <cr> are like the down arrow char
         Else      
           Call UpArrow    ! blank, and <cr> are like the up arrow char
         End If
	 GoTo 8200
                 

C}{}{}{}      {ESC}{[}{u} =  KP5 = PARA (Next Screen in current direction)
265		Call PAGE       ! Page Key
		GoTo 8200
       	

C}{}{}{}      {ESC}{[}{v} =  KP6 = BOLD =
266		Continue
		GoTo 8200


C}{}{}{}      {ESC}{[}{w} =  KP7 = SENT = Move One Line (Up or Down)
267      If (Forward) then 
           Call DnArrow    ! blank, and <cr> are like the down arrow char
         Else      
           Call UpArrow    ! blank, and <cr> are like the up arrow char
         End If
	 GoTo 8200
                 

C}{}{}{}      {ESC}{[}{x} =  KP8 = TABPSO = Move One Line (Up or Down)
268      If (Forward) then 
           Call DnArrow    ! blank, and <cr> are like the down arrow char
         Else      
           Call UpArrow    ! blank, and <cr> are like the up arrow char
         End If
	 GoTo 8200
                 

C}{}{}{}      {ESC}{[}{y} =  KP9 = UNDERLINE =
269		Continue
		GoTo 8200


C}{}{}{}      {ESC}{[}{M} =  ENTER = Move One Line (Up or Down)
270      If (Forward) then 
           Call DnArrow    ! blank, and <cr> are like the down arrow char
         Else      
           Call UpArrow    ! blank, and <cr> are like the up arrow char
         End If
	 GoTo 8200
                 

C}{}{}{}      {ESC}{[}{m} =  KP- = CUT =
271		Continue
		GoTo 8200


C}{}{}{}      {ESC}{[}{l} =  KP, = PASTE =
272		Continue
		GoTo 8200


C}{}{}{}      {ESC}{[}{n} =  KP. = PUSH (Go to selected directory)
C					or VIEW (MORE) selected file.
273        Call GetName(Current_Line, TempName, Itsa_Dir)
	       If (Itsa_Dir) then  ! 'DIR' type
		  Call PUSHSTACK
	       Else	
		  CMD = 'V'    !Fake this as a "VIEW"
	          Call Envoke_DCL_Command( CMD )
	       End If
	       GoTo 8200
       



8200	CONTINUE

	Return
	End
