C*****************************************************************************
C
C  Revisions (Version 6.x)            July-Sept, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-7159
C
C*****************************************************************************

C	This is file Screen_Management.for

C  Contents:
C	Create_SMG_Environment
C	Create_Menu
C	SetChoices
C	RePaste_Normal and RePaste_More
C	Broadcast_Handler_AST
C
C-------------------------------------------------------------------C
C	Create the SMG environment
C-------------------------------------------------------------------C
       Subroutine Create_SMG_Environment
       Implicit Integer*4 (A - Z)
       Character*15 Temp15	
       Include 'Common.Dat'	

       EXTERNAL BROADCAST_HANDLER_AST	
C-------------------------------------------------------------------C

	
	Call SMG$Create_Pasteboard
     1		 (Pasteboard_ID,,PB_Rows,PB_Columns)

	Have_Broadcast = .FALSE.
	Call SMG$Set_Broadcast_Trapping 
     1		 (Pasteboard_ID, Broadcast_Handler_AST)

	Call SMG$Create_Virtual_Keyboard (Keyboard_ID,
	1	'TT')

C------------------------------------------------------------------

	Call SMG$Create_Virtual_Display
     1		 (Initial_Display_Length,Initial_Files_Width,
     2 	 	  Files_Display,SMG$M_Border)
	Current_Display_Length = Initial_Display_Length
	Current_Files_Width    = Initial_Files_Width

	Call SMG$Create_Virtual_Display
     1		 (Initial_Display_Length,Attributes_Display_Width,
     2		  Attributes_Display,SMG$M_Border)
        Call SMG$Change_Rendition
     1		 (Attributes_Display,1,1,1,Attributes_Display_Width,
     2		  SMG$M_Reverse)	
	

	Call SMG$Create_Virtual_Display
     1		 (1,80,Line23_Display,,RU_Mask)

	Write (Temp15(1:3),300) Version
300     Format(I3)
	If (Temp15(1:1) .EQ. ' ') then
		If (Temp15(2:2) .EQ. ' ') then
	     		Temp15(1:3) = Temp15(3:3)//'.0'  
		Else
			Temp15(1:2) = Temp15(2:2)//'.'
		End If
	End If

	If (Forward) then
		Temp15(4:15) = 'A    Forward'
	Else
		Temp15(4:15) = 'A    Reverse'
	End If

	Call SMG$Put_Line(Line23_Display,
	1	%Descr(' DM Version '//Temp15),0)



	Call SMG$Create_Virtual_Display
     1		 (1,80,Directory_Display,,RU_Mask)
	Call SMG$Put_Line(Directory_Display,' Directory ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,16,Blocks_Display,,RU_Mask)
	Call SMG$Put_Line(Blocks_Display,'         Blocks ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,20,Purge_Display,,BR_Mask)
	Call SMG$Put_Line(Purge_Display,' (    of     Files) ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Line23MSG_Display,,SMG$M_Reverse)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Line24_Display)
	Call Create_Menu

	Call SMG$Create_Virtual_Display
     1		 (1,4,Less_Display)
	Call SMG$Put_Line(Less_Display,'Less',0)
	Call SMG$Change_Rendition(Less_Display,1,1,1,1,SMG$M_Bold)

	Call SMG$Create_Virtual_Display
     1		 (1,4,Empty_Display)
	Call SMG$Put_Line(Empty_Display,'    ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Line24MSG_Display)
                       
	Call SMG$Create_Virtual_Display
     1		 (1,80,Line24BBMSG_Display,,RRB_Mask)
	Call SMG$Put_Line_Wide (Line24BBMSG_Display,
	1	'   **** Press any key to continue ****   ',0)
	Call SMG$Put_Chars_Wide (Line24BBMSG_Display,
	1	'   ',1,1,,RRB_Mask,RRB_Mask)
	Call SMG$Put_Chars_Wide (Line24BBMSG_Display,
	1	'   ',1,75,,RRB_Mask,RRB_Mask)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Working_Display,,BRB_Mask)
	Call SMG$Put_Line_Wide (Working_Display,
	1	'  Working',0)
                       
	Call SMG$Create_Virtual_Display
     1		 (8,80,Window1_Display,SMG$M_Border)
	Call SMG$Set_Display_Scroll_Region (Window1_Display)

	Call SMG$Create_Virtual_Display
     1		 (22,80,Window2_Display)


C	NOW SET UP THE INITIAL SCREEN
C----------------------------------------------------------------------

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$Paste_Virtual_Display
     1		 (Attributes_Display,Pasteboard_ID,28,File_Attr_Pos)
 
	Call SMG$Paste_Virtual_Display
     1		 (Files_Display,Pasteboard_ID,1,1)
  
	Call SMG$Paste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Dir_Display_Pos = 69
	Call SMG$Paste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

	Call SMG$Paste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)

C	  This will be done by DM.FOR
C	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	
	

	Return
	End

C-------------------------------------------------------------------C
C	Create Menu for Line 24 of the SMG Screen
C-------------------------------------------------------------------C
       Subroutine Create_Menu
       Implicit Integer*4 (A - Z)
       Character*80 Line	
       Include 'Common.Dat'	
	
C-------------------------------------------------------------------C

	Line = '$ % @ A Z W Tag Untag Quit eXit Ren View Edit FMS'
     1       //' More Info Del Copy purGe Print'

	Call SMG$Put_Line (Line24_Display,Line,0)

	Call SMG$Change_Rendition (Line24_Display,1,1,1,13,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,17,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,23,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,29,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,33,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,37,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,42,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,47,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,51,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,56,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,61,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,65,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,73,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,76,1,1,SMG$M_Bold)

	Return
	End


C-------------------------------------------------------------------C
C SetChoices : Controls the modification of the menu (Line24) 
C  displayed on the bottom line of the CRT.  This is the only place C
C  that Line24_Display gets changed.                                C
C	Also, as appropriate, re-arranges the order of pasting to
C  either conceal or reveal the "attributes" window.
C-------------------------------------------------------------------C
       Subroutine SetChoices (Requested_Menu)

       Implicit Integer*4 (A - Z)
       Integer*4 Requested_Menu, MoreHere, LessHere	
       Logical Did_Not_Load	
       Include 'Common.Dat'
	Data MoreHere /51/   
	Data LessHere /56/
C-------------------------------------------------------------------C

C	MoreHere = 51
C	LessHere = 56

  	If (Requested_Menu .NE. Menu) then

      		If (Menu .EQ. More_Mode) then
	  	    If  (Requested_Menu .EQ. Info_Mode) then
			GoTo 9999
		    Else
			Line23_Dirty = .TRUE.
			Call SMG$UnPaste_Virtual_Display
	1			(Empty_Display,Pasteboard_ID)
		    End If
		End If		



		If    (Requested_Menu .EQ. Normal_Mode) then
C				Was MORE or INFO, going to NORMAL
 			Call SMG$UnPaste_Virtual_Display
	1			(Less_Display,Pasteboard_ID)
			Call RePaste_Normal
			Menu = Requested_Menu

		Else If (Requested_Menu .EQ. Info_Mode) then
C				Was NORMAL, going to INFO
			Call RePaste_More
			Call SMG$Paste_Virtual_Display
	1			(Less_Display,Pasteboard_ID,
	2			 24,LessHere)
			Menu = Requested_Menu

		Else If (Requested_Menu .EQ. More_Mode) then
C				Was NORMAL or INFO, going to MORE
			If (Menu .EQ. Normal_Mode) Call RePaste_More
			If (.NOT.Have_More)        Call Get_Attributes

			Call SMG$Paste_Virtual_Display
	1			(Less_Display,Pasteboard_ID,
	2			 24,LessHere)

			Call SMG$Paste_Virtual_Display
	1			(Empty_Display,Pasteboard_ID,
	2				24,MoreHere)

			Menu = Requested_Menu

		Else
			Menu = Not_Set
			Call SMG$Put_Line 
	1			(Line24_Display,
	2			'**** Error in SetChoices ****',0)

		End If

C		Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	End If
9999  Return
      End
                        
C-------------------------------------------------------------------C
       Subroutine Repaste_Normal

       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)


	Call SMG$RePaste_Virtual_Display
     1		 (Files_Display,Pasteboard_ID,2-TopLine,1)
 
	Call SMG$RePaste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Call SMG$RePaste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

     	If (Blocks_On) Call SMG$Paste_Virtual_Display 
     1		(Blocks_Display,Pasteboard_ID,23,65)

	Call SMG$RePaste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return              
	End

C-------------------------------------------------------------------C
       Subroutine Repaste_More

       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$RePaste_Virtual_Display
     1		 (Attributes_Display,Pasteboard_ID,
     2		  2-TopLine,File_Attr_Pos)
 
	Call SMG$RePaste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Call SMG$RePaste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

     	If (Blocks_On) Call SMG$Paste_Virtual_Display 
     1		(Blocks_Display,Pasteboard_ID,23,65)

	Call SMG$RePaste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return              
	End

C-------------------------------------------------------------------C
C	Handle AST from Broadcast Message
C-------------------------------------------------------------------C
       Subroutine Broadcast_Handler_AST
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'	

C-------------------------------------------------------------------C

       Call SMG$Get_Broadcast_Message 
	1	(Pasteboard_ID, Broadcast_Msg)
       Have_Broadcast = .TRUE.	

       Return
       End			
