	SUBROUTINE CALC_DEL
*******************************************************************************
* 
*    UNIT NAME:  CALC_DEL
* 
*    PURPOSE:  PROCESS "/DELETE" COMMAND
* 
*    INVOCATION METHOD:
* 	CALL CALC_DEL
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    SYMBOL		  C*32         SYMBOL NAME
*    SYM_LEN              I*4          LENGTH OF SYMBOL NAME
*    SYM_ADDR             I*4          SYMBOL TABLE ADDR.  (IF FOUND)
* 
*    CALC_NONINIT                      NO SUCH VARIABLE ERROR CODE
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CLI$GET_VALUE    TO GET SYMBOL NAME
*    GETSYM           LOOK UP NAME IN SYMBOL TABLE
*    DELSYM           DELETE SYMBOL FROM SYMBOL TABLE
*    LIB$SIGNAL       SIGNAL ERROR CONDITION
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	INTEGER CLI$GET_VALUE, GETSYM
	CHARACTER*32 SYMBOL
	INTEGER*4 SYM_LEN, SYM_ADDR
	EXTERNAL CALC_NONINIT			!ERROR CODE FOR NO SUCH SYMBOL
*
*		CODE SECTION
*
	SYMBOL = ' '
	DO WHILE (CLI$GET_VALUE('SYMBOL',SYMBOL))
	    SYM_LEN = INDEX(SYMBOL, ' ')-1
	    SYM_ADDR = GETSYM(SYMBOL(1:SYM_LEN))
	    IF (SYM_ADDR .NE. 0) THEN
		CALL DELSYM(SYM_ADDR)
	    ELSE
		CALL LIB$SIGNAL(CALC_NONINIT, %VAL('10001'X),
     +           SYMBOL(1:SYM_LEN))
	    ENDIF
	    SYMBOL = ' '
	ENDDO
	END
