	SUBROUTINE CALC_HELP
*******************************************************************************
* 
*    UNIT NAME:  CALC_HELP
* 
*    PURPOSE:  PROCESS "/HELP" COMMAND
* 
*    INVOCATION METHOD:
* 	CALL CALC_HELP
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    HELP_LINE            C*132        "/HELP" COMMAND LINE
*    LIB_INDEX            I*4          LIBRARIAN INDEX
*    IHELP                I*4          LOCATION OF FIRST BLANK IN HELP_LINE
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CLI$GET_VALUE    GET COMMAND LINE
*    LBR$INI_CONTROL  INITIALIZE LIBRARIAN FOR READ OF HELP LIBRARY
*    LBR$OPEN         OPEN HELP LIBRARY FILE
*    LBR$OUTPUT_HELP  OUTPUT HELP INFORMATION
*    LBR$CLOSE        CLOSE HELP LIBRARY FILE
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIOINS
*
	EXTERNAL LIB$GET_INPUT, LIB$PUT_OUTPUT
	CHARACTER*132 HELP_LINE
	EXTERNAL LBR$C_READ, HLP$M_HELP, HLP$M_PROMPT
	integer*4 lib_index
*
*		CODE SECTION
*
	HELP_LINE = ' '
	CALL CLI$GET_VALUE('$LINE', HELP_LINE)
	IHELP = INDEX ( HELP_LINE, ' ' )
*
*		INITIALIZE LIBRARIAN
*
	ISTAT = LBR$INI_CONTROL(lib_index, %LOC(LBR$C_READ))
	ISTAT = LBR$OPEN(lib_index, 'CALC$HELP')
*
*		DO THE HELP PROCESSING
*
	ISTAT = LBR$OUTPUT_HELP(
     +   LIB$PUT_OUTPUT,			!ROUTINE TO PUT OUTPUT
     +   ,					!USE DEFAULT WIDTH
     +   HELP_LINE(IHELP+1:132),		!INITIAL INPUT LINE
     +   'CALC$HELP',				!HELP LIBRARY
     +   %LOC(HLP$M_PROMPT)+%LOC(HLP$M_HELP),	!CONTROL FLAGS
     +   LIB$GET_INPUT )			!ROUTINE TO GET INPUT
*
*		CLOSE LIBRARY FILE
*
	ISTAT = LBR$CLOSE(lib_index)
	RETURN
	END
