	SUBROUTINE CALC_HEX
*******************************************************************************
* 
*    UNIT NAME:  CALC_HEX
* 
*    PURPOSE: PROCESS "/HEXADECIMAL" COMMAND
* 
*    INVOCATION METHOD:
* 	CALL CALC_HEX
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    LINE		  C*132		COMMAND LINE
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CLI$GET_VALUE    GET COMMAND LINE
*    EXPRESS	      EVALUATE AN EXPRESSION
*    PRINT_HEX        PRINT A SYMBOL TABLE ENTRY IN HEXADECIMAL
*		      (PASSED TO EXPRESS)
*    CALC_HANDLER     CONDITION HANDLER   (PASSED TO EXPRESS)
* 
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	EXTERNAL PRINT_HEX, CALC_HANDLER
	CHARACTER*132 LINE
*
*		CODE SECTION
*
	LINE = ' '
*
*		GET COMMAND LINE
*
	CALL CLI$GET_VALUE('$LINE', LINE)
D	PRINT *,'CALC_HEX:',LINE
*
*		LOCATE BEGINNING OF EXPRESSION
*
	I = INDEX(LINE, ' ')
*
*		CALL EXPRESS TO PARSE IT
*
	CALL EXPRESS( LINE(I:132), PRINT_HEX, CALC_HANDLER)
*
	RETURN
	END



	SUBROUTINE PRINT_HEX(SYMENT)
*******************************************************************************
* 
*    UNIT NAME:  PRINT_HEX
* 
*    PURPOSE:  TO PRINT A SYMBOL TABLE ENTRY VALUE IN HEXADECIMAL
* 
*    INVOCATION METHOD:
* 	CALL PRINT_HEX(SYMENT)
* 
*    ARGUMENT LIST:
*      NAME               TYPE  USE    FULL NAME:DESCRIPTION
*    -------------------- ----  ---    ---------------------
*    SYMENT		   *     I     SYMBOL TABLE ENTRY
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    VALUE		  I*4          VALUE FROM SYMBOL TABLE
*    OUTSTR               C*32         OUTPUT STRING
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CALC_DECODE      TO GET VALUE FROM SYMBOL TABLE
*    LIB$PUT_OUTPUT   TO PRINT VALUE ON TERMINAL
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	CHARACTER*32 OUTSTR
	INTEGER*4 VALUE

*
*		CODE SECTION
*
*		GET VALUE FROM SYMBOL TABLE ENTRY
*
	CALL CALC_DECODE(SYMENT,,,VALUE)
*
*		CONVERT VALUE TO HEXADECIMAL
*
	WRITE (OUTSTR, 1000) VALUE
*
*		WRITE VALUE TO SYS$OUTPUT
*
	CALL LIB$PUT_OUTPUT(OUTSTR)
*
	RETURN
*
*		FORMAT STATEMENTS
*
1000	FORMAT(8X,Z12.8,' HEXADECIMAL')
	END
