*******************************************************************************
* 
*    UNIT NAME:  CALC_IND
* 
*    PURPOSE:  TO ACCEPT INPUT FROM A FILE
* 
*    INVOCATION METHOD:
* 	CALL CALC_IND(LINE, ECHO, OUTPUT, DEFAULT)
* 
*    ARGUMENT LIST:
*      NAME               TYPE  USE    FULL NAME:DESCRIPTION
*    -------------------- ----  ---    ---------------------
*    LINE		  C*(*)  I     COMMAND LINE CONTAINING FILE NAME
*    ECHO                  L     I     IF TRUE, THEN ECHO INPUT TO TERMINAL
*    OUTPUT                L     I     IF TRUE, THEN OUTPUT VALUES TO TERM.
*    DEFAULT              C*(*)  I     DEFAULT FILE TYPE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    FNAME                C*           FILE NAME (INCLUDING DEFAULTS)
*    ICONTEXT              I           CONTEXT VARIABLE FOR LIB$FIND_FILE
*    INLINE                C           EXPRESSION LINE READ FROM FILE
*    ILEN                  I           LENGTH OF INLINE (AS READ)
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    LIB$FIND_FILE    LOCATE FILE USING DEFAULT
*    EXPRESS          EVALUATE AN EXPRESSION
*    LIB$PUT_OUTPUT   ECHO OUTPUT
*    STR$UPCASE       CONVERT INPUT TO UPPER CASE
*    LIB$SIGNAL       SIGNAL ERRORS
* 
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
* 
*******************************************************************************
	SUBROUTINE CALC_IND(LINE,ECHO,OUTPUT,DEFAULT)
*
*		SPECIFICATIONS
*
	CHARACTER*(*) LINE,DEFAULT
	CHARACTER*80 INLINE,fname
	LOGICAL*4 ECHO,OUTPUT
	integer ilen
	EXTERNAL PRINT_DEC, CALC_NOFILE, CALC_HANDLER
*
*		CODE SECTION
*
	ICONTEXT=0			!ENSURE NO PREVIOUS CONTEXT
	ISTAT=LIB$FIND_FILE(LINE,FNAME,ICONTEXT,DEFAULT)
	IF (ISTAT) THEN
	    OPEN (11,FILE=fname,STATUS='OLD',err=900)
	    DO WHILE (.TRUE.)
		READ (11,FMT='(Q,A)',END=999) ILEN,INLINE
		IF (ECHO) CALL LIB$PUT_OUTPUT(INLINE(1:ILEN))
		CALL STR$UPCASE(INLINE(1:ILEN),INLINE(1:ILEN))
		IF (OUTPUT) THEN
		    CALL EXPRESS(INLINE(1:ILEN), PRINT_DEC, 
     +               CALC_HANDLER)
		ELSE
		    CALL EXPRESS(INLINE(1:ILEN),,CALC_HANDLER)
		ENDIF
	    ENDDO
999	    CLOSE (11)
	ELSE
900	    CALL LIB$SIGNAL(CALC_NOFILE,%VAL('10001'X),fname)
	ENDIF
	RETURN
	END
