	SUBROUTINE CALC_LIST
*******************************************************************************
* 
*    UNIT NAME:  CALC_LIST
* 
*    PURPOSE:  LIST THE SYMBOL TABLE AT THE TERMINAL
* 
*    INVOCATION METHOD:
* 	CALL CALC_LIST
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:  NONE
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    SCNSYM	      SCAN SYMBOL TABLE
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	EXTERNAL CALC_LIST_SYM
*
*		CODE SECTION
*
	CALL SCNSYM(CALC_LIST_SYM)
	RETURN
	END


	SUBROUTINE CALC_LIST_SYM(SYMENT)
*******************************************************************************
* 
*    UNIT NAME:  CALC_LIST_SYM
* 
*    PURPOSE:  PRINT SYMBOL VALUES ON TERMINAL
* 
*    INVOCATION METHOD:
* 	CALL CALC_LIST_SYM(SYMENT)
* 
*    ARGUMENT LIST:
*      NAME               TYPE  USE    FULL NAME:DESCRIPTION
*    -------------------- ----  ---    ---------------------
*    SYMENT                *     I     SYMBOL TABLE ENTRY
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    VALUE                 I*4         VALUE FROM SYMBOL TABLE
*    FLAGS                 L*2         FLAGS FROM SYMBOL TABLE
*    ITYPE                 I*2         TYPE FROM SYMBOL TABLE
*    IVALUE/RVALUE       I*4/R*4       EQUIVALENCE PAIR FOR VALUE FORMATTING
*    NAME                  C*32        NAME FROM SYMBOL TABLE
*    NAME_LEN              I*4         LENGTH OF NAME FROM SYMBOL TABLE
*    OUTSTR                C*80        OUTPUT STRING
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CALC_DECODE      DECODE FIELDS FROM SYMBOL TABLE
*    LIB$PUT_OUTPUT   OUTPUT TO TERMINAL
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	LOGICAL*2 SYMENT(12),FLAGS
*
	INTEGER*2 ITYPE
	INTEGER*4 VALUE
	CHARACTER*32 NAME,OUTSTR*80
	REAL*4 RVALUE
	INTEGER*4 IVALUE
	EQUIVALENCE (RVALUE,IVALUE)
*
*		CODE SECTION
*
	CALL CALC_DECODE(SYMENT, ITYPE, FLAGS, VALUE, NAME, NAME_LEN)
	NAME_LEN = MIN(NAME_LEN,LEN(NAME))
	IF (FLAGS) THEN
	    IF ((FLAGS.AND.2).EQ.0) THEN
		IVALUE = VALUE
		IF (ITYPE.EQ.2) THEN
		    WRITE (OUTSTR,1000) NAME(1:NAME_LEN),IVALUE
		ELSE
		    WRITE (OUTSTR,1001) NAME(1:NAME_LEN),RVALUE
		ENDIF
		CALL LIB$PUT_OUTPUT(OUTSTR(1:NAME_LEN+23))
	    ENDIF
	ENDIF
	RETURN
1000	FORMAT(A,' = ',I20)
1001	FORMAT(A,' = ',E20.7)
	END
