	SUBROUTINE CALC_OCT
*******************************************************************************
* 
*    UNIT NAME:  CALC_OCT
* 
*    PURPOSE:  PROCESSES "/OCTAL" COMMAND
* 
*    INVOCATION METHOD:
* 	CALL CALC_OCT
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    LINE		   C*132       COMMAND LINE
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CLI$GET_VALUE    GET COMMAND LINE
*    PRINT_OCT        PRINT A SYMBOL TABLE ENTRY IN OCTAL  (PASSED TO EXPRESS)
*    CALC_HANDLER     CONDITION HANDLER  (PASSED TO EXPRESS)
*    EXPRESS	      EVALUATE AN EXPRESSION
* 
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	EXTERNAL PRINT_OCT, CALC_HANDLER
	CHARACTER*132 LINE
*
*		CODE SECTION
*
	LINE = ' '
	CALL CLI$GET_VALUE('$LINE', LINE)
	I = INDEX(LINE, ' ')
	CALL EXPRESS( LINE(I:132), PRINT_OCT, CALC_HANDLER)
	RETURN
	END



	SUBROUTINE PRINT_OCT(SYMENT)
*******************************************************************************
* 
*    UNIT NAME:  PRINT_OCT
* 
*    PURPOSE:  TO PRINT A SYMBOL TABLE ENTRY IN OCTAL
* 
*    INVOCATION METHOD:
* 	CALL PRINT_OCT(SYMENT)
* 
*    ARGUMENT LIST:
*      NAME               TYPE  USE    FULL NAME:DESCRIPTION
*    -------------------- ----  ---    ---------------------
*    SYMENT		   *     I     SYMBOL TABLE ENTRY
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    VALUE		  I*4		VALUE FROM SYMBOL TABLE
*    OUTSTR               C*32          OUTPUT STRING
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CALC_DECODE	TO GET VALUE FROM SYMENT
*    LIB$PUT_OUTPUT     TO WRITE VALUE TO TERMINAL
* 
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	CHARACTER*32 OUTSTR
	INTEGER*4 VALUE

*
*		CODE SECTION
*
	CALL CALC_DECODE(SYMENT,,,VALUE)
	WRITE (OUTSTR, 1000) VALUE
	CALL LIB$PUT_OUTPUT(OUTSTR)
	RETURN
*
*		FORMAT STATEMENTS
*
1000	FORMAT(8X,O12.8,' OCTAL      ')
	END
