	SUBROUTINE CALC_SAVE
*******************************************************************************
* 
*    UNIT NAME:  CALC_SAVE
* 
*    PURPOSE:  PROCESS "/SAVE" COMMAND
* 
*    INVOCATION METHOD:
* 	CALL CALC_SAVE
* 
*    ARGUMENT LIST:  NONE
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    FNAME                C*80         FILE NAME
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CLI$GET_VALUE    GET FILE NAME FROM COMMAND LINE
*    SCNSYM           SCAN SYMBOL TABLE
*    CALC_PUT_SYM     PUT SYMBOL TABLE DATA INTO FILE 12 
*                       (PASSED TO SCNSYM)
*    LIB$SIGNAL       SIGNAL ANY ERROR OPENING FILE
* 
*    DEVELOPMENT HISTORY:
*      AUTHOR	            DATE  	COMMENTS
*    D. FITZGERALD         4/14/83        
* 
*******************************************************************************
*
*		SPECIFICATIONS
*
	CHARACTER*80 FNAME
	EXTERNAL CALC_PUT_SYM, CALC_NOFILE
*
*		CODE SECTION
*
	CALL CLI$GET_VALUE('FILE', FNAME)
	OPEN (12, FILE = FNAME,
     +	 STATUS = 'NEW',
     +   CARRIAGE CONTROL = 'LIST',
     +   ERR = 900 )
	CALL SCNSYM(CALC_PUT_SYM)
	CLOSE (12)
	RETURN
*
*		ERROR FROM FILE OPEN
*
900	CALL LIB$SIGNAL(CALC_NOFILE, %VAL('10001'X), FNAME)
	RETURN
	END



	SUBROUTINE CALC_PUT_SYM(SYMENT)
*******************************************************************************
* 
*    UNIT NAME:  CALC_PUT_SYM
* 
*    PURPOSE:  OUTPUT SYMBOL TABLE ENTRY TO FILE 12
* 
*    INVOCATION METHOD:
* 	CALL CALC_SAVE(SYMENT)
* 
*    ARGUMENT LIST:
*      NAME               TYPE  USE    FULL NAME:DESCRIPTION
*    -------------------- ----  ---    ---------------------
*    SYMENT                *     I     SYMBOL TABLE ENTRY
* 
*    LOCAL VARIABLES:
*      NAME      	  TYPE         FULL NAME:DESCRIPTION
*    -------------------- ----         ---------------------
*    ITYPE                I*2          TYPE FROM SYMBOL TABLE
*    FLAGS                L*2          FLAGS FROM SYMBOL TABLE
*    VALUE                I*4          VALUE FROM SYMBOL TABLE
*    IVALUE/RVALUE      I*4/R*4        EQUIVALENCE PAIR FOR VALUE FORMATTING
*    NAME                 C*32         SYMBOL NAME
*    NAME_LEN             I*4          LENGTH OF SYMBOL NAME
* 
*    MODULES CALLED:
*      NAME           PURPOSE
*    -------------    --------------------------------------
*    CALC_DECODE      DECODE SYMBOL TABLE ENTRY
*
*******************************************************************************
*
*		SPECIFICATIONS
*
	LOGICAL*2 SYMENT(12),FLAGS
*
	INTEGER*2 ITYPE
	INTEGER*4 VALUE
	CHARACTER*80 NAME
	REAL*4 RVALUE
	INTEGER*4 IVALUE
	EQUIVALENCE (RVALUE,IVALUE)
*
*		CODE SECTION
*
	CALL CALC_DECODE(SYMENT, ITYPE, FLAGS, VALUE, NAME, NAME_LEN)
	NAME_LEN = MIN(NAME_LEN,LEN(NAME))
	IF (FLAGS) THEN
	    IF ((FLAGS.AND.2).EQ.0) THEN
		IVALUE = VALUE
		IF (ITYPE.EQ.2) THEN
		    WRITE (12,1000) NAME(1:NAME_LEN),IVALUE
		ELSE
		    WRITE (12,1001) NAME(1:NAME_LEN),RVALUE
		ENDIF
	    ENDIF
	ENDIF
	RETURN
1000	FORMAT(A,' = ',I20)
1001	FORMAT(A,' = ',E20.7)
	END
