	subroutine parse(sid)
	implicit integer (a-z)
	include 'dccom.inc'
	integer*4 starts(8), lens(8)
	parameter (fscan_filespec   = 1,
     +             fscan_node       = 2,
     +             fscan_device     = 3,
     +             fscan_root       = 4,
     +             fscan_dir        = 5,
     +             fscan_name       = 6,
     +             fscan_type       = 7,
     +             fscan_vers       = 8)

	istat = lib$filescan(fspec(sid),starts,lens)

	if (starts(fscan_root) .ne. 0) then
	    lbracket(sid) = starts(fscan_root)
	    if (starts(fscan_dir) .ne. 0) then
		rbracket(sid) = starts(fscan_dir)+lens(fscan_dir)-1
	    else
	        rbracket(sid) = starts(fscan_root)+lens(fscan_root)-1
	    endif
	else
	    lbracket(sid) = starts(fscan_dir)
	    rbracket(sid) = starts(fscan_dir)+lens(fscan_dir)-1
	endif

	if (starts(fscan_file).ne.0) then
	    file(sid) = fspec(sid)(starts(fscan_name):
     +	     starts(fscan_name)+lens(fscan_name)-1)
	else
	    file(sid) = ' '
	endif

	if (starts(fscan_type).ne.0) then
	    type(sid) = fspec(sid)(starts(fscan_type):
     +	     starts(fscan_type)+lens(fscan_type)-1)
	else
	    type(sid) = ' '
	endif

	if (starts(fscan_vers).ne.0) then
	    version(sid) = fspec(sid)(starts(fscan_vers):
     +	     starts(fscan_vers)+lens(fscan_vers)-1)
 	    cend(sid) = starts(fscan_vers)-1
	else
	    version(sid) = ' '
	    cend(sid) = lens(fscan_filespec)
	endif

	return
	end
