C-------------------------------------------------------------------C
C  Directory Management        January 1983                         C
C  Written by John C. Hayre, Texas Instruments                      C
C  Send suggestions and/or complaints to:                           C
C                                                                   C
C               Veeco Integrated Automation			    C
C               10355 Brockwood Rd				    C
C               Dallas, Texas 75238                                 C
C               (Attention John Hayre)                              C
C                                                                   C
C  Phone: 214-349-8482                                              C
C-------------------------------------------------------------------C
C Utilities for Directory Managment:                              C
C-----------------------------------------------------------------C
C
C
C-----------------------------------------------------------------C
C Include a file for - Printing                                   C
C                    - Copying                                    C
C                    - Deleting                                   C
C Put the file that the cursor is beside into the 'INCLUD' array  C
C optionally put an asterik on the CRT.                           C
C-----------------------------------------------------------------C
       Subroutine Include(Cl, Showit)
       Implicit Integer*4 (A - Z)
       Character*128 LName
       Character*1 Debug
       Include 'common.include'
C-----------------------------------------------------------------C
       If (Ld(Cl)(2:2) .NE. '*') then
         Call GetName(Ld(Cl), LName, NamType)  ! Get name 
         If (NamType .LT. 2) then      ! File or Dir?
           Ld(Cl)(2:2) = '*'           ! Insert asterik
           IncluCount = IncluCount + 1 ! Bump include file count
           If (IncluCount .LE. 1) IncluCount = 1 ! Insurance
           IncluLines(IncluCount) = Cl
           Do I = IncluCount - 1, 1, -1
             If (IncluLines(I) .GT. Cl) then 
               IncluLines(I + 1) = IncluLines(I)
               IncluLines(I) = Cl
             End If
           End Do
         End If
       End If !IF NOT "*"
       If (Showit .EQ. 1) then 
	 If (Downlast .EQ. 1) then
	   Call Dnarrow
	 Else
	   Call UpArrow
	 End If
       End If
       Return 
       End
C-----------------------------------------------------------------C
C Exclude Utility:                                                C
C Undo the exclude.  Take the file name out of the 'INCLU' array  C
C and take out the asterik from the 'LD' array.                   C
C-----------------------------------------------------------------C
       Subroutine Exclude
       Implicit Integer*4 (A - Z)
       Include 'common.include'
C-------------------------------------------------------------------C
       Cl = TopLine + CursorLine - 1
       If (Ld(Cl)(2:2) .EQ. '*') then
         Tx = 0  !index of target name
         Do I = 1, IncluCount       !ensure target is in array
           If (IncluLines(I) .EQ. Cl) Tx = I
         End Do
         If (Tx .NE. 0) then            ! take target out of array
           Do I = Tx, IncluCount - 1
             IncluLines(I) = IncluLines(I + 1)
           End Do
           IncluLines(IncluCount) = 0   ! for debug purposes
           IncluCount = IncluCount - 1  ! decrement array count
           SvDLast = DownLast
           Call DnArrow                 ! show asterik removed
           Call UpArrow                 !
           DownLast = SvDLast
           If (IncluCount .LT. 0) IncluCount = 0 ! Insurance
         End If
       End If
       Ld(Cl)(2:2) = ' '            ! remove asterik
       If (Downlast .EQ. 1) then
         Call Dnarrow
       Else
         Call UpArrow
       End If
       Return 
       End
C-------------------------------------------------------------------C
C Output a message to line 23 of the CRT.                           C
C-------------------------------------------------------------------C
       Subroutine Mess(Strng)
       Implicit Integer*4 (A - Z)
       Character*(*) Strng
       Character*8 Temp8
       Include 'common.include'
C-------------------------------------------------------------------C
       Clean23 = 1
       Call Lib$Erase_Line(23, 1)
       Call Writel(ReVideo, 23, 1)
       L = Len(Strng)
       Call Writel(Strng(1:L), 23, 1)
       Call Writel(Dull, 23, L + 2)
       Call Lib$Set_Cursor(23, L + 2)
       Return
       End
C-----------------------------------------------------------------C
C Find String utility.  Look for a string in Ld.  If the string isC
C found show the line, otherwise, put a message on the bottom of  C
C the CRT.                                                        C
C-----------------------------------------------------------------C
       Subroutine ShowSRCH
       Implicit Integer*4 (A - Z)
       Character*1 chom
       Include 'common.include'
C-----------------------------------------------------------------C
       If (SrchSize .LT. 1) Return
       Element = 0
       If (Forward .EQ. 1) then 
         Do 100 I = TopLine + CursorLine, LastLine
           If (Ld(I)(1:26)
     1     .EQ. '                          ') goto 100
           If (Ld(I)(1:32)
     1     .EQ. '         Directories:  Total of ') goto 100
           If (Ld(I)(1:32)
     1     .EQ. '               Files:  Total of ') goto 100
           If (Ld(I)(1:26)
     1     .EQ. '          This Directory: ') goto 100
           If (Ld(I)(1:26)
     1     .EQ. '      Previous Directory: ') Goto 100
           G = Lib$Matchc(Search(1:SrchSize), Ld(I))
           If (G .NE. 0) then 
             Element = I
             Goto 300
           End If
100        Continue 
       Else
         Do 200 I = TopLine + CursorLine - 2, 1, -1
           If (Ld(I)(1:26)
     1     .EQ. '                          ') goto 200
           If (Ld(I)(1:32)
     1     .EQ. '         Directories:  Total of ') goto 200
           If (Ld(I)(1:32)
     1     .EQ. '               Files:  Total of ') goto 200
           If (Ld(I)(1:26)
     1     .EQ. '          This Directory: ') goto 200
           If (Ld(I)(1:26)
     1     .EQ. '      Previous Directory: ') Goto 200
           G = Lib$Matchc(Search(1:SrchSize), Ld(I))
           If (G .NE. 0) then 
             Element = I
             Goto 300
           End If
200      Continue
       End If
C-------------------------------------------------------------------C
C String not found.  Show information message on CRT line 23.       C
C-------------------------------------------------------------------C
       Call Mess(' String not found   ')
       Goto 9999
C-------------------------------------------------------------------C
C String was found.  Show line that has string.                     C
C-------------------------------------------------------------------C
300    Continue
       If (Clean23 .EQ. 1) then 
         Call Fix23
         Clean23 = 0
       End IF
       Cl = TopLine + Cursorline - 1
       Call Writel(Dull, Cursorline, 1)
       Call Writel(Ld(Cl), Cursorline, 1)
       If ((Element .LT. TopLine + 22)  !already at right page
     - .AND. (Element .GE. Topline)) then
         CursorLine = Element - TopLine + 1
       Else
         TopLine = Element
         Cursorline = 1
         Call Write24
         tttt = Topline + Cursorline
         Call UpArrow
         If (TTTT .NE. Topline + Cursorline) then 
           Call DnArrow
         End If
       End If
9999   Return
       End
C-----------------------------------------------------------------C
C Fix CRT line 23 back after putting a message on it.             C
C-----------------------------------------------------------------C
       Subroutine Fix23
       Implicit Integer*4 (A - Z)
       Character*1 G
       Character*8 Temp8
       Character*3 Temp3
       Character*23 Temp23
       Character*80 Temp80
       Include 'common.include'
C-----------------------------------------------------------------C
       Call Writel(Dull, 23, 1)
       Call Writel(UnderLine, 23, 1)
       Call Lib$Put_Screen(Blanks, 23, 1)
       Call Writel(Dull, 23, 76)
       Do I = 11, 63
         X = I
        If ((DisName(I:I) .EQ. ' ') .OR. (DisName(I:I) .EQ. Char(0)))
     -   Goto 200
       End Do
200    Continue             
300      Format(I3)
	 stat = lib$date_time( temp23)
         Call Writel(ReVideo, 23, 65)
         Call Writel('DM '//temp23(13:17), 23, 3)
       Y = 64
       If (Fast .EQ. 1) Y = Y + 14
       Call Writel(Revideo, 23, Y-X)
       Call Writel(DisName(1:X), 23, Y-X)
       Call Writel(Dull, 23, 80)
       If (Fast .EQ. 0) then
         Encode(8, 400, Temp8) Total_Blks
400      Format(I8)
         Call Writel(ReVideo, 23, 65)
         Call Writel(Temp8//' Blocks', 23, 65)
         Call Writel(Dull, 23, 80)
       End If
       Clean23 = 0  ! Tell them that it is clean.
       Return
       End
C-----------------------------------------------------------------C
C Find String utility.  Get the characters to look for from the   C
C user into Search.  Also set srchsize to the string size.        C
C Then call FindStrg.                                             C
C-----------------------------------------------------------------C
       Subroutine FindStrg
       Implicit Integer*4 (A - Z)
       Integer*2 NBytes
       Character*80 Stg
       Include 'common.include'
C-----------------------------------------------------------------C
       Call Mess('Enter search string: ')
       Call KBDName(SEARCH, SRCHSIZE)
       Call Fix23
       Call ShowSrch
       Return
       End
C-----------------------------------------------------------------C
C Get Ptotect Utility:                                            C
C Get the protection of a file passed in X.  Convert it to an     C
C ASCII string of form '(X,X,X,X)' where X is the RWED protectionsC
C of the file.                                                    C
C-----------------------------------------------------------------C
       Subroutine GetProt(X, Stg)
       Implicit Integer*4 (A - Z)
       Character*21 Stg
       Include 'common.include'
C-----------------------------------------------------------------C
       In = 2  !Index into stg
       Stg = '(                    '
       Do I = 1, 4
         Do J = 1, 4
           Call GetPro2(Bitx, X)
           If (Bitx .EQ. 1) then
             If (J .EQ. 1) Stg(In : In) = 'R'
             If (J .EQ. 2) Stg(In : In) = 'W'
             If (J .EQ. 3) Stg(In : In) = 'E'
             If (J .EQ. 4) Stg(In : In) = 'D'
             In = In + 1
           End If
         End Do
         Stg(In:In) = ','
         In = In + 1
       End Do
       Stg(In - 1 : In - 1) = ')'  ! put on top of last ','
       Return 
       End
C-----------------------------------------------------------------C
C Get Ptotect Utility2                                            C
C  Shift bits around.  Very awkard in fortran!                    C
C-----------------------------------------------------------------C
       Subroutine GetPro2(Bitx, Wordx)
       Implicit Integer*4 (A - Z)
       Include 'common.include'
C-------------------------------------------------------------------C
       Y = Wordx / 2
       Y = Y * 2
       If (Y .EQ. Wordx) then 
         Bitx = 1
       Else
         Bitx = 0
       End If
       Wordx = Wordx / 2
       Return 
       End
C-------------------------------------------------------------------C
C Conversion routine for ASCII directory names.                     C
C Used to get the name to print on the top line of the CRT.         C
C InName - Name of a directory - [ALL.IS.WELL.THAT.ENDS]WELL.DIR;1  C
C OutName - Returned previous dir - [ALL.IS.WELL.THAT.ENDS.WELL]    C
C-------------------------------------------------------------------C
       Subroutine PreDIR(InName, OutName)
       Implicit Integer*4 (A - Z)
       Character*128 InName,OutName
       Include 'common.include'
C-------------------------------------------------------------------C
       I = Lib$Matchc(']',InName)
       OutName = InName(1:I)
       Do J = I + 1, 128
         OutName(J:J) = ' '
       End Do
       Return
       End
C-------------------------------------------------------------------C
C ASCII conversion routine.                                         C
C Given the directory name, return the file name of that directory. C
C InName - Name of a directory of form [ALL.IS.WELL.THAT.ENDS.WELL] C
C OutName - Returned name of form [ALL.IS.WELL.THAT.ENDS]WELL.DIR;1 C
C-------------------------------------------------------------------C
       Subroutine RealDIR(InName, OutName)
       Implicit Integer*4 (A - Z)
       Character*128 InName,OutName,XName
       Character*1 cccx
       Include 'common.include'
C-------------------------------------------------------------------C
       If (InName(1:8) .EQ. '[000000]') then
         OutName(1:18) = '[000000]000000.DIR'
         OutName(19:) = ' '
       Else
         I = Lib$Matchc(']',InName)
         Do J = 1, 128 
           If (J .LT. I) then
             OutName(J:J) = InName(J:J)
           Else
             OutName(J:J) = ' '
           End If
         End Do
         Period = Lib$Matchc('.',InName)   
         If (Period .EQ. 0) then           ! add [000000] directory
           Outname(1 : 8) = '[000000]'
           Do K = 2, I - 1
             OutName(7 + K : 7 + K) = InName(K:K)
           End Do
         Else                      ! Has '.''s no need for [000000]
110         J = Lib$Matchc('.',Outname(Period + 1 : 128))
           Period = Period + J               ! I = the last '.'
           If (J .NE. 0) goto 110
           Outname(Period : Period) = ']'
         End If
         I = Lib$Matchc('  ',Outname)
         If (I .EQ. 0) stop
         Outname(I  : I + 3) = '.DIR'
       End If
       I = Lib$Matchc('[000000.000000', OutName) 
       If (I .NE. 0) then 
         G = Lib$Matchc('.000000', OutName(1:14))
         OutName(G:G) = '['
         Do J = 1, (128 - G) + 1
           OutName(J:J) = OutName(J+G-1:J+G-1)
         End Do
       End If
       Return
       End
C-------------------------------------------------------------------C
C SetChoices :  The variable "CHOICES" holds the ASCII that will be C
C  displayed on the bottom line of the CRT.  This is the only place C
C  that CHOICES gets changed.                                       C
C-------------------------------------------------------------------C
       Subroutine SetChoices(Speed)
       Implicit Integer*4 (A - Z)
       Include 'common.include'
C-------------------------------------------------------------------C
	stat = lib$get_symbol( 'DM$EXPERT', choices)
	if (choices .eq. 'Y') then 
	    choices = ' '
	    return
	end if
      If (Speed .LE. 0) then  !all info is displayed
           Choices = 
     -Bright  //'$ % '//
     -          '@ A Z W '
     -//Bright//'U'//Dull//'n'//bright//'T'//dull//'ag '
     -//Bright//'Q'//Dull//'uit e'
     -//Bright//'X'//Dull//'it '
     -//Bright//'R'//Dull//'en '
     -//Bright//'V'//Dull//'iew '
     -//Bright//'E'//Dull//'DT '
     -//Bright//'F'//Dull//'MS '
     -//Bright//'L'//Dull//'ess '
     -//Bright//'D'//Dull//'el '
     -//Bright//'C'//Dull//'opy '
     -//'pur'//
     -  Bright//'G'//Dull//'e '
     -//Bright//'P'//Dull//'rnt '
     -//Bright//'B'//Dull//'as'
      Else
           Choices = 
     -Bright//  '$ % '//
     -          '@ A Z W '
     -//Bright//'U'//Dull//'n'//bright//'T'//dull//'ag '
     -//Bright//'Q'//Dull//'uit e'
     -//Bright//'X'//Dull//'it '
     -//Bright//'R'//Dull//'en '
     -//Bright//'V'//Dull//'iew '
     -//Bright//'E'//Dull//'DT '
     -//Bright//'F'//Dull//'MS '
     -//Bright//'M'//Dull//'ore '
     -//Bright//'I'//Dull//'nfo '
     -//Bright//'D'//Dull//'el '
     -//Bright//'C'//Dull//'opy '
     -//'pur'//Bright//'G'//Dull//'e '
     -//Bright//'P'//Dull//'rnt '
     -//Bright//'B'//Dull//'as'
      End If
100   Return
      End
C-------------------------------------------------------------------C
C InName = One of the lines of the CRT.                             C
C OUTName = Returned name of file.                                  C
C Type = 0 for file type name                                       C
C      = 1 for directory type name                                  C
C      = 2 for 'Previous Directory' type name                       C
C-------------------------------------------------------------------C
       Subroutine GetName(InpName, OutpName, Type)
       Implicit Integer*4 (A - Z)
       Character*128 InpName,OutpName,NameXX
       Include 'common.include'
C-------------------------------------------------------------------C
       Type = 0                 ! Assume a file type
       OutpName = '                                        '
       J = 1
       X = Lib$Matchc('Previous ',InpName) 
       If (X .NE. 0) then 
         J = 27 - 5
         Type = 2               ! 'Previous Directory' type
       End If
       K = 1
100    OutpName(K:K) = InpName(J+5:J+5)
       K = K + 1
       J = J + 1
       If (InpName(J+5:J+5) .NE. ' ') goto 100
       I = Lib$Matchc('.DIR',OutpName)
       If (I .NE. 0) then
         Type = 1   ! It is a 'DIR' not a file type
         NameXX = OutpName    ! Get current directory name
         OutpName = DName
         L = Lib$Matchc(']', OutpName)
         If (L .EQ. 0) Stop
         OutpName(L:L) = '.'
         Do M = 1, I - 1
           L = L + 1
           OutpName(L:L) = NameXX(M:M)
           OutpName(L + 1 : L + 3) = ']  ' ! ensure ends in "[  "
         End Do
       End If
       G = Lib$Matchc('[000000.', OutpName)
       If (G .NE. 0) then 
         G = Lib$Matchc('.', OutpName)
         Do I = G + 1, 128
           OutpName(I-7:I-7) = OutpName(I:I)
         End Do
       End If
       Return
       End
