$!+
$! ANALYZE_CRASH - Analyze last crash for startup
$! =============
$
$! Revision History:
$! -----------------
$! o 24-Oct-1985 [SGD]:
$!   SET NOON
$!-
$
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$ set noon
$
$ pid = f$getjpi("","pid")
$ file = f$parse("sys$startup:crash_" + pid + ".temp")
$
$!Set process name to something other than STARTUP, or SDA won't analyze
$!the dump file.
$
$ proc_is_startup = f$getjpi("","prcnam") .eqs. "STARTUP"
$ if proc_is_startup then set process/name="sda_startup"
$
$!Run SDA on the dump file
$
$ assign/user 'file' sys$output
$ mcr sda
sys$system:sysdump.dmp
$ file = f$search(file)
$ if file .eqs. "" then goto no_crash
$ open/read/err=no_crash crash 'file'
$ lookfor = "Dump taken on "
$crash_loop:
$   read/end=no_crash crash crashline
$   if f$locate(lookfor,crashline) .eq. f$len(crashline) then goto crash_loop
$   crashtime = crashline - lookfor
$   crashtime = f$extr(0,f$len(crashtime)-1,crashtime)
$   read/end=no_crash crash crashline
$   reason = f$edit(f$elem(0,",",crashline),"upcase,collapse")
$   if reason .eqs. "OPERATOR" then goto crash_done
$   emitline "Rebooting from crash at ''crashtime'" "Reason: ''crashline'"
$   goto crash_done
$no_crash:
$ emitline "Unable to analyze system dump"
$crash_done:
$ close crash
$ delete 'file'
$ if proc_is_startup then set process/name="STARTUP"
