$ goto start
$!++
$! CONFIGURE - configure system objects
$! =========
$
$! P1 may optionally be a wildcard of tables to be examined.
$! P2 may optionally be a wildcard spec of objects in the table(s) referenced
$!    by P1 to be configured.
$
$! This command file is called to configure objects into the system.
$! An 'object' is defined as a logical name table entry.  The equivalence
$! strings of the translation of an entry's (object's) name determine how
$! it is configured:
$
$!	Index 0:  Object CLASS.  This denotes the name of a
$!		  CONFIGURE_class.COM file that will be called to
$!		  configure the object.
$!	Index 1:  Object TYPE.  This is object-class dependent
$
$! Further translations may be defined, depending on the object.
$
$! The selection of objects for configuration is alphabetical within
$! each logical name table, and if more than one table is configured,
$! tables are taken in turn, alphabetically.
$
$! For every object entry that is selected from the given logical name table(s)
$! for configuration, the object CLASS forms the name of a configuration
$! command file that is called to configure the object.  The name of the
$! configuration command file is formed as:
$
$!	SYS$STARTUP:CONFIGURE_<class>.COM
$
$! This command file is called with three parameters:
$
$!	P1: The object name, including any node specification.  This
$!	    symbol can be used for f$trnlnm lookups of other translation
$!	    indices of the object,
$!	P2: The object type (first translation),
$!	P3: The logical name table from which the object was
$!	    selected for configuration,
$!	P4: The object name less any node specification.
$
$! The procedure may return a bad status, which will be displayed,
$! or, it may call EMITLINE.COM directly to print messages.
$!--
$start:
$
$ set noon
$ an_lets = "aeiou"
$
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$
$!Get this cluster CPU's nodename.  If none, then set to something that
$!won't match.
$
$ our_node = f$getsyi("scsnode")
$ if our_node .eqs. "" then our_node = f$trnlnm("sys$node","lnm$system_table")
$ if our_node .eqs. "" then our_node = "unknown_node"
$ our_node = f$edit(our_node,"upcase,collapse") - ":" - ":" - "_"
$
$!Display entries in configuration object tables to a scratch file.
$
$ scratch_file = "sys$startup:configure_''our_node'.temp"
$ obj_lnt = "startdefs$objects_*"
$ if p1 .nes. "" then obj_lnt = p1
$ if f$trnlnm("lnt","lnm$process_table") .nes. "" then close lnt
$ if f$search(scratch_file) .nes. "" then delete 'scratch_file';*
$ show log/out='scratch_file'/table=('obj_lnt') 'p2'
$ open/read lnt 'scratch_file'
$
$!Loop across all entries in table.
$
$obj_loop:
$   set noon
$   obj_name = ""
$   obj_class = ""
$   obj_type = ""
$
$!  Read next object definition.
$
$   read/end=obj_loop_done lnt lntline
$
$!  See if new name table
$
$   if f$extr(0,1,lntline) .nes. "(" then goto try_defn
$   obj_lnt = f$edit(lntline,"upcase,collapse") - "(" - ")"
$   goto obj_loop
$
$!  Otherwise, reject line if not initial translation for a name.
$
$  try_defn:
$   if f$locate("=",lntline) .eq. f$length(lntline) then goto obj_loop
$   lntline = f$edit(lntline,"compress,trim")
$
$!  Get object name, and skip if it has a node spec that isn't ours.
$
$   obj_name = f$elem(1,"""",f$edit(f$element(0,"=",lntline),"collapse,upcase"))
$   if obj_name .eqs. """" then goto obj_loop
$
$!  Check node spec to be sure it matches.  If not, skip
$
$   obj_node = f$parse(obj_name,,,"node","syntax_only")
$   obj_id = obj_name - obj_node
$   obj_node = f$edit(obj_node - ":" - ":" - "_","upcase,collapse")
$   if (obj_node .nes. "") .and. (obj_node .nes. our_node) then goto obj_loop
$
$!  If object has no node spec, but an object exists in the same lnt with
$!  a node spec, then ignore this one.
$
$   if (obj_node .eqs. "") .and. -
	(f$trnlnm(our_node + "::" + obj_id,obj_lnt,,,,"max_index") .nes. "") -
	then goto obj_loop
$
$!  Get object class, and check to see that we have a CONFIGURE_class.COM
$!  command file for it.
$
$   obj_class = f$trnlnm(obj_name,obj_lnt)
$   obj_type = f$trnlnm(obj_name,obj_lnt,1)
$   participle = "a"
$   if f$locate(f$extr(0,1,obj_type),an_lets) .ne. f$len(an_lets) then -
	participle = "an"
$
$   cfg_file = f$parse("sys$startup:configure_" + obj_class + ".com")
$   if cfg_file .eqs. "" then goto not_known_class
$   cfg_file = f$search(cfg_file)
$   if cfg_file .eqs. "" then goto not_known_class
$
$!  We have a known class of object.  Log message and call command file
$
$   write sys$output -
	"Configuring ",obj_name," as ",participle," ",-
	"''f$edit(obj_type,"upcase")'"," ",obj_class
$   if obj_class .eqs. "TERMINAL" then goto configure_terminal
$   @'cfg_file' "''obj_name'" "''obj_type'" 'obj_lnt' "''obj_id'"
$   if $status then goto obj_loop
$
$!  Here when error has occurred in configuration proc.
$
$  configure_error:
$   errmsg = f$message($status)
$   goto emit_msg
$
$!  Here when we can't find a configuration file for this object
$
$  not_known_class:
$   errmsg = "Object class ""''obj_class'"" is unknown"
$   goto emit_msg
$
$!  Here to emit error message with message in 'errmsg'
$
$  emit_msg:
$   emitline -
	"Error configuring ''obj_name' as ''participle' ''obj_type' ''obj_class'" -
	"''errmsg'"
$   goto obj_loop
$
$!Here on EOF when reading name table translations
$
$obj_loop_done:
$ if f$trnlnm("lnt","lnm$process_table") .nes. "" then close lnt
$ if f$search(scratch_file) .nes. "" then delete 'scratch_file';*
$ exit
$
$!***** Configure terminals (placed here for speed) *****
$
$configure_terminal:
$ on error then goto configure_error
$ type = f$elem(0,"/",obj_type)
$ extra_quals = obj_type - type
$ type = f$edit(type,"upcase,collapse")
$
$ sysgen = "$sysgen"
$ if type .eqs. "CONSOLE" then sysgen connect 'obj_id''extra_quals'
$
$ type_quals = f$trnlnm(type,"startdefs$terminal_types")
$ if type_quals .eqs. "" then emitline -
	"Error configuring terminal ''obj_name'",-
	"Terminal type ''obj_type' is unknown"
$ if type_quals .eqs. "" then goto obj_loop
$
$ if .not. f$getdvi(obj_id,"exists") then emitline -
	"Error configuring terminal ''obj_name'",-
	"Terminal ''obj_id' is unknown"
$ if .not. f$getdvi(obj_id,"exists") then goto obj_loop
$
$ termname = f$getdvi(obj_id,"fulldevnam")
$ if f$getdvi(termname,"pid") .eqs. "" then goto term_not_owned
$   emitline -
	"Error configuring terminal ''termname'" -
"Terminal ''termname' is owned by ''f$getjpi(f$getdvi(termname,"pid"),"prcnam")'"
$   goto obj_loop
$term_not_owned:
$
$!Do any logical assignments
$
$ assigns = f$edit(f$trnlnm(obj_name,obj_lnt,2),"upcase,collapse")
$ if assigns .eqs. "" then goto term_assigns_loop_done
$ assigns_index = 0
$term_assigns_loop:
$   asnname = f$elem(assigns_index,",",assigns)
$   if (asnname .eqs. ",") .or. (asnname .eqs. "") then -
		goto term_assigns_loop_done
$   assign/nolog/system/exec/name=no_alias 'termname' 'asnname'
$   assigns_index = assigns_index + 1
$   goto term_assigns_loop
$term_assigns_loop_done:
$
$ spldevnam = f$getdvi(f$getdvi(termname,"spldevnam"),"fulldevnam")
$ if spldevnam .nes. termname then set device/nospool 'termname'
$ set term/perm'type_quals''extra_quals' 'termname'
$
$!Set protection if specified
$
$ prot = f$edit(f$trnlnm(type,"startdefs$terminal_types",1),"collapse")
$ if prot .nes. "" then set prot='prot'/device 'termname'
$
$!Respool if needed
$
$ if spldevnam .nes. termname then -
	set device/spool=('termname','spldevnam') 'termname'
$
$!Do any serial assignments required for this type of terminal
$
$ asn = f$edit(f$trnlnm(type,"startdefs$terminal_types",2),"collapse")
$ if asn .eqs. "" then goto term_asns_done
$ index = 0
$term_asns_loop:
$   index = index + 1
$   lnm = f$trnlnm(asn + f$string(index),"lnm$system_table")
$   if lnm .eqs. "" then goto term_asns_loop_done
$   if .not. f$getdvi(lnm,"exists") then goto term_asns_loop
$   thisdev = f$getdvi(lnm,"fulldevnam")
$   if termname .eqs. thisdev then goto term_asns_done
$   goto term_asns_loop
$term_asns_loop_done:
$ assign/system/exec/name=no_alias 'termname' 'asn''index'
$term_asns_done:
$
$ goto obj_loop
