$ goto start
$!+
$! CONFIGURE_PRODUCT - configure a layered product
$! =================
$! Called by CONFIGURE.COM.
$
$! All that this procedure does is to insert the product onto a
$! translation list for SYSTEM_PRODUCTS in the right place, given
$! its relative ordering.  The INSTALL_PRODUCTS.COM command file
$! should then be called to actually start each product.
$!-
$start:
$
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$
$!Check that we have positive integer for order
$
$ order = f$integer(p2)
$ if order .gt. 0 then goto order_ok
$   emitline "Unable to configure product ''p1'" -
	"Relative order ''p2' is invalid"
$   exit
$order_ok:
$
$!Check to see that startup file is there
$
$ comfile = "sys$startup:startup_" + p4 + ".com"
$ if f$search(comfile) .nes. "" then goto comfile_ok
$   emitline "Unable to configure product ''p1'" -
	"Product startup file does not exist"
$   exit
$comfile_ok:
$
$!OK - Setup a new list with this product inserted in the right place
$
$ iprod = 0
$ prodlist = ""
$ orderlist = ""
$ configured = "false"
$getprod_loop:
$   thisprod = f$trnlnm("system_products","lnm$system_table",iprod)
$   thisorder = f$trnlnm("system_product_order","lnm$system_table",iprod)
$   if thisprod .eqs. p4 then goto next_prod
$   if thisorder .eqs. "" then thisorder = "99999999"
$   if configured .or. (thisorder .lt. order) .or. -
	((thisorder .eq. order) .and. (thisprod .lts. p4)) then goto inserted
$     prodlist = prodlist + "," + f$string(p4)
$     orderlist = orderlist + "," + f$string(order)
$     configured = "true"
$  inserted:
$   if thisprod .eqs. "" then goto getprod_loop_done
$   prodlist = prodlist + "," + thisprod
$   orderlist = orderlist + "," + f$string(thisorder)
$  next_prod:
$   iprod = iprod + 1
$   goto getprod_loop
$getprod_loop_done:
$
$ prodlist = prodlist - ","
$ orderlist = orderlist - ","
$
$ assign/sys/exec/name=no_alias/nolog 'prodlist' system_products
$ assign/sys/exec/name=no_alias/nolog 'orderlist' system_product_order
$ exit
