$ goto start
$!++
$! CONFIGURE_TERMINAL - configure a terminal into the system
$! ==================
$! See the preamble to CONFIGURE.COM for details
$!--
$start:
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$
$ type = f$elem(0,"/",p2)
$ extra_quals = p2 - type
$ type = f$edit(type,"upcase,collapse")
$
$ if type .nes. "CONSOLE" then goto not_console_term
$   sysgen = "$sysgen"
$   sysgen connect 'p4''extra_quals'
$not_console_term:
$
$ type_quals = f$trnlnm(type,"startdefs$terminal_types")
$ if type_quals .nes. "" then goto type_ok
$   emitline "Error configuring terminal ''p1'",-
	"Terminal type ''type' is unknown"
$   exit
$type_ok:
$
$ if f$getdvi(p4,"exists") then goto exists
$   emitline "Error configuring terminal ''p1'",-
	"Terminal ''p4' is unknown"
$   exit
$exists:
$
$ termname = f$getdvi(p4,"fulldevnam")
$ if f$getdvi(termname,"pid") .eqs. "" then goto not_owned
$   emitline "Error configuring terminal ''termname'" -
"Terminal ''termname' is owned by ''f$getjpi(f$getdvi(termname,"pid"),"prcnam")'"
$   exit
$not_owned:
$
$!Do any logical assignments
$
$ assigns = f$edit(f$trnlnm(p1,p3,2),"upcase,collapse")
$ assigns_index = 0
$assigns_loop:
$   asnname = f$elem(assigns_index,",",assigns)
$   if (asnname .eqs. ",") .or. (asnname .eqs. "") then goto assigns_loop_done
$   assign/nolog/system/exec/name=no_alias 'termname' 'asnname'
$   assigns_index = assigns_index + 1
$   goto assigns_loop
$assigns_loop_done:
$
$ spldevnam = f$getdvi(f$getdvi(termname,"spldevnam"),"fulldevnam")
$ if spldevnam .nes. termname then set device/nospool 'termname'
$ set term/perm'type_quals''extra_quals' 'termname'
$
$!Set protection if specified
$
$ prot = f$edit(f$trnlnm(type,"startdefs$terminal_types",1),"collapse")
$ if prot .nes. "" then set prot='prot'/device 'termname'
$
$!Respool if needed
$
$ if spldevnam .nes. termname then -
	set device/spool=('termname','spldevnam') 'termname'
$
$!Do any serial assignments required for this type of terminal
$
$ asn = f$edit(f$trnlnm(type,"startdefs$terminal_types",2),"collapse")
$ if asn .eqs. "" then goto asns_done
$ index = 0
$asns_loop:
$   index = index + 1
$   lnm = f$trnlnm(asn + f$string(index),"lnm$system_table")
$   if lnm .eqs. "" then goto asns_loop_done
$   if .not. f$getdvi(lnm,"exists") then goto asns_loop
$   thisdev = f$getdvi(lnm,"fulldevnam")
$   if termname .eqs. thisdev then goto asns_done
$   goto asns_loop
$asns_loop_done:
$ assign/system/exec/name=no_alias 'termname' 'asn''index'
$asns_done:
$
$ exit 1
