$!+
$! CONFIGURE_VOLUME - mount a volume
$! ================
$! See CONFIGURE.COM preamble for details.
$!-
$
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$
$ type = f$elem(0,"/",p2)
$ extra_quals = p2 - type
$ type = f$edit(type,"upcase,collapse")
$ type_quals = f$trnlnm(type,"startdefs$volume_types")
$ if type_quals .nes. "" then goto type_ok
$   emitline "Error configuring disk volume ''p1'",-
	"Disk type ''type' is unknown"
$   exit
$type_ok:
$
$!For console devices, make sure they are connected
$
$ if type .nes. "CONSOLE" then goto console_connected
$   if f$getdvi(p4,"exists") then goto console_connected
$   sysgen = "$sysgen"
$   sysgen connect console
$console_connected:
$
$!Connect and set MSCP server for SERVED-type disks
$
$ if type .nes. "SERVED" then goto serve_checked
$ if .not. f$getdvi(p4,"exists") then goto serve_checked
$   thisnode = f$edit(f$getsyi("scsnode"),"collapse,upcase")
$   servenode = f$edit(f$getdvi(p4,"host_name"),"collapse,upcase")
$   if thisnode .nes. servenode then goto serve_checked
$   sysgen = "$sysgen"
$   sysgen mscp
$   set device/served 'p4'
$serve_checked:
$
$ setvol_quals = f$trnlnm(type,"startdefs$volume_types",1)
$
$!Loop to locate additional disks for possible bound volume set
$
$ devlist = ""
$ labellist = ""
$ dev = p4
$ labelspec = f$trnlnm(p1,p3,2)
$ label = f$elem(0,"/",labelspec)
$ extra_setvol_quals = labelspec - label
$ label = f$edit(label,"upcase,trim")
$ if label .eqs. "" then exit 1
$ index = 3
$dev_loop:
$   if f$getdvi(dev,"exists") then goto exists
$     emitline "Error configuring disk volume ''dev' ''devlist'",-
	"Disk does not exist"
$     exit
$  exists:
$
$   if f$getdvi(dev,"pid") .eqs. "" then goto not_owned
$     emitline "Error configuring disk volume ''dev' ''devlist'",-
	"Disk ''dev' is owned"
$     exit
$  not_owned:
$
$   if label .nes. "" then goto label_ok
$     emitline "Error configuring disk volume ''dev' ''devlist'",-
	"No volume label specified for ''dev'"
$     exit
$  label_ok:
$
$   if .not. f$getdvi(dev,"mnt") then goto mount_checked
$     if f$getdvi(dev,"volnam") .eqs. label then goto mount_checked
$       emitline "Error configuring disk volume ''dev'",-
	"Disk is already mounted, but specified label ''label' disagrees",-
	"This error is probably not serious."
$     exit
$  mount_checked:
$
$!  All checks out.  Add this device and label to the lists
$
$   devlist = devlist + "," + dev
$   labellist = labellist + "," + label
$   dev = f$trnlnm(p1,p3,index)
$   label = f$trnlnm(p1,p3,index+1)
$   index = index + 2
$   if dev .nes. "" then goto dev_loop
$
$!Mount the volume set
$
$ devlist = devlist - ","
$ labellist = labellist - ","
$ if f$getdvi(p4,"mnt") then goto mounted
$   assign/user nl: sys$error
$   mount'type_quals''extra_quals' 'devlist' 'labellist'
$mounted:
$
$!Set the volume attributes if any are requested.  Loop 5 times to try
$!this in case of errors because somebody else is booting and has the
$!volume structure locked up.
$
$ count = 1
$ max = 5
$ quals = setvol_quals + extra_setvol_quals
$ if quals .eqs. "" then goto setvol_loop_done
$setvol_loop:
$ if count .gt. max then goto setvol_loop_done
$   on warning then exit $status
$   if count .gt. 1 then wait 0:0:5
$   if count .eq. max then goto setvol_exec
$    set noon
$    assign/user nl: sys$error
$    assign/user nl: sys$output
$   setvol_exec:
$     count = count + 1
$     set volume'quals' 'p4'
$     if .not. $status then goto setvol_loop
$setvol_loop_done:
$ exit 1
