$ goto start
$!++
$! DISKLOGICALS - Create logical names based on mounted disks
$! ============
$
$! Revision History:
$! -----------------  <place new revisions directly below this line>
$! o Revised 09-Apr-1986 [SGD]:
$!   Add ALLNODES$PUBLIC search list.  This is a search list of all
$!   USER_PUBLIC directories.  I don't know what it is used for, but
$!   this supercedes the old PUBLIC_SRCHLST.COM file that was floating
$!   around.
$
$! o Revised 21-Oct-1985 [SGD]:
$!   Check existence of logicals before reassigning search lists
$
$! o Revised 14-Oct-1985 [SGD]:
$!   Don't include foreign mounted devices
$
$! o Initial version 09-Oct-1985 [SGD]:
$
$! This command procedure examines all system mounted disks and
$! constructs system logical names based on what it finds.  These
$! logicals are:
$
$!	o LOCAL_DRIVES -	A search list of all drives actually
$!				mounted on this CPU, at the time this
$!				command file is run
$
$!	o ddcn -		A 'convenience' logical name that is
$!				assigned the full _$m$ddcn drive spec.
$!				System managers must be careful not
$!				to have two drives of different allocation
$!				classes and the same unit number.
$
$!	o USER_PUBLICxxx	The [000000] directory is searched for
$!				roots of the form PUBLIC*.DIR.  For
$!				any that are found, a USER_PUBLICxxx logical
$!				name is assigned to the corresponding root.
$
$!	o CLUSTER$xxx		The [000000] directory is searched for
$!				roots of the form CLUSTER$xxx.DIR.  For
$!				any that are found, a CLUSTER$xxx logical
$!				name is assigned to the corresponding root.
$!				If a FALLBACK$x is found without a corresponding
$!				CLUSTER$x, then CLUSTER$x is assigned the
$!				translation of FALLBACK$x, and an error message
$!				is generated.  (This is fallover)
$
$!	o FALLBACK$xxx		Analogous to CLUSTER$xxx, except there is
$!				no fallover for fallback roots.
$
$!	o ALLNODES$PUBLIC	Search list of user public roots
$!--
$start:
$
$ if "''emitline'" .eqs. "" then emitline = "@sys$startup:emitline"
$
$ dc$_disk = 1
$ cluster_list = ""
$ fallback_list = ""
$ local_drives = ""
$ public_list = ""
$
$ set noon
$
$ lnt = "lnm$system_table"
$ assign = "assign/nolog/table=''lnt'/exec/name=no_alias"
$ deassign = "deassign/nolog/table=''lnt'/exec"
$
$!Display mounted devices to file.
$
$ pid = f$getjpi("","pid")
$ devfile = "sys$startup:disklogicals_''pid'.tmp"
$ show dev/mounted/out='devfile'
$ devfile = f$search(devfile)
$ open/read devfile 'devfile'
$
$!Loop across all mounted devices
$
$dev_loop:
$
$!  Get next line from file, and skip if not mounted disk.  (Must be
$!  first volume if in volume set.)
$
$   read/end=dev_loop_done devfile devline
$   if f$locate(":",devline) .eq. f$len(devline) then goto dev_loop_next
$   dev = f$elem(0,":",devline)
$   if .not. f$getdvi(dev,"exists") then goto dev_loop_next
$   if f$getdvi(dev,"devclass") .ne. dc$_disk then goto dev_loop_next
$   drivename = f$getdvi(dev,"fulldevnam")
$   if .not. f$getdvi(drivename,"mnt") then goto dev_loop_next
$   if f$getdvi(drivename,"for") then goto dev_loop_next
$   if f$getdvi(drivename,"volnumber") .gt. 1 then goto dev_loop_next
$
$!  Add drive to LOCAL_DRIVES list (assigned below).
$
$   local_drives = local_drives + "," + drivename
$
$!  Assign a logical name without the $n$ stuff (for convenience)
$
$   dn = f$getdvi(drivename,"devnam")
$   if f$elem(1,"$",dn) .nes. "$" then -
		assign 'drivename' 'f$elem(1,"$",dn)'
$
$!  Now search for [PUBLICnnn] directories on the volume, and assign
$!  a name of USER_PUBLICnnn in the system table for them.  (If there
$!  is more than one, a search list is built.)  We also save this for
$!  the ALLNODES$PUBLIC search list.
$
$  assign_public_loop:
$     pubfile = f$search(drivename + "[000000]public*.dir")
$     if pubfile .eqs. "" then goto assign_public_done
$     pubname = f$parse(pubfile,,,"name")
$     pubtran = ""
$     pubindex = 0
$     public_list = public_list + "," + drivename + "[" + pubname + ".]"
$    assign_public_trans_loop:
$       pubval = f$trnlnm("user_" + pubname,lnt,pubindex)
$       if pubval .eqs. "" then goto assign_public_trans_loop_done
$       if f$parse(pubval + "[*...]*.*;*") .eqs. "" then -
		goto assign_public_trans_loop_next
$       pubdev = f$getdvi(f$parse(pubval,,,"device"),"fulldevnam")
$       if pubdev .eqs. drivename then goto assign_public_trans_loop_next
$       pubtran = pubtran + "," + pubval
$      assign_public_trans_loop_next:
$       pubindex = pubindex + 1
$       goto assign_public_trans_loop
$    assign_public_trans_loop_done:
$     pubtran = (pubtran + "," + drivename + "[" + pubname + ".]") - ","
$     assign/trans=(term,conc) 'pubtran' user_'pubname'
$     goto assign_public_loop
$  assign_public_done:
$
$!  Now search for [CLUSTER$x] directories on the volume, and assign
$!  a name of CLUSTER$x in the system table for them.  If there is more
$!  than one, a search list is built.
$
$  assign_cluster_loop:
$     clusfile = f$search(drivename + "[000000]CLUSTER$*.dir")
$     if clusfile .eqs. "" then goto assign_cluster_loop_done
$     clusname = f$parse(clusfile,,,"name")
$     cluster_list = cluster_list + "," + (clusname - "CLUSTER$")
$     clustran = ""
$     clusindex = 0
$    assign_clus_trans_loop:
$       clusval = f$trnlnm(clusname,lnt,clusindex)
$       if clusval .eqs. "" then goto assign_clus_trans_loop_done
$       if f$parse(clusval + "[*...]*.*;*") .eqs. "" then -
		goto assign_clus_trans_loop_next
$       clusdev = f$getdvi(f$parse(clusval,,,"device"),"fulldevnam")
$       if clusdev .eqs. drivename then goto assign_clus_trans_loop_next
$       clustran = clustran + "," + clusval
$      assign_clus_trans_loop_next:
$       clusindex = clusindex + 1
$       goto assign_clus_trans_loop
$    assign_clus_trans_loop_done:
$     clustran = (clustran + "," + drivename + "[" + clusname + ".]") - ","
$     assign/trans=(term,conc) 'clustran' 'clusname'
$     goto assign_cluster_loop
$  assign_cluster_loop_done:
$
$!  Now search for [FALLBACK$x] directories on the volume, and assign
$!  a name of FALLBACK$x in the system table for them.  If there is more
$!  than one, a search list is built.  We also keep a list of fallback
$!  names so that we can do the fallback assignments later.
$
$  assign_fallback_loop:
$     fallfile = f$search(drivename + "[000000]FALLBACK$*.dir")
$     if fallfile .eqs. "" then goto assign_fallback_loop_done
$     fallname = f$parse(fallfile,,,"name")
$     fallback_list = fallback_list + "," + (fallname - "FALLBACK$")
$     falltran = ""
$     fallindex = 0
$    assign_fallback_trans_loop:
$       fallval = f$trnlnm(fallname,lnt,fallindex)
$       if fallval .eqs. "" then goto assign_fallback_trans_loop_done
$       if f$parse(fallval + "[*...]*.*;*") .eqs. "" then -
		goto assign_fallback_trans_loop_next
$       falldev = f$getdvi(f$parse(fallval,,,"device"),"fulldevnam")
$       if falldev .eqs. drivename then goto assign_fallback_trans_loop_next
$       falltran = falltran + "," + fallval
$      assign_fallback_trans_loop_next:
$       fallindex = fallindex + 1
$       goto assign_fallback_trans_loop
$    assign_fallback_trans_loop_done:
$     falltran = (falltran  + "," + drivename + "[" + fallname + ".]") - ","
$     assign/trans=(term,conc) 'falltran' 'fallname'
$     goto assign_fallback_loop
$  assign_fallback_loop_done:
$
$!  Move on to next device
$
$  dev_loop_next:
$   goto dev_loop
$dev_loop_done:
$ close devfile
$ delete 'devfile'
$
$!Strip leading comma and assign LOCAL_DRIVES
$
$ local_drives = local_drives - ","
$ assign 'local_drives' local_drives
$
$!Strip leading comma and assign ALLNODES$PUBLIC
$
$ public_list = public_list - ","
$ assign 'public_list' allnodes$public
$
$!Loop across all FALLBACK$xxx assignments, and verify that a corresponding
$!CLUSTER$xxx name is assigned.
$
$ fallindex = 0
$ fallback_list = fallback_list - ","
$ cluster_list = cluster_list + ","
$ if fallback_list .eqs. "" then goto fallover_loop_done
$fallover_loop:
$
$!  Get next xxx (FALLBACK$xxx), from list built above
$
$   fallelem = f$elem(fallindex,",",fallback_list)
$   if fallelem .eqs. "," then goto fallover_loop_done
$
$!  If we didn't assign corresponding CLUSTER$x name, then deassign it
$
$   if (f$locate("," + fallelem + ",",cluster_list) .eq. -
			f$len(cluster_list)) .and. -
		(f$trnlnm("CLUSTER$" + fallelem,lnt) .nes. "") then -
		deassign CLUSTER$'fallelem'
$
$!  If there is a corresponding CLUSTER$x name, then move on
$
$   if f$trnlnm("CLUSTER$" + fallelem,lnt) .nes. "" then goto fallover_loop_next
$
$!  Issue doom-ish message
$
$   emitline "Warning - using fallback root for CLUSTER$''fallelem'" -
	"CLUSTER$''fallelem' root not found"
$   request "Warning - using fallback root for CLUSTER$''fallelem'"
$
$!  Loop to gather assign list
$
$   falldirindex = 0
$   falldirlist = ""
$  fallover_assign_loop:
$     falldir = f$trnlnm("FALLBACK$" + fallelem,lnt,falldirindex)
$     if falldir .eqs. "" then goto fallover_assign_loop_done
$     falldirlist = falldirlist + "," + falldir
$     falldirindex = falldirindex + 1
$     goto fallover_assign_loop
$  fallover_assign_loop_done:
$
$!  Assign list to cluster name
$
$   falldirlist = falldirlist - ","
$   assign 'falldirlist' CLUSTER$'fallelem'
$
$!  Move to next fallback element and loop
$
$  fallover_loop_next:
$   fallindex = fallindex + 1
$   goto fallover_loop
$fallover_loop_done:
