$ goto start
$!+
$! This is the shell used by SUBMIT_SYSJOB that executes the requested
$! command file, and causes rescheduling where appropriate.
$
$! Format:
$
$!	@EXECUTE_SYSJOB <comfile> <name> <start> <interval> <parameters> <quals>
$
$! S. Duff April 1986
$!
$! Revision History:
$! -----------------
$! o Parse comfile name against version ;0 to get latest version of the file
$!-
$start:
$ verify = f$verify(0)
$
$ comfile = f$search(f$parse(";0",f$edit(p1,"upcase,collapse")))
$ jobname = f$edit(p2,"upcase,collapse")
$ start = f$edit(p3,"upcase,collapse")
$ interval = f$edit(p4,"upcase,collapse")
$ parameters = p5
$ quals = p6
$
$ if interval .eqs. "" then goto reschedule_done
$   next_time = f$cvtime(start + "+" + interval, "absolute")
$   nowc = f$cvtime("","comparison")
$
$!  Loop until the next submission time is now or later
$
$  next_time_loop:
$     next_time = f$edit(next_time,"compress,trim,upcase")
$     next_time = f$elem(0," ",next_time) + ":" + f$elem(1," ",next_time)
$     ntc = f$cvtime(next_time,"comparison")
$     if ntc .ges. nowc then goto next_time_loop_done
$     next_time = f$cvtime(next_time + "+" + interval,"absolute")
$     goto next_time_loop
$  next_time_loop_done:
$
$!  Submit job for rescheduling
$
$   @sys$startup:submit_sysjob -
	"''comfile'" -
	"''jobname'" -
	"''interval'" -
	"''next_time'" -
	 "" -
	"''parameters'" -
	"''quals'"
$
$!Here when ready to do it
$
$reschedule_done:
$ if verify then set verify
$ @'comfile' 'parameters'
$ exit
