$!+
$! GETJOBS - Find all jobs on a given batch queue
$
$! This is a peculiar little command file that takes a batch
$! queue name as P1, and examines the queue.  It forms a comma
$! separated list of job names in the global DCL symbol given by P2
$! The format of the symbol is:
$
$!	"jobname(entry#,user),jobname(entry#,user),..."
$
$! Jobs in execution aren't counted here.
$
$! S. Duff Apr-1986
$!-
$
$ on error then goto done
$ 'p2' == ""
$ pid = f$getjpi("","pid")
$ copy nl: 'pid'.tmp
$ queuefile = f$search(pid + ".tmp")
$ open/append queuefile 'queuefile'
$ show queue/all/output=queuefile 'p1'
$ close queuefile
$ open/read queuefile 'queuefile'
$
$!Discard up to header
$
$skip_header:
$   read/end=done queuefile qline
$   if f$locate("-------",qline) .eq. f$len(qline) then goto skip_header
$
$!Loop on jobs
$
$job_loop:
$   read/end=done queuefile qline
$   qline = f$edit(qline,"compress,upcase,trim")
$   job = f$elem(0," ",qline)
$   if f$elem(1," ",qline) .nes. " " then goto get_vals
$     read/end=done queuefile qline
$     qline = f$edit("DUMMY_JOB" + qline,"compress,upcase,trim")
$  get_vals:
$   if f$elem(3," ",qline) .eqs. "EXECUTING" then goto job_loop
$   user = f$elem(1," ",qline)
$   entry = f$elem(2," ",qline)
$   'p2' == 'p2' + "," + job + "(" + entry + "," + user + ")"
$   goto job_loop
$
$!Here when finished
$
$done:
$ set noon
$ status = $status
$ close queuefile
$ delete 'queuefile'
$ 'p2' == 'p2' - ","
$ exit status
