$ goto start
$!++
$! STARTUP.COM - Configure cluster node at startup (Stage II of startup)
$! ===========
$
$! P1 = message to be displayed
$
$! Revision History:
$! -----------------
$! o 22-Apr-1986 [SGD]:
$!   Set ACL on system lnts - (security hole)
$
$! o 01-Apr-1986 [SGD]:
$!   Turn off mag tape errors
$
$! o 10-Feb-1986 [SGD]:
$!   Configure form definitions
$
$! o 04-Feb-1986 [SGD]:
$!   Insure we have privs by turning on (or else)
$
$! o 15-Jan-1985 [SGD]:
$!   Turn on mag tape errors (for now)
$
$! o 30-Dec-1985 [SGD]:
$!   Configure NETWORK objects
$
$! o 11-Dec-1985 [SGD]:
$!   Use SYSGEN IJOBLIM as number of interactive logins allowed.
$
$! o 31-Oct-1985 [SGD]:
$!   Setup image accounting after log name configuration
$
$! o 17-Oct-1985 [SGD]:
$!   Don't do REPLY notification if not startup process
$!   Configure SYSJOBS
$
$! o 09-Oct-1985 [SGD]:
$!   Initial version
$
$! Notes to maintainers:
$! ---------------------
$! The goals of this startup file are:
$
$! o Start any CPU in the cluster,
$! o Keep startups reasonably quick and foolproof,
$! o Modularize the startup process and make it maintainable,
$! o Be cluster-common.
$
$! This file should normally not require revision.  The
$! following files are called in the startup process.
$! To affect the startup process, you would normally modify
$! one of these files:
$
$! o SYS$STARTUP:STARTDEFS.COM.  This file contains the object
$!   and type definitions for all known objects in the cluster.
$!   Objects are things such as devices, disk volumes, forms,
$!   queues and products.
$
$! o SYS$STARTUP:STARTUP_<product>
$!   Startup file for product named <product>.  If you are adding a new
$!   product to the system, just create a SYS$STARTUP:STARTUP_product.COM
$!   file for it, and add the product name to the known product objects
$!   in STARTDEFS.  This file should also be callable to reinstall the
$!   product while the system is running, insofar as that is possible. 
$!
$! Under no circumstances should the following types of code be added
$! to this file:
$
$! o "ON anything".  This will cause errors to abort the startup process,
$! o CPU-dependent commands.  These will cause errors on other CPUs.
$! o Node-specific startup code - this causes node-to-node variances in
$!   cluster configuration,
$! o 'Junk' comments.  This includes clutter like commenting out startup
$!   circuits that are no longer used, and the like.  A simple entry in
$!   the revision history is sufficient to document changes.  Keep the
$!   startup code neat, and clear of revision commentary,
$! o Any code that could potentially cause the startup to abort.
$!--
$start:
$
$ display = "write sys$output"
$ set noon
$
$!Set privileges
$
$ set proc/priv=all
$ if .not. $status then exit
$
$!Figure our node name
$
$ node = f$edit(f$getsyi("scsnode"),"upcase,collapse")
$ if node .eqs. "" then node = "UNNAMED_NODE"
$
$!Setup log file for later delivery to system managers
$
$ startup_log_file = f$parse("sys$startup:startup.log")
$ copy nl: 'startup_log_file'
$ startup_log_file = f$search(startup_log_file)
$ open/append err_file 'startup_log_file'
$ assign err_file sys$error
$
$ emitline = "@sys$startup:emitline"
$
$!Begin log file with a message
$
$ msg = "Startup commencing for cluster node ''node' at ''f$time()'"
$ dashes = "----------------"
$ dashes = f$extr(0,f$len(msg),dashes + dashes + dashes + dashes + dashes)
$ emitline "''msg'" "''dashes'" "''p1'"
$
$!Fix ACL protection on system logical tables (V4.2 security hole).
$!This may be removed when VMS is fixed. [SGD]
$
$ set acl/object=logical/acl=(id=[*,*],access=r) lnm$system_table
$ set acl/object=logical/acl=(id=[*,*],access=r) lnm$system_directory
$
$!Establish configuration logical name tables
$
$ display " "
$ display "Establishing cluster configuration..."
$ if .not. f$trnlnm("startdefs$config","lnm$system_directory",,,,"table") then -
	create/name/exec/parent=lnm$system_directory startdefs$config
$ @sys$startup:startdefs
$
$!Turn off mag tape errors
$
$ display " "
$ display "Disabling mag tape errors..."
$ if f$getdvi("mta0","exists") then set device/noerror mta0:
$ if f$getdvi("msa0","exists") then set device/noerror msa0:
$ if f$getdvi("mma0","exists") then set device/noerror mma0:
$
$!Analyze last crash
$
$ display " "
$ display "Analyzing previous shutdown..."
$ @sys$startup:analyze_crash
$
$!Load virtual terminal driver for disconnectable terminals
$
$ sysgen = "$sysgen"
$ if .not. f$getdvi("vta0","exists") then -
	sysgen connect vta0/noadap/driver=ttdriver
$
$!Mount drives
$
$ display " "
$ display "Mounting disk volumes..."
$ @sys$startup:configure startdefs$objects_volumes
$
$!Assign cluster logicals
$
$ display " "
$ display "Building rooted logicals..."
$ @sys$startup:disklogicals
$
$!Establish basic system logicals
$
$ display " "
$ display "Configuring system logicals..."
$ @sys$startup:configure startdefs$objects_lognames
$
$!Enable/disable image level accounting
$
$ enable = "Enabl"
$ if .not. f$trnlnm("acc_image","startdefs$config") then enable = "Disabl"
$ display " "
$ display "''enable'ing image accounting"
$ set account/'enable'=image
$
$!Install system help library
$
$ display " "
$ display "Installing system help library"
$ @sys$startup:assignhelp sys$help:helplib.hlb
$
$!Configure terminals
$
$ display " "
$ display "Configuring terminal lines"
$ @sys$startup:configure startdefs$objects_terminals "''node'::*"
$
$!Start the symbiont manager
$
$ display " "
$ display "Starting queue manager..."
$ bufcnt = f$trnlnm("queman_buffer_count","startdefs$config")
$ if bufcnt .eqs. "" then bufcnt = "50"
$ start/manager/buffer_count='bufcnt'
$
$!Configure network objects
$
$ display " "
$ display "Configuring known network objects..."
$ @sys$startup:configure startdefs$objects_network
$
$!Initialize layered products
$
$ display " "
$ display "Configuring layered products..."
$ @sys$startup:configure startdefs$objects_products
$
$ display " "
$ display "Starting layered products..."
$ @sys$startup:install_products
$
$!Initialize forms
$
$ display " "
$ display "Initializing forms..."
$ @sys$startup:configure startdefs$objects_forms
$
$!Initialize print queues
$
$ display " "
$ display "Initializing print queues..."
$ @sys$startup:configure startdefs$objects_printqueues
$ @sys$startup:assprnt.com
$
$!Initialize batch queues
$
$ display " "
$ display "Initializing batch queues..."
$ @sys$startup:configure startdefs$objects_batchqueues
$
$!Submit sysjobs
$
$ display " "
$ display "Submitting sysjobs"
$ @sys$startup:configure startdefs$objects_sysjobs
$
$!Set interactive job limit for system startup command file
$
$ startup$interactive_logins == f$getsyi("IJOBLIM")
$
$!Now record the location of the startup disk for the next boot
$
$ display " "
$ display "Recording new startup boot file..."
$ dev = f$parse("cluster$sysmgr:[startup]",,,"device","no_conceal")
$ bootdev = f$getdvi(dev,"fulldevnam")
$ bootlabel = f$getdvi(dev,"volnam")
$ boot_params_file = "sys$specific:[sysmgr]bootparams.dat"
$ copy nl: 'boot_params_file'
$ boot_params_file = f$search(boot_params_file)
$ open/append bf 'boot_params_file'
$ write bf "$! This is a startup bootstrap command file.  DO NOT DELETE IT!"
$ write bf "$! Written by startup @ ''f$time()'"
$ write bf "$"
$ write bf "$ bootpack == ""''bootdev'"""
$ write bf "$ bootpack_label == ""''bootlabel'"""
$ write bf "$ exit"
$ close bf
$ set prot=(sy:re,ow:re,gr:re,wo:re) 'boot_params_file'
$ purge/nolog 'f$elem(0,";",boot_params_file)'
$
$!Clean up
$
$ msg = "Startup complete for cluster node ''node' at ''f$time()'"
$ dashes = "----------------"
$ dashes = f$extr(0,f$len(msg),dashes + dashes + dashes + dashes + dashes)
$ emitline "''msg'" "''dashes'" "''p1'"
$
$ display " "
$ display "Cleaning up..."
$ close err_file
$ deas sys$error
$
$!Mail startup log to users
$
$ if f$getjpi("","prcnam") .nes. "STARTUP" then goto notify_done
$ mailto = f$trnlnm("startup_mail_recipients","startdefs$config")
$ if mailto .nes. "" then display "Mailing startup log to ''mailto'..."
$ if mailto .nes. "" then -
	mail/subj="''node' Startup" 'startup_log_file' 'mailto'
$
$!Done
$
$ reply/all/bell "Node ''node' is now available"
$ wait 0:0:5
$notify_done:
$
$ display " "
$ display "STARTUP COMPLETE - Node ''node' is now available"
$ display "------------------------------------------------"
$ display " "
$
$ purge/keep=3 'f$elem(0,";",startup_log_file)'
$ if f$trnlnm("sys$startup","lnm$process_table") .nes. "" then deas sys$startup
