$
$! This command file can be called to build system logicals for
$! other nodes in the cluster.  These logicals are called 'node'$xxx
$! and are inserted into the system logical name table.  Examples
$! are node$SYSROOT, node$SPECIFIC, node$COMMON and node$SYSTEM.
$! These logicals have the effect for the other nodes in the cluster
$! that SYS$xxx names have on the local host.
$
$! S. Duff 16-Sep-1985
$
$! Revised 28-Mar-1986 [SGD]:
$! o Add SYSTEM_DRIVES logical - logical name containing all system disks
$
$! Revised 16-Oct-1985 [SGD]:
$! o Build ALLNODES$xxx logicals
$
$! Revised 15-Oct-1985 [SGD]:
$! o Build CLUSTER_NODES logical
$
$!Prevent errors from blowing us up.
$
$ set noon
$
$!Equivalence string used when multiple roots.
$
$ bizarre_name = "!!! Warning - multiple roots exist for this system !!!"
$
$!Name of SYSGEN display file
$
$ root_tempfile = "sys$startup:scsnode_" + f$getjpi("","pid") + ".temp"
$
$!Type of assignment that is done
$
$ assign_sysname = "assign/sys/exec/name=no_alias/nolog"
$
$!Initialize cluster nodes
$
$ system_drives = ""
$ cluster_nodes = ""
$
$!List of <directory>=<name> pairs for SYS$<name> logicals equivalenced to
$!'node'$sysroot:[<directory>].
$
$ subroot_list = "syserr=errorlog,syshlp.examples=examples," + -
	"syshlp=help,syscbi=instruction,syslib=library," + -
	"sysmaint=maintenance,sysmgr=manager,sysmsg=message," + -
	"syslib=share,sysexe=system,sysupd=update"
$
$!Search all roots to which we have access.  Leave out SYSE and SYSF
$
$root_loop:
$
$!  Get next root directory in search list.  Done if none.
$
$   root_dir = f$search("local_drives:[000000]sys%.dir;0",1)
$   if root_dir .eqs. "" then goto root_loop_done
$
$!  Leave out SYSE and SYSF stuff
$
$   root_name = f$parse(root_dir,,,"name","syntax_only")
$   if (root_name .eqs. "SYSE") .or. (root_name .eqs. "SYSF") then -
		goto root_loop_next
$
$!  Look for system parameter file in root.  Move on if none.
$
$   root_openspec = f$parse("''root_dir'",,,"device","syntax_only") + "[" + -
		f$parse(root_dir,,,"name","syntax_only")
$   root_parfile = root_openspec + ".sysexe]vaxvmssys.par"
$   if f$search("''root_parfile'",2) .eqs. "" then goto root_loop_next
$
$!  Use the parameter file to display SCSNODE into a file.
$
$   assign/user 'root_parfile' parfile
$   assign/user 'root_tempfile' sys$output
$   mcr sysgen
use parfile
show scsnode
exit
$   if .not. $status then goto root_loop_next
$   open/read/err=root_loop_next scsnode 'root_tempfile'
$   read/end=root_loop_next scsnode scsnode_line
$   close scsnode
$
$   thisnode = f$elem(1,"""",scsnode_line)
$   if thisnode .eqs. """" then goto root_loop_next
$   thisnode = f$edit(thisnode,"collapse")
$   thisnode_sysroot = thisnode + "$sysroot"
$   assigned = thisnode + "_assigned"
$   assigned = "''&assigned'" .nes. ""
$   if assigned then goto root_already_assigned
$
$!  Assign node$xxx logicals in system table.
$
$   assign_sysname 'root_openspec'.]/trans=(term,conc) -
		'thisnode'$specific
$   assign_sysname 'root_openspec'.syscommon.]/trans=(term,conc) -
		'thisnode'$common
$   assign_sysname 'root_openspec'.]/trans=(term,conc),'thisnode'$common -
		'thisnode'$sysroot
$   'thisnode'_assigned = "YES"
$   goto root_assign_subroot
$
$!  Here when root has been assigned already during this run.  Assign
$!  some bizarre name that won't work for anything.
$
$  root_already_assigned:
$   assign_sysname "''bizarre_name'" 'thisnode'$specific
$   assign_sysname "''bizarre_name'" 'thisnode'$common
$   assign_sysname "''bizarre_name'" 'thisnode'$sysroot
$
$!  Now loop to assign 'thisnode'$sysroot directories
$
$  root_assign_subroot:
$   idir = 0
$  root_assign_subroot_loop:
$     subroot_spec = f$elem(idir,",",subroot_list)
$     if subroot_spec .eqs. "," then goto root_assign_subroot_loop_done
$     subroot_dir = f$elem(0,"=",subroot_spec)
$     subroot_name = f$elem(1,"=",subroot_spec)
$     if .not. assigned then assign_sysname -
		'thisnode'$sysroot:['subroot_dir'] -
		'thisnode'$'subroot_name'
$     if assigned then 	assign_sysname -
		"''bizarre_name'" 'thisnode'$'subroot_name'
$     idir = idir + 1
$     goto root_assign_subroot_loop
$  root_assign_subroot_loop_done:
$
$!  Remember on cluster_node list
$
$   cluster_nodes = cluster_nodes + "," + thisnode
$   device = "," + f$getdvi(f$parse(root_dir,,,"device"),"fulldevnam")
$   if f$locate(device, system_drives) .eq. f$len(system_drives) then -
		system_drives = system_drives + device
$
$!  Merge to move on to next root
$
$  root_loop_next:
$   goto root_loop
$
$!Here when finished
$
$root_loop_done:
$
$!Get rid of scratch files
$
$ if f$search(root_tempfile) .nes. "" then delete 'root_tempfile';*
$
$!Assign cluster_nodes logical
$
$ cluster_nodes = cluster_nodes - ","
$ assign_sysname 'cluster_nodes' cluster_nodes
$
$!Assign system_drives logical
$
$ system_drives = system_drives - ","
$ assign_sysname 'system_drives' system_drives
$
$!Build ALLNODES$xxx logicals
$
$ allnodes_index = 0
$ allnodes_str = ""
$allnodes_node_loop:
$   allnodes_node = f$elem(allnodes_index,",",cluster_nodes)
$   if (allnodes_node .eqs. "") .or. (allnodes_node .eqs. ",") then -
	goto allnodes_node_loop_done
$   allnodes_str = allnodes_str + "," + allnodes_node + "$'allnodes_dir'"
$   allnodes_index = allnodes_index + 1
$   goto allnodes_node_loop
$allnodes_node_loop_done:
$ allnodes_str = assign_sysname + " " + (allnodes_str - ",") + -
	" allnodes$'allnodes_dir'"
$
$!Now loop across the directories, assigning ALLNODES$dir
$
$ allnodes_index = 0
$allnodes_dir_loop:
$   allnodes_dir = f$elem(allnodes_index,",",subroot_list)
$   if (allnodes_dir .eqs. "") .or. (allnodes_dir .eqs. ",") then -
	goto allnodes_dir_loop_done
$   allnodes_dir = f$elem(1,"=",allnodes_dir)
$   'allnodes_str'
$   allnodes_index = allnodes_index + 1
$   goto allnodes_dir_loop
$allnodes_dir_loop_done:
$
$!Assign search list logicals
$
$ allnodes_dir = "specific"
$ 'allnodes_str'
$ allnodes_dir = "common"
$ 'allnodes_str'
$ allnodes_dir = "sysroot"
$ 'allnodes_str'
