$!+
$! Build logical name searchlist for SYS$ENVROOT.  We make a list
$! out of all the ddcu:[SYSn.SYSENV] and then all the
$! ddcu:[SYSn.SYSCOMMON.SYSENV] directories.
$
$! Revised 17-Sep-1985 [SGD]:
$! o Install help libarary
$
$! Revised 08-Sep-1985 [SGD]:
$! o Search CLUSTER$SYSENV device roots.
$
$! Revised 04-Sep-1985 [SGD]:
$! o Use LOCAL_DRIVES logical.  Search for SYSENV.DIR top-level directories
$!-
$
$ set noon
$ assign_sys = "assign/sys/exec/name=no_alias"
$
$ sysenv_str = ""
$ sysenvroot_str = ""
$ sysenvcom_str = ""
$ sysenvcomroot_str = ""
$ topsys = f$trnlnm("sys$topsys","lnm$system_table")
$
$!Kill any existing definitions
$
$ if f$trnlnm("sys$env","lnm$system_table") .nes. "" then -
	deas/sys/exec sys$env
$ if f$trnlnm("sys$envroot","lnm$system_table") .nes. "" then -
	deas/sys/exec sys$envroot
$ if f$trnlnm("sys$env_common","lnm$system_table") .nes. "" then -
	deas/sys/exec sys$env_common
$ if f$trnlnm("sys$envroot_common","lnm$system_table") .nes. "" then -
	deas/sys/exec sys$envroot_common
$
$!Loop across all known drives, looking for specific, top-level and
$!common sysenv roots.
$
$ idrive = 0
$search_loop:
$
$!  Get next drive in list
$
$   drive = f$trnlnm("local_drives","lnm$system_table",idrive)
$   if drive .eqs. "" then goto search_loop_end
$
$!  Look for "ddcu:[SYSn]SYSENV.DIR", and use it for next specific sysenv
$!  list element if found.
$
$   dir = drive + "[" + topsys + "]" + "sysenv.dir"
$   if f$search("''dir'") .eqs. "" then goto try_common
$     str = "," + drive + "[" + topsys + ".sysenv"
$     sysenv_str = sysenv_str + str + "]"
$     sysenvroot_str = sysenvroot_str + str + ".]/tran=(term,conc)"
$
$!    Look for "ddcu:[SYSn.SYSCOMMON]SYSENV.DIR" and use it for next common
$!    sysenv list element if found.
$
$    try_common:
$     dir = drive + "[" + topsys + ".syscommon]" + "sysenv.dir"
$     if f$search(dir) .eqs. "" then goto try_top_level
$       str = "," + drive + "[" + topsys + ".syscommon.sysenv"
$       sysenvcom_str = sysenvcom_str + str + "]"
$       sysenvcomroot_str = sysenvcomroot_str + str + ".]/tran=(term,conc)"
$
$!    Look for "ddcu:[000000]SYSENV.DIR" and use it for next common
$!    sysenv list element if found.
$
$    try_top_level:
$     dir = drive + "[000000]" + "sysenv.dir"
$     if f$search(dir) .eqs. "" then goto try_system_sysenv
$       str = "," + drive + "[sysenv"
$       sysenvcom_str = sysenvcom_str + str + "]"
$       sysenvcomroot_str = sysenvcomroot_str + str + ".]/tran=(term,conc)"
$
$!    Look for "ddcu:[000000]SYSENV.DIR" and use it for next common
$!    sysenv list element if found.
$
$    try_system_sysenv:
$     dir = drive + "[000000]" + "cluster$sysenv.dir"
$     if f$search(dir) .eqs. "" then goto search_next
$       str = "," + drive + "[cluster$sysenv"
$       sysenvcom_str = sysenvcom_str + str + "]"
$       sysenvcomroot_str = sysenvcomroot_str + str + ".]/tran=(term,conc)"
$
$!  Move on to next drive
$
$  search_next:
$   idrive = idrive + 1
$   goto search_loop
$search_loop_end:	
$
$!Add common directory logical names to search list if they exist
$
$ if sysenvcom_str .nes. "" then sysenv_str = sysenv_str + ",sys$env_common:"
$ if sysenvcomroot_str .nes. "" then sysenvroot_str = sysenvroot_str + -
	",sys$envroot_common:"
$
$!Strip leading (bogus) commas
$
$ sysenv_str = sysenv_str - ","
$ sysenvroot_str = sysenvroot_str - ","
$ sysenvcom_str = sysenvcom_str - ","
$ sysenvcomroot_str = sysenvcomroot_str - ","
$
$!Assign
$
$ if sysenv_str .nes. "" then assign_sys 'sysenv_str' sys$env
$ if sysenvroot_str .nes. "" then assign_sys 'sysenvroot_str' -
	sys$envroot
$ if sysenvcom_str .nes. "" then assign_sys 'sysenvcom_str' -
	sys$env_common
$ if sysenvcomroot_str .nes. "" then assign_sys 'sysenvcomroot_str' -
	sys$envroot_common
$
$!Install help library
$
$ @sys$startup:assignhelp sys$env:sysenv.hlb
