$ goto start
$!+
$! This command file is used to control the submission of system jobs
$! to the SYSTEM batch queue.  The format is:
$
$! @SUBMIT_SYSJOB <comfile> <name> <intvl> <start> <control> <params> <quals>
$
$! where:
$!	<comfile>	- The name of the command file to be submitted.
$!	<name>		- The job name.  If blank, the filename is used.
$!	<intvl>		- The rescheduling interval.  If null, the
$!			  job is only run once.
$!	<start>		- The time the job is to be first run.  If null,
$!			  the job is run immediately.
$!			  In addition to any normal DCL absolute time
$!			  specifications, the form <day>+<delta-time>
$!			  is admissible.
$!	<control>	- A string of options, separated by commas as
$!			  follows:
$!				HOLD -  Do not recompute the queue
$!					state if it has already been
$!					computed.  This is mainly used
$!					by startup for efficiency reasons.
$!				DELETE- If there are existing job(s) with
$!					the same name, they are deleted
$!					from the queue before this job is
$!					submitted.
$!				CHECK-	Only submit the job if it is
$!					Not on the queue.  This option
$!					also causes elimination of any
$!					duplicate jobs with this name
$!					on the queue.  When used with
$!					DELETE, this option is redundant.
$!	<params>	- The parameters to be passed to the job (may be
$!			  null.  The string should not contain quotes.
$!	<quals>		- Additional submit qualifiers.  This should be
$!			  non-null only in exceptional circumstances.
$
$! S. Duff April 1986
$!-
$start:
$ days = ",MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY,SATURDAY,SUNDAY"
$
$!Get parameters in named variables
$
$ file = f$edit(p1,"upcase,collapse")
$ filespec = f$search(f$parse(file,".com"))
$ if filespec .eqs. "" then -
	@sys$startup:emitline -
	"Error submitting system job ''file'" -
	"File not found"
$ if filespec .eqs. "" then exit
$ jobname = f$edit(p2,"upcase,collapse")
$ if jobname .eqs. "" then jobname = f$parse(filespec,,,"name")
$ interval = f$edit(p3,"upcase,collapse")
$ start = f$edit(p4,"upcase,collapse")
$ cntstr = "," + f$edit(p5,"upcase,collapse")
$ params = p6
$ quals = p7
$
$ option_hold = f$locate(",HOLD",cntstr) .ne. f$len(cntstr)
$ option_delete = f$locate(",DELETE",cntstr) .ne. f$len(cntstr)
$ option_check = f$locate(",CHECK",cntstr) .ne. f$len(cntstr)
$
$ if (.not. option_delete) .and. (.not. option_check) then goto submit_it
$
$ if (.not. option_hold) .or. ("''system_jobs'" .eqs. "") then -
	@sys$startup:getjobs system system_jobs
$ if f$extr(0,1,system_jobs) .nes. "," then system_jobs == "," + system_jobs
$
$!Loop to delete jobs (if DELETE given), and build list of entries
$!on the queue with this name
$
$ count = 0
$ joblist = system_jobs
$ check_loop:
$     pos = f$locate("," + jobname + "(", joblist)
$     if pos .eq. f$len(joblist) then goto check_loop_done
$     count = count + 1
$     joblist = f$extr(pos,1024,joblist)
$     joblist = joblist - ("," + jobname + "(")
$     entry = f$elem(0,",",joblist)
$     joblist = joblist - (entry + ",")
$     user = f$elem(0,")",joblist)
$     joblist = joblist - (user + ")")
$
$!    If DELETE, or if CHECK with a count above 1, then delete this job
$
$     if (.not. option_delete) .and. -
		(.not. (option_check .and. (count .gt. 1))) then goto check_loop
$     delete/entry='entry' system
$     goto check_loop
$check_loop_done:
$
$!If CHECK and count non-zero then just exit
$
$ if (option_check .and. (count .gt. 0)) then exit
$
$!Submit the job
$
$submit_it:
$
$! Take care of starting time.  This involves a little hair, since we
$! allow the non-DCL form "<day>+<delta-time>" (e.g. "Friday+0-4::")
$
$ after_qual = ""
$ if start .eqs. "" then goto do_submit
$   day = f$elem(0,"+",start)
$   if f$locate("," + day,days) .eq. f$len(days) then goto start_set
$   start = start - (day + "+")
$   this_time = f$cvtime("today","absolute")
$
$!  Loop to get this_time set to the time of the correct day
$
$  day_loop:
$     if f$edit(f$cvtime(this_time,,"weekday"),"upcase,collapse") .eqs. day then -
		goto day_loop_done
$     this_time = f$cvtime(this_time + "+1-0::","absolute")
$     goto day_loop
$  day_loop_done:
$
$!  Add user's delta time to this_time.  We are getting close.
$
$   this_time = f$cvtime("''this_time'+''start'","absolute")
$
$!  Now loop, adding one week at a time to this_time while is before the
$!  current time.
$
$  week_loop:
$   if f$cvtime(this_time,"comparison") .ges. f$cvtime("","comparison") then -
	goto week_loop_done
$   this_time = f$cvtime(this_time + "+7-0::","absolute")
$   goto week_loop
$  week_loop_done:
$
$!  Set the start time in valid DCL form
$
$   start = f$edit("''this_time'","upcase,compress,trim")
$
$!  Merge when "start" has the starting time
$
$  start_set:
$   start = f$cvtime(start,"absolute")
$   start = f$elem(0," ",start) + ":" + f$elem(1," ",start)
$   after_qual = "/AFTER=""" + start + """"
$do_submit:
$ submit-
	/que=system-
	'after_qual'-
	/param=("''filespec'","''jobname'","''start'","''interval'","''params'","''quals'")-
	/name='jobname' -
	/nolog -
	/noprint -
	/keep -
	/nonotify -
	/user=system -
	'quals' -
	sys$startup:execute_sysjob
