	PROGRAM INQUIRE_CALL_DEMO
C
C	This program demonstrates the use of the INQUIRE program
C	call interface.  It loops until the user hits a terminator
C	key on the terminal (<return>, control key, etc.) and then
C	calls routine ACTION with the terminator key that was struck
C
	IMPLICIT NONE
	INCLUDE 'SYS$ENVROOT:[INQUIRE]INQCALFOR.DEF/NOLIST'
C
C	Functions
C
	INTEGER INQ$CALL_INIT, INQ$CALL_TIMEOUT, INQ$CALL_READPROMPT
C
C	Local store
C
	CHARACTER RESP, TERM
	INTEGER NULL(2) /2*0/ !Fake-out null string descriptor
	INTEGER MS100(2) /-1000000,0/ !100 millisecss in delta time
	INTEGER ISTAT, TLEN, RLEN
C
C	Initialize the call interface
C
	ISTAT=INQ$CALL_INIT()
	IF (.NOT. ISTAT) CALL EXIT(ISTAT)
C
C	Set the timeout for zero seconds
C
	ISTAT=INQ$CALL_TIMEOUT(0)
	IF (.NOT. ISTAT) CALL EXIT(ISTAT)
C
C	Loop here until a terminator is hit on the terminal
C
	TLEN=0
	ISTAT=1
	DO WHILE ((TLEN .EQ. 0) .AND. ISTAT)
	  ISTAT=INQ$CALL_READPROMPT(INQ$M_FLAG_NOECHO,NULL,RESP,RLEN)
	  CALL INQ$CALL_GETTERM(TERM,TLEN)
	  CALL SYS$SETIMR(,MS100,,)
	  CALL SYS$WAITFR()
	ENDDO
	IF (.NOT. ISTAT) CALL EXIT(ISTAT)
C
C	Call routine now that user has hit terminator key
C
	CALL ACTION(TERM)
	END
