	program resprept
	implicit NONE
c
c		R. Goldstein		March, 1985
c		Program to read the response.log and
c		produce summary statistics. The ones
c		to be produced are:
c			Numbner of sessions
c			Average score
c			Score as a function of users
c			Score as a function of TOD
c			Users as a function of tod
c			peak number of users
c
	character*80 line
	character*80 filename
	character*35 def_file
	integer*4 nsess,h,u,hour_of_day,num_users,peak_users,i,n,len
	real*4 score,s,average_score,std_score
	logical eof
	data def_file/'sys$response:copyof_response.log'/
c
c		arrays to hold histogram data
	real*4 score_by_users(64),score_by_tod(0:23),
     1	       users_by_tod(0:23),std1(64)
	integer*4 entries_by_tod(0:23),entries_by_users(64)
c
c		Initializations
	do i=0,23
	   score_by_tod(i)=0
	   users_by_tod(i)=0
	   entries_by_tod(i)=0
	enddo
	do i=1,64
	   score_by_users(i)=0
	   entries_by_users(i)=0
	   std1(i)=0
	enddo
	nsess = 0
	average_score=0
	std_score = 0
	peak_users = 0	   
c
c
	write(6,311)def_file
311	format(' Enter name of response log file <',a,'>:',$)
c---
	read (5,312)len,filename
312	format(q,a)
	if (len .eq. 0) then
            filename=def_file
	endif
c
	if (index(filename,'.') .eq. 0)
     1		filename=filename(1:15)//'.log'
c
	open ( unit = 1, name=filename,
     1		access='SEQUENTIAL', status='OLD')
c
c
c
	DO WHILE ( .NOT. eof)
	   do i = 1,80
	      line(i:i) = ' '
	   enddo
	   read(1,101,end=900)line
101	   format(a)
c
	   h = hour_of_day(line)
	   u = num_users(line)
	   s = score(line)   !0-4
	   if (h.lt.0 .or. h.gt.23) goto 10
	   if (u.lt.0 .or. u.gt.64) goto 10
	   if (s.lt.0 .or. s.gt.4)  goto 10
c
	   nsess = nsess + 1
	   average_score = average_score + s
	   std_score = std_score + s*s
	   score_by_users(u) = score_by_users(u) + s
	   std1(u) = std1(u) + s*s
	   score_by_tod(h) = score_by_tod(h) + s
	   users_by_tod(h) = users_by_tod(h) + u
	   entries_by_tod(h) = entries_by_tod(h) + 1	
	   entries_by_users(u) = entries_by_users(u) + 1
	   if (u .gt. peak_users) peak_users = u
	   goto 10
c
900	   eof = .true.
10	enddo
c
c		calculate averages
	do i=0,23
	   n = entries_by_tod(i)
	   if (n.ne.0) then
	      score_by_tod(i) = score_by_tod(i)/n
	      users_by_tod(i) = users_by_tod(i)/n
	   endif
	enddo
	do i= 1,64
	   n = entries_by_users(i)
	   if (n.ne.0) THEN
	      score_by_users(i) = score_by_users(i)/n
	      std1(i) = sqrt( std1(i)/n - score_by_users(i)**2 )
	   endif
	enddo
c
	average_score = average_score/nsess
	std_score = sqrt( std_score/nsess - average_score**2)
c
c		Write out results
	write(6,102) nsess
102	format(' Number of sessions this month = ',i6)
	write(6,104) peak_users
104	format(' Peak number of users          = ',i6)
	write(6,105) average_score,std_score
105	format(' Average score                 = ',f6.2,' +-',
     1	         f6.2,'(STD)')
	write(6,106)
106	format(//'  Hour of day   Av_score       Av_users       Entries')
	do i=0,23
	   write(6,107)i,score_by_tod(i),users_by_tod(i),
     1				entries_by_tod(i)
107	   format(x,i8,5x,f6.2,10x,f6.2,6x,i10)
	enddo
	write(6,108)
108	format(//'  Num_users    Av_score   STD       Entries')
	do i=1,peak_users
	   write(6,109)i,score_by_users(i),std1(i),entries_by_users(i)
109	   format(x,i7,5x,f6.2,x,f6.2,7x,i10)
	enddo
c
	stop 
	end
c
	integer function hour_of_day(linex)
	character*80 linex
	integer t,u
c
	t = ichar(linex(14:14)) -ichar('0')
	u = ichar(linex(15:15)) - ichar('0')
	hour_of_day = 10*t + u
c	write(6,101) t,u,linex(14:14),linex(15:15)
101	format(' hour_of_day  t,u,l(14),l(15) : ',2i10,x,a4,x,a4)
	return
	end
c
	integer function num_users(line)
	character*80 line
	integer t,u
c
	t = ichar(line(28:28))
	if ( t .ne. ichar(' ')) then
	   t = t - ichar('0')
	else
	   t = 0
	endif
c
	u = ichar(line(29:29)) - ichar('0')
	num_users = 10*t + u
c	write(6,101)t,u,line(28:28),line(29:29)
101	format(' num_users  t,u,l(28),l(29) : ',2i10,x,a4,x,a4)
	return
	end
c
	real*4 function score(line)
	character*80 line
	integer s
	s = ichar(line(34:34))
	s = s - ichar('0')
	score = s
c	write(6,101) s,line(34:34)
101	format(' score... s,l(34): ',i10,x,a4)
	return
	end
