program scanpcb (output);

const
 
    prv$v_cmkrnl = 0;
    prv$v_cmexec = 1;
    prv$v_sysnam = 2;
    prv$v_grpnam = 3;
    prv$v_allspool = 4;
    prv$v_detach = 5;
    prv$v_diagnose = 6;
    prv$v_log_io = 7;
    prv$v_group = 8;
    prv$v_acnt = 9;
    prv$v_prmceb = 10;
    prv$v_prmmbx = 11;
    prv$v_pswapm = 12;
    prv$v_altpri = 13;
    prv$v_setpri = 13;
    prv$v_setprv = 14;
    prv$v_tmpmbx = 15;
    prv$v_world = 16;
    prv$v_mount = 17;
    prv$v_oper = 18;
    prv$v_exquota = 19;
    prv$v_netmbx = 20;
    prv$v_volpro = 21;
    prv$v_phy_io = 22;
    prv$v_bugchk = 23;
    prv$v_prmgbl = 24;
    prv$v_sysgbl = 25;
    prv$v_pfnmap = 26;
    prv$v_shmem = 27;
    prv$v_sysprv = 28;
    prv$v_bypass = 29;
    prv$v_syslck = 30;
    prv$v_share = 31;
    prv$v_upgrade = 32;
    prv$v_downgrade = 33;
    prv$v_grpprv = 34;
    prv$v_readall = 35;
    prv$v_security = 38;
 

type
 
    privmask = packed array [0..63] 
        of boolean;
    pack7 = packed array [1..7] of char;
    pack15 = packed array [1..15] of char;
    pack20 = packed array [1..20] of char;
    word = 0..65535;
    byte = 0..255;
    pcb_ptr = ^pcb;
    phd_ptr = ^phd;
    jib_ptr = ^jib;

    phd = packed record
    phd$q_privmsk : privmask;
    phd$w_wslist : word;
    phd$w_wsauth : word;
    phd$w_wslock : word;
    phd$w_wsdyn : word;
    phd$w_wsnext : word;
    phd$w_wslast : word;
    phd$w_wsauthext : word;
    phd$w_wsextent : word;
    phd$w_wsquota : word;
    phd$w_dfwscnt : word;
    phd$l_pagfil : integer;
    phd$l_pstbasoff : integer;
    phd$w_pstlast : word;
    phd$w_pstfree : word;
    phd$l_frep0va : integer;
    phd$l_freptecnt : integer;
    phd$l_frep1va : integer;
    phd$b_dfpfc : byte;
    phd$b_pgtbpfc : byte;
    phd$w_flags : word;
    phd$l_cputim : integer;
    phd$w_quant : word;
    phd$w_prclm : word;
    phd$w_astlm : word;
    phd$w_phvindex : word;
    phd$l_bak : integer;
    phd$l_pstbasmax : integer;
    phd$l_pageflts : integer;
    phd$w_wssize : word;
    phd$w_swapsize : word;
    phd$l_diocnt : integer;
    phd$l_biocnt : integer;
    phd$l_cpulim : integer;
    phd$b_cpumode : byte;
    phd$b_awsmode : byte;
    phd$w_fill_30 : word;
    phd$l_ptwslelck : integer;
    phd$l_ptwsleval : integer;
    phd$w_ptcntlck : word;
    phd$w_ptcntval : word;
    phd$w_ptcntact : word;
    phd$w_ptcntmax : word;
    phd$w_wsfluid : word;
    phd$w_extdynws : word;
    phd$l_ksp : integer;
    phd$l_esp : integer;
    phd$l_ssp : integer;
    phd$l_usp : integer;
    phd$l_r0 : integer;
    phd$l_r1 : integer;
    phd$l_r2 : integer;
    phd$l_r3 : integer;
    phd$l_r4 : integer;
    phd$l_r5 : integer;
    phd$l_r6 : integer;
    phd$l_r7 : integer;
    phd$l_r8 : integer;
    phd$l_r9 : integer;
    phd$l_r10 : integer;
    phd$l_r11 : integer;
    phd$l_r12 : integer;
    phd$l_r13 : integer;
    phd$l_pc : integer;
    phd$l_psl : integer;
    phd$l_p0br : integer;
    phd$l_p0lrastl : integer;
    phd$l_p1br : integer;
    phd$l_p1lr : integer;
    phd$w_emptpg : word;
    phd$w_respgcnt : word;
    phd$w_reqpgcnt : word;
    phd$w_cwslx : word;
    phd$q_authpriv : privmask;
    phd$q_imagpriv : privmask;
    phd$l_reslsth : integer;
    phd$l_imgcnt : integer;
    phd$l_pfltrate : integer;
    phd$l_pflref : integer;
    phd$l_timref : integer;
    phd$l_mpinhibit : integer;
    phd$l_pgfltio : integer;
    phd$b_authpri : byte;
    phd$b_fill1 : byte;
    phd$w_fill2 : word;
    phd$l_extracpu : integer;
    end;

    jib = packed record
    jib$l_mtlfl : integer;
    jib$l_mtlbl : integer;
    jib$w_size : word;
    jib$b_type : byte;
    jib$b_daytypes : byte;
    jib$t_username : pack20;
    jib$l_bytcnt : integer;
    jib$l_bytlm : integer;
    jib$l_pbytcnt : integer;
    jib$l_pbytlim : integer;
    jib$w_filcnt : word;
    jib$w_fillm : word;
    jib$w_tqcnt : word;
    jib$w_tqlm : word;
    jib$l_pgflquota : integer;
    jib$l_pgflcnt : integer;
    jib$l_cpulim : integer;
    jib$w_prccnt : word;
    jib$w_prclim : word;
    jib$w_shrfcnt : word;
    jib$w_shrflim : word;
    jib$w_enqcnt : word;
    jib$w_enqlm : word;
    jib$w_maxjobs : word;
    jib$w_maxdetach : word;
    jib$l_mpid : integer;
    jib$l_jlnamfl : integer;
    jib$l_jlnambl : integer;
    jib$l_pdayhours : integer;
    jib$l_odayhours : integer;
    jib$b_jobtype : byte;
    jib$b_fill1 : byte;
    jib$w_fill2 : word;
    jib$l_org_bytlm : integer;
    jib$l_org_pbytlm : integer;
    end;

    pcb = packed record
    pcb$l_sqfl : pcb_ptr;
    pcb$l_sqbl : pcb_ptr;
    pcb$w_size : word;
    pcb$b_type : byte;
    pcb$b_pri : byte;
    pcb$b_astact : byte;
    pcb$b_asten : byte;
    pcb$w_mtxcnt : word;
    pcb$l_astqfl : integer;
    pcb$l_astqbl : integer;
    pcb$l_phypcb : integer;
    pcb$l_owner : integer;
    pcb$l_wsswp : integer;
    pcb$l_sts : integer;
    pcb$b_prisav,pcb$b_pribsav,
        pcb$b_dpc,pcb$b_authpri : 
        byte;
    pcb$w_state : word;
    pcb$b_wefc : byte;
    pcb$b_prib : byte;
    pcb$w_aptcnt : word;
    pcb$w_tmbu : word;
    pcb$w_gpgcnt : word;
    pcb$w_ppgcnt : word;
    pcb$w_astcnt : word;
    pcb$w_biocnt : word;
    pcb$w_biolm : word;
    pcb$w_diocnt : word;
    pcb$w_diolm : word;
    pcb$w_prccnt : word;
    pcb$t_termlen : byte;
    pcb$t_terminal : pack7;
    pcb$l_efwm : integer;
    pcb$l_efcs : integer;
    pcb$l_efcu : integer;
    pcb$l_efc2p : integer;
    pcb$l_efc3p : integer;
    pcb$l_pid : integer;
    pcb$l_epid : integer;
    pcb$l_eowner : integer;
    pcb$l_phd : phd_ptr;
    pcb$b_lnamelen : byte;
    pcb$t_lname : pack15;
    pcb$l_jib : jib_ptr;
    pcb$q_priv : privmask;
    pcb$l_arb : integer;
    pcb$l_unknown1 : packed array [1..11] 
        of integer;
    pcb$w_mem,pcb$w_grp : word;
    pcb$l_unknown2 : packed array [1..15] 
        of integer;
    pcb$l_aclfl : integer;
    pcb$l_aclbl : integer;
    pcb$l_lockqfl : integer;
    pcb$l_lockqbl : integer;
    pcb$l_dlckpri : integer;
    pcb$l_ipast : integer;
    pcb$l_defprot : integer;
    pcb$l_waitime : integer;
    pcb$l_pmb : integer;
    end;
 
var
 

return_code : integer;
pcb_size : integer;
nonpaged_pcb_pointer,
    local_pcb_pointer : pcb_ptr;
jib_size : integer;
nonpaged_jib_pointer,
    local_jib_pointer : jib_ptr;
phd_size : integer;
nonpaged_phd_pointer,
    local_phd_pointer : phd_ptr;
privnames : 
    array [prv$v_cmkrnl..prv$v_security] 
    of varying [30] of char;



procedure sys$exit (%immed rc : integer); 
           extern;

function copy_nonpaged_buff 
           (%immed fl,tl : integer;
           %immed f,t : integer) 
           : integer; extern;

function copy_system_control_block 
           (%immed f,t : integer) : 
           integer; extern;

function get_my_pcb (var p : pcb_ptr) 
           : integer; extern;

procedure print_privs (privmask : privmask);

var
 
 n : integer;
 
begin
for n := 0 to prv$v_security do
    if privmask[n] then 
        writeln(privnames[n]);
end;

procedure print_pcb;

begin
with local_pcb_pointer^ do begin
    writeln('pcb$l_sqfl = ',
        hex(pcb$l_sqfl));
    writeln('pcb$l_sqbl = ',
        hex(pcb$l_sqbl));
    writeln('pcb$w_size = ',pcb$w_size);
    writeln('pcb$b_type = ',pcb$b_type);
    writeln('pcb$b_pri = ',pcb$b_pri);
    writeln('pcb$b_astact = ',pcb$b_astact);
    writeln('pcb$b_asten = ',pcb$b_asten);
    writeln('pcb$w_mtxcnt = ',pcb$w_mtxcnt);
    writeln('pcb$l_astqfl = ',
        hex(pcb$l_astqfl));
    writeln('pcb$l_astqbl = ',
        hex(pcb$l_astqbl));
    writeln('pcb$l_phypcb = ',
        hex(pcb$l_phypcb));
    writeln('pcb$l_owner = ',pcb$l_owner);
    writeln('pcb$l_wsswp = ',
        hex(pcb$l_wsswp));
    writeln('pcb$l_sts = ',hex(pcb$l_sts));
    writeln('pcb$b_prisav = ',pcb$b_prisav);
    writeln('pcb$b_pribsav = ',
        pcb$b_pribsav);
    writeln('pcb$b_dpc = ',pcb$b_dpc);
    writeln('pcb$b_authpri = ',
        pcb$b_authpri);
    writeln('pcb$w_state = ',pcb$w_state);
    writeln('pcb$b_wefc = ',
        hex(pcb$b_wefc));
    writeln('pcb$b_prib = ',pcb$b_prib);
    writeln('pcb$w_aptcnt = ',pcb$w_aptcnt);
    writeln('pcb$w_tmbu = ',pcb$w_tmbu);
    writeln('pcb$w_gpgcnt = ',pcb$w_gpgcnt);
    writeln('pcb$w_ppgcnt = ',pcb$w_ppgcnt);
    writeln('pcb$w_astcnt = ',pcb$w_astcnt);
    writeln('pcb$w_biocnt = ',pcb$w_biocnt);
    writeln('pcb$w_biolm = ',pcb$w_biolm);
    writeln('pcb$w_diocnt = ',pcb$w_diocnt);
    writeln('pcb$w_diolm = ',pcb$w_diolm);
    writeln('pcb$w_prccnt = ',pcb$w_prccnt);
    writeln('pcb$t_terminal (length) = ',
        pcb$t_termlen);
    writeln('pcb$t_terminal = ',
        pcb$t_terminal);
    writeln('pcb$l_efwm = ',
        hex(pcb$l_efwm));
    writeln('pcb$l_efcs = ',
        hex(pcb$l_efcs));
    writeln('pcb$l_efcu = ',
        hex(pcb$l_efcu));
    writeln('pcb$l_efc2p = ',
        hex(pcb$l_efc2p));
    writeln('pcb$l_efc3p = ',
        hex(pcb$l_efc3p));
    writeln('pcb$l_pid = ',hex(pcb$l_pid));
    writeln('pcb$l_epid = ',
        hex(pcb$l_epid));
    writeln('pcb$l_phd = ',hex(pcb$l_phd));
    writeln('pcb$l_eowner = ',
        hex(pcb$l_eowner));
    writeln('pcb$t_lname = ',pcb$t_lname);
    writeln('pcb$l_jib = ',hex(pcb$l_jib));
    writeln('pcb$q_priv = ');
    print_privs (pcb$q_priv);
    writeln('pcb$l_arb = ',hex(pcb$l_arb));
    writeln('pcb$w_mem = ',oct(pcb$w_mem));
    writeln('pcb$w_grp = ',oct(pcb$w_grp));
    writeln('pcb$l_aclfl = ',
        hex(pcb$l_aclfl));
    writeln('pcb$l_aclbl = ',
        hex(pcb$l_aclbl));
    writeln('pcb$l_lockqfl = ',
        hex(pcb$l_lockqfl));
    writeln('pcb$l_lockqbl = ',
        hex(pcb$l_lockqbl));
    writeln('pcb$l_dlckpri = ',
        pcb$l_dlckpri);
    writeln('pcb$l_ipast = ',pcb$l_ipast);
    writeln('pcb$l_defprot = ',
        hex(pcb$l_defprot));
    writeln('pcb$l_waitime = ',
        hex(pcb$l_waitime));
    writeln('pcb$l_pmb = ',hex(pcb$l_pmb));
    writeln;
    writeln;
    end;
 
end;



procedure print_jib;

begin
with local_jib_pointer^ do begin
    writeln('jib$l_mtlfl = ',
        hex(jib$l_mtlfl));
    writeln('jib$l_mtlbl = ',
        hex(jib$l_mtlbl));
    writeln('jib$w_size = ',jib$w_size);
    writeln('jib$b_type = ',jib$b_type);
    writeln('jib$b_daytypes = ',
        hex(jib$b_daytypes));
    writeln('jib$T_username = ',
        jib$t_username);
    writeln('jib$l_bytcnt = ',jib$l_bytcnt);
    writeln('jib$l_bytlm = ',jib$l_bytlm);
    writeln('jib$l_pbytcnt = ',
        jib$l_pbytcnt);
    writeln('jib$l_pbytlim = ',
        jib$l_pbytlim);
    writeln('jib$w_filcnt = ',jib$w_filcnt);
    writeln('jib$w_fillm = ',jib$w_fillm);
    writeln('jib$w_tqcnt = ',jib$w_tqcnt);
    writeln('jib$w_tqlm = ',jib$w_tqlm);
    writeln('jib$l_pgflquota = ',
        jib$l_pgflquota);
    writeln('jib$l_pgflcnt = ',
        jib$l_pgflcnt);
    writeln('jib$l_cpulim = ',jib$l_cpulim);
    writeln('jib$w_prccnt = ',jib$w_prccnt);
    writeln('jib$w_prclim = ',jib$w_prclim);
    writeln('jib$w_shrfcnt = ',
        jib$w_shrfcnt);
    writeln('jib$w_shrflim = ',
        jib$w_shrflim);
    writeln('jib$w_enqcnt = ',jib$w_enqcnt);
    writeln('jib$w_enqlm = ',jib$w_enqlm);
    writeln('jib$w_maxjobs = ',
        jib$w_maxjobs);
    writeln('jib$w_maxdetach = ',
        jib$w_maxdetach);
    writeln('jib$l_mpid = ',
        hex(jib$l_mpid));
    writeln('jib$l_jlnamfl = ',
        hex(jib$l_jlnamfl));
    writeln('jib$l_jlnambl = ',
        hex(jib$l_jlnambl));
    writeln('jib$l_pdayhours = ',
        hex(jib$l_pdayhours));
    writeln('jib$l_odayhours = ',
        hex(jib$l_odayhours));
    writeln('jib$b_jobtype = ',
        hex(jib$b_jobtype));
    writeln('jib$l_org_bytlm = ',
        jib$l_org_bytlm);
    writeln('jib$l_org_pbytlm = ',
        jib$l_org_pbytlm);
    writeln;
    writeln;
    end;
 
end;

procedure print_phd;
begin
with local_phd_pointer^ do begin
    writeln('phd$q_privmsk = ');
    print_privs (phd$q_privmsk);
    writeln('phd$w_wslist = ',phd$w_wslist);
    writeln('phd$w_wsauth = ',phd$w_wsauth);
    writeln('phd$w_wslock = ',phd$w_wslock);
    writeln('phd$w_wsdyn = ',phd$w_wsdyn);
    writeln('phd$w_wsnext = ',phd$w_wsnext);
    writeln('phd$w_wslast = ',phd$w_wslast);
    writeln('phd$w_wsauthext = ',
        phd$w_wsauthext);
    writeln('phd$w_wsextent = ',
        phd$w_wsextent);
    writeln('phd$w_wsquota = ',
        phd$w_wsquota);
    writeln('phd$w_dfwscnt = ',
        phd$w_dfwscnt);
    writeln('phd$l_pagfil = ',
        hex(phd$l_pagfil));
    writeln('phd$l_pstbasoff = ',
        hex(phd$l_pstbasoff));
    writeln('phd$w_pstlast = ',
        hex(phd$w_pstlast));
    writeln('phd$w_pstfree = ',
        hex(phd$w_pstfree));
    writeln('phd$l_frep0va = ',
        hex(phd$l_frep0va));
    writeln('phd$l_freptecnt = ',
        hex(phd$l_freptecnt));
    writeln('phd$l_frep1va = ',
        hex(phd$l_frep1va));
    writeln('phd$b_dfpfc = ',
        hex(phd$b_dfpfc));
    writeln('phd$b_pgtbpfc = ',
        hex(phd$b_pgtbpfc));
    writeln('phd$w_flags = ',
        hex(phd$w_flags));
    writeln('phd$l_cputim = ',phd$l_cputim);
    writeln('phd$w_quant = ',
        hex(phd$w_quant));
    writeln('phd$w_prclm = ',phd$w_prclm);
    writeln('phd$w_astlm = ',phd$w_astlm);
    writeln('phd$w_phvindex = ',
        phd$w_phvindex);
    writeln('phd$l_bak = ',hex(phd$l_bak));
    writeln('phd$l_pstbasmax = ',
        hex(phd$l_pstbasmax));
    writeln('phd$l_pageflts = ',
        phd$l_pageflts);
    writeln('phd$w_wssize = ',phd$w_wssize);
    writeln('phd$w_swapsize = ',
        phd$w_swapsize);
    writeln('phd$l_diocnt = ',phd$l_diocnt);
    writeln('phd$l_biocnt = ',phd$l_biocnt);
    writeln('phd$l_cpulim = ',phd$l_cpulim);
    writeln('phd$b_cpumode = ',
        phd$b_cpumode);
    writeln('phd$b_awsmode = ',
        hex(phd$b_awsmode));
    writeln('phd$w_fill_30 = ',
        hex(phd$w_fill_30));
    writeln('phd$l_ptwslelck = ',
        phd$l_ptwslelck);
    writeln('phd$l_ptwsleval = ',
        phd$l_ptwsleval);
    writeln('phd$w_ptcntlck = ',
        phd$w_ptcntlck);
    writeln('phd$w_ptcntval = ',
        phd$w_ptcntval);
    writeln('phd$w_ptcntact = ',
        phd$w_ptcntact);
    writeln('phd$w_ptcntmax = ',
        phd$w_ptcntmax);
    writeln('phd$w_wsfluid = ',
        phd$w_wsfluid);
    writeln('phd$w_extdynws = ',
        hex(phd$w_extdynws));
    writeln('phd$l_ksp = ',hex(phd$l_ksp));
    writeln('phd$l_esp = ',hex(phd$l_esp));
    writeln('phd$l_ssp = ',hex(phd$l_ssp));
    writeln('phd$l_usp = ',hex(phd$l_usp));
    writeln('phd$l_r0 = ',hex(phd$l_r0));
    writeln('phd$l_r1 = ',hex(phd$l_r1));
    writeln('phd$l_r2 = ',hex(phd$l_r2));
    writeln('phd$l_r3 = ',hex(phd$l_r3));
    writeln('phd$l_r4 = ',hex(phd$l_r4));
    writeln('phd$l_r5 = ',hex(phd$l_r5));
    writeln('phd$l_r6 = ',hex(phd$l_r6));
    writeln('phd$l_r7 = ',hex(phd$l_r7));
    writeln('phd$l_r8 = ',hex(phd$l_r8));
    writeln('phd$l_r9 = ',hex(phd$l_r9));
    writeln('phd$l_r10 = ',hex(phd$l_r10));
    writeln('phd$l_r11 = ',hex(phd$l_r11));
    writeln('phd$l_r12 = ',hex(phd$l_r12));
    writeln('phd$l_r13 = ',hex(phd$l_r13));
    writeln('phd$l_pc = ',hex(phd$l_pc));
    writeln('phd$l_psl = ',hex(phd$l_psl));
    writeln('phd$l_p0br = ',
        hex(phd$l_p0br));
    writeln('phd$l_p0lrastl = ',
        hex(phd$l_p0lrastl));
    writeln('phd$l_p1br = ',
        hex(phd$l_p1br));
    writeln('phd$l_p1lr = ',
        hex(phd$l_p1lr));
    writeln('phd$w_emptpg = ',
        hex(phd$w_emptpg));
    writeln('phd$w_respgcnt = ',
        phd$w_respgcnt);
    writeln('phd$w_reqpgcnt = ',
        phd$w_reqpgcnt);
    writeln('phd$w_cwslx = ',
        hex(phd$w_cwslx));
    writeln('phd$q_authpriv = ');
    print_privs (phd$q_authpriv);
    writeln('phd$q_imagpriv = ');
    print_privs (phd$q_imagpriv);
    writeln('phd$l_reslsth = ',
        phd$l_reslsth);
    writeln('phd$l_imgcnt = ',phd$l_imgcnt);
    writeln('phd$l_pfltrate = ',
        phd$l_pfltrate);
    writeln('phd$l_pflref = ',phd$l_pflref);
    writeln('phd$l_timref = ',phd$l_timref);
    writeln('phd$l_mpinhibit = ',
        hex(phd$l_mpinhibit));
    writeln('phd$l_pgfltio = ',
        phd$l_pgfltio);
    writeln('phd$b_authpri = ',
        phd$b_authpri);
    writeln('phd$l_extracpu = ',
        phd$l_extracpu);
    writeln;
    writeln;
    end;
 
end;



procedure init_priv_names;

var
 
 n : integer;
 
begin
privnames[prv$v_cmkrnl] := 'cmkrnl';
privnames[prv$v_cmexec] := 'cmexec';
privnames[prv$v_sysnam] := 'sysnam';
privnames[prv$v_grpnam] := 'grpnam';
privnames[prv$v_allspool] := 'allspool';
privnames[prv$v_detach] := 'detach';
privnames[prv$v_diagnose] := 'diagnose';
privnames[prv$v_log_io] := 'log_io';
privnames[prv$v_group] := 'group';
privnames[prv$v_acnt] := 'acnt';
privnames[prv$v_prmceb] := 'prmceb';
privnames[prv$v_prmmbx] := 'prmmbx';
privnames[prv$v_pswapm] := 'pswapm';
privnames[prv$v_altpri] := 'altpri';
privnames[prv$v_setpri] := 'setpri';
privnames[prv$v_setprv] := 'setprv';
privnames[prv$v_tmpmbx] := 'tmpmbx';
privnames[prv$v_world] := 'world';
privnames[prv$v_mount] := 'mount';
privnames[prv$v_oper] := 'oper';
privnames[prv$v_exquota] := 'exquota';
privnames[prv$v_netmbx] := 'netmbx';
privnames[prv$v_volpro] := 'volpro';
privnames[prv$v_phy_io] := 'phy_io';
privnames[prv$v_bugchk] := 'bugchk';
privnames[prv$v_prmgbl] := 'prmgbl';
privnames[prv$v_sysgbl] := 'sysgbl';
privnames[prv$v_pfnmap] := 'pfnmap';
privnames[prv$v_shmem] := 'shmem';
privnames[prv$v_sysprv] := 'sysprv';
privnames[prv$v_bypass] := 'bypass';
privnames[prv$v_syslck] := 'syslck';
privnames[prv$v_share] := 'share';
privnames[prv$v_upgrade] := 'upgrade';
privnames[prv$v_downgrade] := 'downgrade';
privnames[prv$v_grpprv] := 'grpprv';
privnames[prv$v_readall] := 'readall';
privnames[prv$v_security] := 'security';
 
end;



begin
init_priv_names;
return_code := get_my_pcb 
     (nonpaged_pcb_pointer);
if not odd (return_code) then 
    sys$exit (return_code);

new (local_pcb_pointer);
pcb_size := size (pcb);
local_pcb_pointer^.pcb$w_size := pcb_size;
writeln('local_pcb size = ',pcb_size);
writeln;
return_code := copy_system_control_block 
          (nonpaged_pcb_pointer :: integer,
          local_pcb_pointer :: integer);
if not odd (return_code) then 
    sys$exit (return_code);

pcb_size := local_pcb_pointer^.pcb$w_size;
writeln('pcb size = ',pcb_size);
writeln('pcb at ',
        hex(nonpaged_pcb_pointer));
writeln;
print_pcb;
writeln;
nonpaged_jib_pointer := 
      local_pcb_pointer^.pcb$l_jib;
new (local_jib_pointer);
jib_size := size (jib);
local_jib_pointer^.jib$w_size := jib_size;
writeln('local_jib size = ',jib_size);
writeln;
return_code := copy_system_control_block 
     (nonpaged_jib_pointer :: integer,
     local_jib_pointer :: integer);
if not odd (return_code) then 
    sys$exit (return_code);

jib_size := local_jib_pointer^.jib$w_size;
writeln('jib size = ',jib_size);
writeln('jib at ',
        hex(nonpaged_jib_pointer));
writeln;
print_jib;
writeln;


nonpaged_phd_pointer := 
        local_pcb_pointer^.pcb$l_phd;
new (local_phd_pointer);
phd_size := size (phd);
writeln('local_phd size = ',phd_size);
writeln;
return_code := copy_nonpaged_buff 
    (phd_size,phd_size,
    nonpaged_phd_pointer :: integer,
    local_phd_pointer :: integer);
if not odd (return_code) then 
    sys$exit (return_code);

writeln('phd at ',
        hex(nonpaged_phd_pointer));
writeln;
print_phd;
writeln;
 
end .
