$! DUPLICATE.COM
$! Identify all files in a directory structure that have the same name.
$! For interactive or batch use.
$! Input:  no user input
$! Output: DIRECTORY.LIST giving the names of duplicate files, and
$!         their location, version, size and creation date. 
$!
$ ON CONTROL_Y THEN GOTO the_end
$!
$! define directory tree up front for easy modification
$!
$ $directory_tree = "[...]"
$!
$!
$! define control variables with nonsense to keep first strings read
$! from matching anything.
$!
$ $last_file      ="adadkadfaeifampoeiajaeoeaasdfrbxcvb"
$ $dir_done       ="lhlinlkjsdfasiuhqwejhddaskadfpiperw"
$!
$!
$! build a directory listing for the tree, limit versions to 2 because
$! that is enough to determine if there is a duplicate
$!
$ WRITE sys$output "''F$TIME()' Building directory listing..."
$ DIR/SIZE/VERSIONS=2/OUTPUT=dup_dir.tmp '$directory_tree'
$!
$!
$! sort the directory listing to make it easy to search
$!
$ WRITE sys$output "''F$TIME()' Sorting directory listing..."
$ SORT dup_dir.tmp dup_sort.tmp
$!
$!
$! open the file
$!
$ OPEN/WRITE output_file duplicate.list
$ WRITE output_file "''F$TIME()' Duplicates of these file names exist:"
$ WRITE sys$output "''F$TIME()' Duplicates of these file names exist:"
$ OPEN/READ input_file dup_sort.tmp
$!
$!
$! Rapidly skip through empty lines so we don't have to check for them in
$! main loop.
$!
$ start_empty_loop:
$! get the next file name
$ 	READ/END_OF_FILE=the_end input_file $read_file
$	IF $read_file .EQS. "" THEN GOTO start_empty_loop
$ end_empty_loop:
$!
$!
$! Rapidly skip through blank lines so we don't have to check for them in
$! main loop.
$!
$ start_blank_loop:
$! get the next file name
$ 	READ/END_OF_FILE=the_end input_file $read_file
$	$file_field = "''F$EXTRACT(0,9,$read_file)'"
$	IF $file_field .EQS. "         " THEN GOTO start_blank_loop
$ end_blank_loop: 
$!
$!
$! Now loop through the rest of the file looking for duplicates
$!
$ $count = 0
$ start_loop:
$ 	READ/END_OF_FILE=the_end input_file $read_file
$!
$! get rid of the version numbers
$!
$	$file_field = "''F$EXTRACT(0,50,$read_file)'"
$	$file_name = "''F$PARSE($file_field,,,"NAME")'"
$	$file_type = "''F$PARSE($file_field,,,"TYPE")'"	
$	$next_file = $file_name + $file_type
$!
$! if current file name matches last file name, output to duplicates file
$! (unless we already output an entry for this file name).
$!
$	IF $next_file .NES. $last_file THEN GOTO endif
$!
$! abort on DCL trash
$!
$		$file_field = "''F$EXTRACT(0,9,$read_file)'"
$		IF $file_field .EQS. "Total of " THEN GOTO start_loop
$		IF $file_field .EQS. "Directory" THEN GOTO start_loop
$!
$! write to output
$!
$		IF $next_file .EQS. $dir_done THEN GOTO endif
$			$count = $count + 1
$			$dir_done = $next_file
$			WRITE SYS$OUTPUT $next_file
$			WRITE output_file "********"
$			WRITE output_file "********"
$			WRITE output_file "********  ",$next_file
$			WRITE output_file "********"
$			DIRECTORY/DATE/SIZE/NOHEADER/NOTRAILER/OUTPUT=output_file  [...]'$next_file'
$	endif:
$	$last_file = $next_file
$	GOTO start_loop
$ the_end:
$ WRITE sys$output "''F$TIME()' ''$count' duplicate file names found."
$ CLOSE input_file
$ CLOSE output_file
$ WRITE sys$output "''F$TIME()' Deleting temporary files..."
$ DELETE dup_dir.tmp;*
$ DELETE dup_sort.tmp;*
$ DELETE/SYMBOL $directory_tree
$ DELETE/SYMBOL $last_file
$ DELETE/SYMBOL $dir_done
$ DELETE/SYMBOL $read_file
$ DELETE/SYMBOL $file_field
$ DELETE/SYMBOL $file_name
$ DELETE/SYMBOL $file_type
$ DELETE/SYMBOL $count
$ DELETE/SYMBOL $next_file
$ DEASSIGN input_file
$ DEASSIGN output_file
$ EXIT
