$! FORBIN.COM -- set up screen for daily use by setting to VT100, setting
$!               up regular ascii character set, clearing the screen,
$!               turning off all attributes and setting full scroll;
$!               horizontal scroll a message across the top of the screen
$!               in the process for visual indication that it is working and
$!               because it's lots of fun to do.
$!
$! VT100 Control sequences used:
$!
$!    ESC [ Pn J        -- clear screen, Pn = 0 clears cursor to end of screen
$!                                       Pn = 2 clears full screen
$!
$!    ESC [ Pn1 ; Pn2 H -- position cursor, Pn1 = row, Pn2 = column
$!
$!    ESC [ 0 K         -- clear to end of line
$!
$!    ESC [ Pn1 ; Pn2 r -- set scrolling region, Pn1 = top line
$!                                               Pn2 = bottom line
$!    ESC # 6           -- set double width
$!
$!    ESC [ 0 m         -- turn off all attributes (boldface, underscore,
$!                         blink and reverse video)
$!
$!    ESC ( B           -- set up ascii character set (not graphics or UK)
$!
$! symbol definitions
$!
$! screen commands--
$!
$ clear_screen == "[2J"
$ full_scroll  == "[1;24r"
$ ascii_set    == "(B"
$!
$! cursor moves--
$!
$ start_position    == "[1;1H"
$ end_position      == "[24;1H"
$!
$!
$! set attributes--
$!
$ boldface_on       == "[1m"
$ attributes_off    == "[0m"
$ set_double_width  == "#6"
$!
$!define an amusing message
$!
$ astring = "                                        Greetings Professor Falken, would you like to play a game? "
$!
$!set the loop limit (Set it just large enough so message clears the screen;
$!easy determine that value is to set loop_max to 200 or so, SET VERIFY, and 
$!run the command procedure.  Watch the variable "count" increment in the
$!F$EXTRACT line and note the value of "count" when the message clears
$!the screen.  The value of count when the message clears the screen is what
$!you want to set "loop_max" to.)  
$!
$ loop_max = 100
$!
$!executable
$!
$!initialize
$!
$ SET TERM/VT100
$ WRITE SYS$OUTPUT ''clear_screen'
$ WRITE SYS$OUTPUT ''ascii_set'
$ ON CONTROL_Y THEN GOTO end_loop
$ SET TERM/WIDTH=80
$ WRITE SYS$OUTPUT ''start_position',''set_double_width'
$!
$!
$! loop through the message
$!
$ count = 1
$ start_loop:
$     bstring = F$EXTRACT('count',40,astring)  
$     count = count + 1
$     WRITE SYS$OUTPUT ''start_position',bstring
$     IF count .LT. loop_max THEN GOTO start_loop
$ end_loop:
$!
$ WRITE SYS$OUTPUT ''end_position',''full_scroll',''attributes_off'
$ EXIT
