	SUBROUTINE input_longword (line_position,long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c local data for .MAIN.
c
	LOGICAL   vt100_status,radix_status
	INTEGER*4 long_data,high_byte,low_byte,iascii
	BYTE      line_position
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
	radix_status = .TRUE.
	CALL vt100_move_cursor(2,6,vt100_status)
	CALL vt100_write('Enter Number:                                  '
     &     ,47,vt100_status)
	CALL vt100_move_cursor(17,6,vt100_status)
	IF(line_position.EQ.3)THEN
		CALL input_DEC(long_data,radix_status)
	ELSE IF(line_position.EQ.2)THEN
		CALL input_OCT(long_data,radix_status)
	ELSE IF(line_position.EQ.4)THEN
		CALL input_HEX(long_data,radix_status)
	ELSE IF(line_position.EQ.5)THEN
		CALL input_ASCII(long_data,radix_status)
	ELSE IF(line_position.EQ.1)THEN
		CALL input_binary(long_data,radix_status)
	ELSE IF(line_position.EQ.6)THEN
		CALL vt100_clear_screen(vt100_status)
		STOP
	ENDIF
	RETURN
c
c
c error handling address
c
100	CONTINUE
	radix_status = .FALSE.
	RETURN
c
c
c formats
c
20	FORMAT(I12)
30	FORMAT(O12)
40	FORMAT(Z12)
45	FORMAT(A4)
	END
c
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
	SUBROUTINE input_binary(long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c reads a character string representation of a binary number
c and constructs an integer value corresponding to the binary number
c Input: from user
c Output an integer 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
	LOGICAL     radix_status,vt100_status
	INTEGER*4   long_data,do_index,number_of_characters
	BYTE        raw_input
	BYTE        BIN_input(32)
	BYTE        justified_BIN_input(32)
	CHARACTER   temp_char
	CHARACTER*32 BIN_string
c
c
c run time library definitions
c
	INTEGER*4   OTS$CVT_TB_L,LIB$CHAR,return
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c clear array to zeros to get rid of last entry.
c
	BIN_string = '           '	
	DO do_index = 1,32
		BIN_input(do_index) = ' '
		justified_BIN_input(do_index) = ' '
	ENDDO
c
c
c read the input string.
c
	DO do_index = 1,32
		CALL vt100_read_keystroke(raw_input,radix_status)
		IF (raw_input .EQ. "15) THEN
			GOTO 50
		ELSE IF (raw_input.EQ."10) THEN
			CALL delete_key(do_index,radix_status)
		ELSE IF ((raw_input.GE. "60).AND.(raw_input.LE. "61)) THEN
				BIN_input(do_index) = raw_input
		ELSE
			radix_status = .FALSE.
			GOTO 100
		ENDIF
	ENDDO
50	CONTINUE				!early loop exit target label
c
c
c right justify the input for the number of characters input
c
	number_of_characters = do_index - 1
	DO do_index = 1, number_of_characters
		justified_BIN_input(do_index + 32 - number_of_characters) = 
     &			BIN_input(do_index)
	ENDDO
c
c
c convert array of input values to a character string
c
	DO do_index = 1,32
		return = LIB$CHAR( temp_char,justified_BIN_input(do_index) )
		BIN_string(do_index:do_index) = temp_char(1:1)
	ENDDO
c
c
c and convert the string to a longword
c
	return = OTS$CVT_TB_L(BIN_string,long_data)
	IF (.NOT. return) THEN
		radix_status = .FALSE.
	ENDIF
c
c
c and return
c
	RETURN
c
c
c early exit for <CR> and <^Z>, no difference in processing
c
100	CONTINUE 		!exception handling exit
	END
c
c
c
	SUBROUTINE input_ASCII(long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c reads characters from the keyboard to avoid FORTRAN's bad habit of
c padding ASCII input with blanks. 
c Input: from user
c Output an integer 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	LOGICAL   radix_status,vt100_status
	INTEGER*4 long_data,local_data,do_index
	BYTE      raw_input
	BYTE      ASCII_input(4)
	EQUIVALENCE (local_data,ASCII_input)
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c clear array to zeros to get rid of last entry.
c
	DO do_index = 1,4
		ASCII_input(do_index) = 0
	ENDDO
c
c
c read the input string.
c
	DO do_index = 1,4
		CALL vt100_read_keystroke(raw_input,radix_status)
		IF (raw_input .EQ. "15) THEN
			GOTO 100
		ELSE IF (raw_input .EQ. "32) THEN
			radix_status = .FALSE.
			GOTO 100
		ELSE
			ASCII_input(do_index) = raw_input
		ENDIF
	ENDDO
	long_data = local_data
	RETURN
c
c
c early exit for <CR> and <^Z>, no difference in processing
c
100	CONTINUE 		!exception handling exit
	long_data = local_data
	END

c
c
c
c
	SUBROUTINE input_HEX(long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c get a hex value from the keyboard 
c
c Input: from user
c Output an integer 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	LOGICAL     radix_status,vt100_status
	INTEGER*4   long_data,do_index,number_of_characters
	BYTE        raw_input
	BYTE        HEX_input(8)
	BYTE        justified_HEX_input(8)
	CHARACTER   temp_char
	CHARACTER*8 HEX_string
c
c
c run time library definitions
c
	INTEGER*4   OTS$CVT_TZ_L,LIB$CHAR,return
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c clear array to zeros to get rid of last entry.
c
	HEX_string = '        '	
	DO do_index = 1,8
		HEX_input(do_index) = ' '
		justified_HEX_input(do_index) = ' '
	ENDDO
c
c
c read the input string.
c
	DO do_index = 1,8
		CALL vt100_read_keystroke(raw_input,radix_status)
		IF (raw_input .EQ. "15) THEN
			GOTO 50
		ELSE IF (raw_input.EQ."10) THEN
			CALL delete_key(do_index,radix_status)
		ELSE IF ( ((raw_input.GE. "60).AND.(raw_input.LE. "72)).OR.
     &		          ((raw_input.GE."101).AND.(raw_input.LE."106)).OR.
     &		          ((raw_input.GE."141).AND.(raw_input.LE."146)) ) THEN

				hex_input(do_index) = raw_input
		ELSE
			radix_status = .FALSE.
			GOTO 100
		ENDIF
	ENDDO
50	CONTINUE				!early loop exit target label
c
c
c right justify the input for the number of characters input
c
	number_of_characters = do_index - 1
	DO do_index = 1, number_of_characters
		justified_HEX_input(do_index + 8 - number_of_characters) = 
     &			HEX_input(do_index)
	ENDDO
c
c
c convert array of input values to a character string
c
	DO do_index = 1,8
		return = LIB$CHAR( temp_char,justified_HEX_input(do_index) )
		HEX_string(do_index:do_index) = temp_char(1:1)
	ENDDO
c
c
c and convert the string to a longword
c
	return = OTS$CVT_TZ_L(hex_string,long_data)
	IF (.NOT. return) THEN
		radix_status = .FALSE.
	ENDIF
c
c
c and return
c
	RETURN
c
c
c early exit for <CR> and <^Z>, no difference in processing
c
100	CONTINUE 		!exception handling exit
	END

c
c
c
c
	SUBROUTINE input_OCT(long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c get a OCT value from the keyboard 
c
c Input: from user
c Output an integer 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	LOGICAL     radix_status,vt100_status
	INTEGER*4   long_data,do_index,number_of_characters
	BYTE        raw_input
	BYTE        OCT_input(11)
	BYTE        justified_OCT_input(11)
	CHARACTER   temp_char
	CHARACTER*11 OCT_string
c
c
c run time library definitions
c
	INTEGER*4   OTS$CVT_TO_L,LIB$CHAR,return
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c clear array to zeros to get rid of last entry.
c
	OCT_string = '           '	
	DO do_index = 1,11
		OCT_input(do_index) = ' '
		justified_OCT_input(do_index) = ' '
	ENDDO
c
c
c read the input string.
c
	DO do_index = 1,11
		CALL vt100_read_keystroke(raw_input,radix_status)
		IF (raw_input .EQ. "15) THEN
			GOTO 50
		ELSE IF (raw_input.EQ."10) THEN
			CALL delete_key(do_index,radix_status)
		ELSE IF ((raw_input.GE. "60).AND.(raw_input.LE. "67)) THEN
				OCT_input(do_index) = raw_input
		ELSE
			radix_status = .FALSE.
			GOTO 100
		ENDIF
	ENDDO
50	CONTINUE				!early loop exit target label
c
c
c right justify the input for the number of characters input
c
	number_of_characters = do_index - 1
	DO do_index = 1, number_of_characters
		justified_OCT_input(do_index + 11 - number_of_characters) = 
     &			OCT_input(do_index)
	ENDDO
c
c
c convert array of input values to a character string
c
	DO do_index = 1,11
		return = LIB$CHAR( temp_char,justified_OCT_input(do_index) )
		OCT_string(do_index:do_index) = temp_char(1:1)
	ENDDO
c
c
c and convert the string to a longword
c
	return = OTS$CVT_TO_L(OCT_string,long_data)
	IF (.NOT. return) THEN
		radix_status = .FALSE.
	ENDIF
c
c
c and return
c
	RETURN
c
c
c early exit for <CR> and <^Z>, no difference in processing
c
100	CONTINUE 		!exception handling exit
	END

c
c
c
c
	SUBROUTINE input_DEC(long_data,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c get a DEC value from the keyboard 
c
c Input: from user
c Output an integer 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	LOGICAL     radix_status,vt100_status
	INTEGER*4   long_data,do_index,number_of_characters
	BYTE        raw_input
	BYTE        DEC_input(11)
	BYTE        justified_DEC_input(11)
	CHARACTER   temp_char
	CHARACTER*11 DEC_string
c
c
c run time library definitions
c
	INTEGER*4   OTS$CVT_TI_L,LIB$CHAR,return
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
c
c clear array to zeros to get rid of last entry.
c
	DEC_string = '           '	
	DO do_index = 1,11
		DEC_input(do_index) = ' '
		justified_DEC_input(do_index) = ' '
	ENDDO
c
c
c read the input string.
c
	DO do_index = 1,11
		CALL vt100_read_noecho(raw_input,radix_status)
		IF (raw_input .EQ. "15) THEN
			GOTO 50
		ELSE IF (raw_input.EQ."10) THEN
			CALL delete_key(do_index,radix_status)
		ELSE IF ( ((raw_input.GE. "60).AND.(raw_input.LE. "71)) .OR.
     &                    (raw_input .EQ. '-') )THEN
			DEC_input(do_index) = raw_input
			CALL vt100_write(raw_input,1,vt100_status)
		ELSE
			radix_status = .FALSE.
			GOTO 100
		ENDIF
	ENDDO
50	CONTINUE				!early loop exit target label
c
c
c right justify the input for the number of characters input
c
	number_of_characters = do_index - 1
	DO do_index = 1, number_of_characters
		justified_DEC_input(do_index + 11 - number_of_characters) = 
     &			DEC_input(do_index)
	ENDDO
c
c
c convert array of input values to a character string
c
	DO do_index = 1,11
		return = LIB$CHAR( temp_char,justified_DEC_input(do_index) )
		DEC_string(do_index:do_index) = temp_char(1:1)
	ENDDO
c
c
c and convert the string to a longword
c
	return = OTS$CVT_TI_L(DEC_string,long_data)
	IF (.NOT. return) THEN
		radix_status = .FALSE.
	ENDIF
c
c
c and return
c
	RETURN
c
c
c early exit for <CR> and <^Z>, no difference in processing
c
100	CONTINUE 		!exception handling exit
	END
c
c
c
c
	SUBROUTINE delete_key(do_index,radix_status)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c delete_key - 
c Input: do_index from input loop
c Output: backed up do_index and blanked out character on screen
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                     data definition
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	LOGICAL     radix_status,vt100_status
	BYTE        x_position,y_position,blank
	INTEGER*4   do_index
	PARAMETER   (blank="40)	
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                       executable
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
	radix_status = .TRUE.
	IF (do_index .NE. 0) THEN
		CALL vt100_locate_cursor(x_position,y_position,VT100_status)
		x_position = x_position - 1
		CALL vt100_move_cursor(x_position,y_position,VT100_status)
		CALL vt100_write(blank,1,vt100_status)
		CALL vt100_move_cursor(x_position,y_position,VT100_status)
		do_index = do_index - 2
	ENDIF
	RETURN
	END
