$! Command procedure to autodial a number selected by a user 
$!
$! MODIFIED 16-JUN-86 BY TLM allow user to access a different modem 
$!                           in case theirs hangs.
$!
$ MODEM_ALLOCATED = "NO"
$ CONTROL_Y_SET = F$ENVIRONMENT("CONTROL")
$!
$! CONTROL_Y_ENAB = true(1) if the user has control_y set
$!
$ CONTROL_Y_ENAB = 0
$ IF ((CONTROL_Y_SET - "Y") .NES. CONTROL_Y_SET) THEN -
	CONTROL_Y_ENAB = 1
$ SET NOCONTROL_Y
$ OPEN/READ ALLOC_FILE TOOLDIR:AUTODIAL_PORT.DAT
$!
$! Determine which full modem device is available for allocation
$! if no devices are available, write out error message and terminate
$!
$ALLOC_LOOP:
$ READ/END=UNAVAIL ALLOC_FILE RECORD
$ ALLOC_DEV = F$EXTRACT(0,4,RECORD)
$ ALLOC_SPEED = F$EXTRACT(5,4,RECORD)
$ ALLOC_SPEED_SAV = ALLOC_SPEED
$ ALLOC_TYPE  = F$EXTRACT(10,1,RECORD)
$ MODEM_NOT_AVAIL = F$GETDVI(ALLOC_DEV,"ALL")
$ IF (MODEM_NOT_AVAIL) THEN GOTO ALLOC_LOOP
$!
$! Modem is available for use 
$!
$ DEFINE/NOLOG MODEM 'ALLOC_DEV'
$ GOTO SET_HOST
$UNAVAIL:
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT "There are no modem lines presently available"
$ WRITE SYS$OUTPUT "Please try again later"
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT " "
$ GOTO FINI
$SET_HOST:
$ ALLOC MODEM:
$ MODEM_ALLOCATED = "YES"
$ SET MESSAGE /ID/FAC/SEVER/TEXT
$ WRITE SYS$OUTPUT "YOU HAVE ALLOCATED DEVICE ''ALLOC_DEV'"
$ SET ON
$ ON WARNING THEN GOTO HAVE_WARNING
$!
$! Detemine which number the user is dialing.
$!
$ INQUIRE_NUMBER:
$ TYPE SYS$INPUT:

The following numbers are available to dial, please select an option:

    1.	For dialing a plant, just enter the string "Pnn" where "nn" is
	the plant number you wish to dial

$ INQUIRE/NOPUNC DIAL_LOCAT "Enter option (Pnn)--> "
$ IF DIAL_LOCAT .EQS. "" THEN GOTO FINI
$ GOTO GET_PHONE_NUM
$DETERMINE_SPEED:
$ GOTO DETERMINE_MODEM_SPEED
$DETERMINE_TRANSMIT_SYMBOLS:
$ GOTO SET_TRANSMIT_SYMBOLS
$SET_MODEM_SPEED:
$ SET TERMINAL MODEM:/SPEED='ALLOC_SPEED'
$!
$! Append ":" to device name so dialing fortran program will have a
$! valid device name (TXA0: instead of TXA0)
$!
$ ALLOC_DEV = ALLOC_DEV + ":"
$ SPAWN/NOWAIT/INPUT=TOOLDIR:AUTDIAL_SPAWN.COM/NOLOG - 
	/OUTPUT=AUTODIAL.LOG
$ ALLOC_DEV = ALLOC_DEV - ":"
$ TYPE SYS$INPUT

	The number will be dialed automatically for you.  When you 
	are finished with your call type a "I"<RETURN> and <CTRL-\>
	to hang up the modem and return to menu/DCL level.

$ DEFINE/NOLOG/USER SYS$INPUT SYS$COMMAND
$ SET HOST/DTE MODEM:
$!
$! Ask if the user wants to dial another number
$! 
$INQUIRE_NEXT_OPT:
$ TYPE SYS$INPUT
    Select response:
	
	1. Try another modem (if your current modem is inoperable)
	2. Dial another number
	3. Reduce Baud rate (noisy lines) and dial another number
	4. EXIT

$ INQUIRE/NOPUNC NEXT_OPT  "Enter selection--> "
$ IF (NEXT_OPT .EQ. 1) THEN GOTO GET_MODEM
$ IF (NEXT_OPT .EQ. 2) THEN GOTO INQUIRE_NUMBER
$ IF (NEXT_OPT .EQ. 3) THEN ALLOC_SPEED = "1200"
$ IF (NEXT_OPT .EQ. 3) THEN GOTO INQUIRE_NUMBER
$! IF (NEXT_OPT .NE. 3) THEN ALLOC_SPEED = ALLOC_SPEED_SAV
$ IF (NEXT_OPT .EQ. 4) THEN GOTO FINI
$ GOTO INQUIRE_NEXT_OPT
$!
$! User has selected option 1:  ALLOC another modem.
$!
$GET_MODEM:
$ DEALLOC MODEM
$ MODEM_ALLOCATED = "NO"
$ GOTO ALLOC_LOOP
$!
$HAVE_WARNING:
$ WRITE SYS$OUTPUT "ERROR ENCOUNTERED, TERMINATING MODEM CALL"
$ GOTO FINI
$!
$FINI:
$ IF (MODEM_ALLOCATED .EQS. "YES") THEN DEALLOC MODEM
$ CLOSE ALLOC_FILE
$ IF CONTROL_Y_ENAB THEN SET CONTROL_Y
$ EXIT
$!
$!************************************************************************
$!************************************************************************
$!  SUBROUTINE SECTION 
$!************************************************************************
$!************************************************************************
$!
$!*****
$!*****
$GET_PHONE_NUM:
$ OPEN/READ PHONE_NUM_FILE TOOLDIR:AUTO_PHONE.NUM
$ READ/INDEX=0/KEY='DIAL_LOCAT'/ERR=NO_NUMBER PHONE_NUM_FILE PHONE_NUM_REC
$ CLOSE PHONE_NUM_FILE
$ PHONE_NUM = F$EXTRACT(10,15,PHONE_NUM_REC)
$ SITE_MODEM_TYPE = F$EXTRACT(26,1,PHONE_NUM_REC)
$ PHONE_NUM = F$EDIT(PHONE_NUM,"COLLAPSE")
$!
$! If the Modem is a Micom, remove the "K" (pause) from the number
$!
$ IF (ALLOC_TYPE .EQS. "M") THEN PHONE_NUM = PHONE_NUM - "K"
$ GOTO DETERMINE_SPEED
$!
$NO_NUMBER:
$ TYPE SYS$INPUT 
  ERROR-- you entered an invalid option, please reenter,
  If you want to abort, just enter a carriage return
$ GOTO INQUIRE_NUMBER
$!
$!
$!****
$!****
$DETERMINE_MODEM_SPEED:
$!
$! This code will determine what the modem speed should be.  MICOM modems 
$! can transmit at 1200/2400 baud, Racal Vadics at 300/1200.  Some plants
$! have Racal Vadics, so if our Micom transmits at 2400 baud, these plants
$! will not be able to communicate.  Therefore, for these plants, set speed
$! at 1200 baud for Micom modems.
$!
$ IF (SITE_MODEM_TYPE .EQS. "R") THEN ALLOC_SPEED = "1200"
$ GOTO DETERMINE_TRANSMIT_SYMBOLS
$!
$SET_TRANSMIT_SYMBOLS: 
$ IF (ALLOC_TYPE .EQS. "M") THEN GOTO SET_MICOM_SYMBOLS
$ IF (ALLOC_TYPE .EQS. "R") THEN GOTO SET_RACAL_SYMBOLS
$SET_MICOM_SYMBOLS:
$ AUTODIAL_SYM1 = "4"
$ AUTODIAL_SYM2 = "
"
$ AUTODIAL_SYM3 = "D
"
$ AUTODIAL_SYM4 = PHONE_NUM + "
"
$ GOTO END_SET_TRANSMIT_SYMBOLS
$SET_RACAL_SYMBOLS:
$ AUTODIAL_SYM1 = "5"
$ AUTODIAL_SYM2 = "
"
$ AUTODIAL_SYM3 = "D
"
$ AUTODIAL_SYM4 = PHONE_NUM + "
"
$ AUTODIAL_SYM5 = "
"
$ GOTO END_SET_TRANSMIT_SYMBOLS
$END_SET_TRANSMIT_SYMBOLS:
$ GOTO SET_MODEM_SPEED
