$!
$!*********************************************************************
$! Job_id.	 UTLIFFILE-1A  Execute a DCL command if file is present
$! Author.	 B. Wallis.
$! Date Written. 13-Aug-86
$!
$! Last Job Modification.  
$!	Author.  X. Xxx
$!	Date.    99-Xxx-99
$!
$!	Job Changes:
$!
$!*********************************************************************
$STEP1:
$!
$	IF P1 .NES. "" .AND. P2 .NES. "" THEN GOTO START
$	COPY SYS$INPUT SYS$OUTPUT

This command procedure must have two parameters, as follows:

@UTLIFFILE filespec "DCL command"

Where:	filespec	=> Any valid file specification (including wildcards)
	"DCL command"	=> Any DCL command (must be enclosed in quotes)

It will then perform the DCL command once for each instance of filespec which
has an actual size greater than zero blocks. If a question mark occurs in the
DCL command, the filespec will be substituted for it;  otherwise the filespec
will be appended to the end of the command. 

$	GOTO EXIT
$!
$START:
$	ORIGINAL_FILE = P1
$	DCL_COMMAND = P2 + " "
$	BREAK = F$LOCATE("?",DCL_COMMAND)
$	LEFT_HALF = F$EXTRACT(0,BREAK,DCL_COMMAND)
$	RIGHT_HALF = F$EXTRACT(BREAK+1,32767,DCL_COMMAND)
$NEXT_FILE:
$	FILE = F$SEARCH(ORIGINAL_FILE)
$	IF FILE .EQS. "" THEN GOTO EXIT
$	IF F$FILE_ATTRIBUTES(FILE,"ALQ") .EQS. 0 THEN GOTO NEXT_FILE
$	COMMAND = LEFT_HALF + FILE + RIGHT_HALF
$	'COMMAND'
$	GOTO NEXT_FILE
$!
$!****************************************************************************
$EXIT:					! END OF INTERACTIVE JOB
$	EXIT
$!****************************************************************************
