	PROGRAM stopuser
	 
C      PROGRAM DESCRIPTION: 
C
C		Stop a process by username rather than process id.
C
C      AUTHORS: 
C
C		Eliezer May (from the VAX Professional, February 1986)
C
C      CREATION DATE: 	8-Apr-1986
C
C
C                      C H A N G E   L O G
C
C      Date     | Name  | Description
C---------------+-------+-----------------------------------------------------
C 08-Apr-1986   |  blw  | Original entry
C---------------+-------+-----------------------------------------------------
C[change_entry]
C
	IMPLICIT INTEGER (a-z)
	EXTERNAL jpi$_terminal,jpi$_pid,jpi$_imagname
	EXTERNAL jpi$_cputim,jpi$_username,lib$get_foreign
	INCLUDE '($ssdef) /NOLIST'
	PARAMETER (maxproc=100)
	INTEGER*4 iosb(2),param_list(16),process_id,istat,old_process_id
	INTEGER*4 sys$getjpi,sys$delprc,wild_id,proc_id(maxproc)
	DATA wild_id /-1/
	CHARACTER*1 reply
	CHARACTER*12 user,proc_user(maxproc)
	CHARACTER*7 terminal,proc_terminal(maxproc)
	CHARACTER*80 image_name,cmd,proc_image_name(maxproc)
	CHARACTER*15 proc_name(maxproc),last_name(maxproc)
	 
	param_list(1) = ISHFT (%loc(jpi$_pid),16).OR.4
	param_list(2) = %loc(process_id)
	param_list(3) = 0
	param_list(4) = ISHFT (%loc(jpi$_imagname), 16).OR.LEN (image_name)
	param_list(5) = %loc(image_name)
	param_list(6) = %loc(image_length)
	param_list(7) = ISHFT (%loc(jpi$_username), 16).OR.12
	param_list(8) = %loc(user)
	param_list(9) = 0
	param_list(10) = ISHFT (%loc(jpi$_terminal), 16).OR.LEN (terminal)
	param_list(11) = %loc(terminal)
	param_list(12) = 0
	param_list(13) = 0

	istat = lib$get_foreign(cmd,,,)
	lng = LEN (cmd)
	ipos = 1
	DO WHILE (ipos .LT. 80.AND.cmd(ipos:ipos) .NE. ' ')
	    ipos = ipos + 1
	END DO
	ipos = ipos - 1
	old_process_id = 0
	limit = 0
	DO WHILE (iosb(1) .NE. ss$_nomoreproc)
	    istat = sys$getjpi(%val(1),wild_id,,param_list,iosb,,)
	    IF (iosb(1) .NE. ss$_nomoreproc) THEN
		IF (user(1:ipos) .EQ. cmd(1:ipos)) THEN
		    IF (old_process_id .NE. process_id) THEN
			old_process_id = process_id
			limit = limit + 1
			proc_id(limit) = process_id
			proc_name(limit) = user
			proc_terminal(limit) = terminal
			IF (image_length .EQ. 0) THEN
			    proc_image_name(limit) = 'nothing'//image_name
			ELSE
			    proc_image_name(limit) = image_name
			END IF
		    END IF
		END IF
	    END IF
	END DO
	proc_id(limit + 1) = 0
	IF (limit .LE. 0) THEN
	    WRITE (UNIT=5, FMT=200) cmd(1:ipos)
200	    FORMAT (1X, A<ipos>, ' not found')
	ELSE 
	    DO j=1,limit
		WRITE (UNIT=5, FMT=102) proc_name(j), proc_image_name(j)
102		FORMAT (1X, 'Delete ', A, ' running ', A, ' [N]? ', $)
		READ (UNIT=5, FMT=103) reply
103		FORMAT (A1)
		IF (reply .EQ. 'Y'.OR.reply .EQ. 'y') THEN
		    istat = sys$delprc(proc_id(j),)
		
		END IF
	    END DO
	END IF
	CALL exit
	END
