$!
$! Two method examples to execute this command procedure:
$!
$!	@[TOOLS]TOPDSKUSR 50000 DSK:
$!
$!	@[TOOLS]TOPDSKUSR RESTART 50000
$!
$! This command procedure will allow a user to get a list of diskusage
$! for all users on a particular disk.  There are two parameters input
$! to the command procedure.  
$!
$!		P1 = MINIMUM BLOCKS:  Print a record for each 
$!		user who has at least this amount of blocks 
$!		used on the disk.
$!
$!		P2 = DISK NAME:  The name of the disk to be 
$!		searched for usage.
$!
$! This command procedure allows a restart capability.  If the user has
$! run the procedure on a disk, and he/she wants to obtain a disk usage
$! report with a different MINIMUM BLOCK size on the same disk, there is
$! no reason to perform a new disk directory listing.  Therefore, if the
$! user enters the string 'RESTART' as P1 and then the new block size 
$! as P2, the command procedure will branch around the directory listing
$! code and go into the diskusage program.
$!
$!
$SHOW TIME
$ON CONTROL_Y THEN GOTO FINI
$ON WARNING THEN GOTO FINI
$!
$! In order to allow a restart of the command procedure but not to duplicate
$! the directory search, if the user enters P1 as "restart" and P2 as
$! the new MIN FILE SIZE the command procedure will branch to executing the
$! topdskusr program.
$!
$IF P1 .NES. "RESTART" THEN GOTO 'F$MODE()'
$ P1 = P2
$ GOTO RESTART
$!
$INTERACTIVE:
$ IF (P1 .EQS. "") THEN - 
	INQUIRE/NOPUNC P1 "Enter minimum disk usage for output--> "
$ IF (P2 .EQS. "") THEN -
	INQUIRE/NOPUNC P2 "Enter disk to check <DSK>--> "
$BATCH:
$ IF (P1 .EQS. "" .OR. P2 .EQS. "") THEN GOTO NO_PARMS
$SAVE_PRIV = F$SETPRIV("BYPASS")
$DIR/WIDTH=FILENAME=40/OWN/SIZ/OUT=DIRSIZ.DAT 'P2':[*...]
$SORT/KEY=(POSITION:51,SIZ:15) DIRSIZ.DAT DIRSIZ_TMP.DAT
$RENAME DIRSIZ_TMP.DAT DIRSIZ.DAT
$RESTART:
$ TOPDSKUSR := $DSK:[TOOLS]TOPDSKUSR.EXE"
$ TOPDSKUSR 'P1'
$ GOTO FINI
$NO_PARMS:
$ WRITE SYS$OUTPUT "ERROR, invalid parameters entered, terminating"
$FINI:
$ IF("''SAVE_PRIV'' .NES. "") THEN SET PROC/PRIV=('SAVE_PRIV')
$ SHOW TIME
$EXIT
