	PROGRAM TOPDSKUSR

	CHARACTER*40	FILE_NAME
	CHARACTER*20	FILE_OWNER
	CHARACTER*20	FILE_OWNER_OLD	
	CHARACTER*8	CMIN_FILE_SIZE	
	CHARACTER*12	DISK_NAME

	INTEGER	FILE_SIZE,FILE_TOTAL,FILE_QUANTITY,FILE_STATUS,
     *		MIN_FILE_SIZE

	LOGICAL		END_OF_FILE



	OPEN(1,STATUS='OLD',ERR=1000,FILE='DIRSIZ.DAT'
     *		,READONLY,SHARED,IOSTAT=FILE_STATUS)
	OPEN(2,STATUS='NEW',ERR=1010,FILE='TOPUSR.DAT'
     *		,IOSTAT=FILE_STATUS)

C Call LIB$GET_FOREIGN to return the foreign input parameter which
C contains the minimum size of owner's files in order for the owner
C to be written to the TOPUSER file.

	LIB_STATUS = LIB$GET_FOREIGN (CMIN_FILE_SIZE)
	IF (.NOT. LIB_STATUS) CALL LIB$SIGNAL (%VAL(LIB_STATUS))
C
C The internal read will convert the file size input by the lib$get_foreign
C call from character to integer format.
C
	READ(CMIN_FILE_SIZE,10010,ERR=500,IOSTAT=FILE_STATUS) MIN_FILE_SIZE
	FILE_OWNER = ' '
	END_OF_FILE = .FALSE.

C Read records trying to find the disk name

	CALL GET_DISK_NAME(DISK_NAME)
	CALL WRITE_DISK_NAME(DISK_NAME)
C Read the file skipping all records up to the first valid file/owner record

	CALL READ_DIR(FILE_NAME,FILE_SIZE,FILE_OWNER,END_OF_FILE)

	DO WHILE (.NOT. END_OF_FILE)
	    FILE_OWNER_OLD = FILE_OWNER
	    FILE_TOTAL = 0
	    FILE_QUANTITY = 0
	    DO WHILE ((FILE_OWNER_OLD .EQ. FILE_OWNER) .AND.
     *			(.NOT. END_OF_FILE))
		FILE_TOTAL = FILE_TOTAL + FILE_SIZE
		FILE_QUANTITY = FILE_QUANTITY + 1
		CALL READ_DIR(FILE_NAME,FILE_SIZE,FILE_OWNER,END_OF_FILE)
	    END DO
	    IF (FILE_TOTAL .GE. MIN_FILE_SIZE) THEN
		CALL WRITE_TOPUSR(FILE_OWNER_OLD,FILE_TOTAL,FILE_QUANTITY)
	    END IF
	END DO
	GOTO 8000

C The internal read has erred, the user may have typed a non numeric digit
C Give error message and terminate.

500	WRITE (6,10020) FILE_STATUS, CMIN_FILE_SIZE

8000	CLOSE (1,ERR=1000)
	CLOSE (2,ERR=1010)
	GOTO 9000
1000	WRITE (6,10000) 'TOPDIR.DAT', FILE_STATUS
	GOTO 9000
1010	WRITE (6,10000) 'TOPUSR.DAT',FILE_STATUS
9000	CONTINUE
10000	FORMAT(1X,'ERROR OPEN/CLOSE FILE ',A12,' FILE-STATUS = ',I5)
10010	FORMAT(BN,I8)
10020	FORMAT(1X,'ERROR, Invalid foreign input, FILE-STATUS = ',I5,
     *		' Foreign input = ',A8)
	STOP
	END

	SUBROUTINE READ_DIR(NAME,SIZE,OWNER,END_OF_FILE)

	CHARACTER	NAME*40,OWNER*20,OWN_FIELD_START*1

	INTEGER 	SIZE,FILE_STATUS

	LOGICAL		END_OF_FILE

	PARAMETER 	(OWN_FIELD_START = '[')


	OWNER = ' '

C The input file has other records besides the filename,owner,size.  It has
C directory total records, and grand total records.  Ignore all records
C which do not have a valid owner field (valid = "[" in first character pstn

	DO WHILE (OWNER(1:1) .NE. OWN_FIELD_START)
	    READ (1,10000,END=500,ERR=100,IOSTAT=FILE_STATUS) NAME,SIZE,OWNER
	    GOTO 700
100	    IF (FILE_STATUS .NE. 64) THEN 
     		WRITE (6,10010) 'TOPDIR.DAT', FILE_STATUS, NAME	    
	    END IF
700	    CONTINUE
	END DO
	GOTO 9000
500	END_OF_FILE = .TRUE.
9000	CONTINUE
10000	FORMAT(A40,I8,2X,A20)
10010	FORMAT(1X,'ERROR READING FILE ',A12,' FILE-STATUS = ',I5,
     *		' FILE_NAME= ',A20)
	RETURN
	END

	SUBROUTINE GET_DISK_NAME(DISK_NAME)

	CHARACTER	FILLER*20,OWNER*20,OWN_FIELD_START*1
     *  ,		DISK_NAME*12,DISK_SEARCH_STRING*20

	INTEGER 	SIZE,FILE_STATUS,COLON_LOCALE

	LOGICAL		END_OF_FILE,DISK_FOUND

	PARAMETER 	(OWN_FIELD_START = '[')


	DISK_FOUND = .FALSE.
C The input file has other records besides the filename,owner,size.  It has
C directory total records, and grand total records.  Ignore all records
C which do not have a valid owner field (valid = "[" in first character pstn

	DO WHILE (.NOT. DISK_FOUND)
	    READ (1,10000,END=500,ERR=100,IOSTAT=FILE_STATUS) 
     *		DISK_SEARCH_STRING,FILLER,SIZE,OWNER
	    ILEN = INDEX(DISK_SEARCH_STRING,'Directory')
	    IF (ILEN .NE. 0) THEN
		COLON_LOCALE = INDEX(DISK_SEARCH_STRING,':')
		ILEN = ILEN + 10
		DISK_NAME = DISK_SEARCH_STRING(ILEN:COLON_LOCALE)
		DISK_FOUND = .TRUE.
	    END IF
	    GOTO 700
100	    IF (FILE_STATUS .NE. 64) THEN 
     		WRITE (6,10010) 'TOPDIR.DAT', FILE_STATUS, DISK_SEARCH_STRING
	    END IF
700	    CONTINUE
	END DO
	GOTO 9000
500	END_OF_FILE = .TRUE.
9000	CONTINUE
10000	FORMAT(A20,A20,I8,2X,A20)
10010	FORMAT(1X,'ERROR READING FILE ',A12,' FILE-STATUS = ',I5,
     *		' FILE_NAME= ',A20)
	RETURN
	END


	SUBROUTINE WRITE_DISK_NAME(DISK_NAME)

	CHARACTER*12 DISK_NAME
	INTEGER FILE_STATUS

	WRITE(2,10000,ERR=1000,IOSTAT=FILE_STATUS)
	WRITE(2,10000,ERR=1000,IOSTAT=FILE_STATUS)
	WRITE(2,10010,ERR=1000,IOSTAT=FILE_STATUS)
	WRITE(2,10020,ERR=1000,IOSTAT=FILE_STATUS) DISK_NAME
	WRITE(2,10010,ERR=1000,IOSTAT=FILE_STATUS)
	WRITE(2,10000,ERR=1000,IOSTAT=FILE_STATUS)
	WRITE(2,10000,ERR=1000,IOSTAT=FILE_STATUS)
	GOTO 9000
1000	WRITE (6,10030) 'TOPUSR.DAT', FILE_STATUS
9000	CONTINUE
10000	FORMAT(1X,120('*'))
10010	FORMAT(1X)
10020	FORMAT('-',40X,'DISK NAME = ',A12)
10030	FORMAT(1X,'ERROR WRITING FILE ',A12,' FILE-STATUS = ',I5)
	RETURN
	END


	SUBROUTINE WRITE_TOPUSR(OWNER,TOTAL,QUANTITY)

	CHARACTER*20 OWNER
	INTEGER TOTAL, QUANTITY,FILE_STATUS

	WRITE(2,10000,ERR=1000,IOSTAT=FILE_STATUS) OWNER,QUANTITY,TOTAL
	GOTO 9000
1000	WRITE (6,10010) 'TOPUSR.DAT', FILE_STATUS
9000	CONTINUE
10000	FORMAT(1X,'USERNAME ',A20,' HAS ',I4,' FILES FOR A TOTAL OF ',
     *		I8,' BLOCKS')
10010	FORMAT(1X,'ERROR WRITING FILE ',A12,' FILE-STATUS = ',I5)
	RETURN
	END
