

	subroutine ValScr( Name, Field, Intg, Rl, Str, Valid )

c--
c This is a custom validation routine for the profilometer program.
c
c The program uses two Fpaint screens, GROUP and SPEC. The following
c validation will be performed:
c
c
c	For the screen GROUP ( i.e. Name = 'GROUP' )
c
c	  The third field, GroupID (character), must be a
c	  valid file name.
c
c 	  The sixth field, ScanRate (integer), must not equal -1
c  	  ( -1 is the suppressed value for this field which indicates
c	    a null entry ).
c
c
c	For the screen SPEC ( i.e. Name = 'SPEC' )
c
c	  The first field, SpecimenID (character), must be a
c	  valid file name.
c
c--

	character*(*) Name
	integer Field, Intg
	real Rl
	character*(*) Str
	logical Valid

	logical LegalFileName

	Valid = .true.

	if( Name .eq. 'GROUP' ) then

	  if( Field .eq. 3 ) then

	    if( .not. LegalFileName(Str) ) then
	      Valid = .false.
	      call ErrMsg( 'Group ID must be a valid file name!' )
	    end if

	  else if( Field .eq. 6 ) then

	    if( Intg .eq. -1 ) then
	      Valid = .false.
	      call ErrMsg( 'Null entry is invalid' )
	      return
	    end if

	  end if


	else if( Name .eq. 'SPEC' ) then

	  if( Field .eq. 1 ) then

	    if( .not. LegalFileName(Str) ) then
	      Valid = .false.
	      call ErrMsg( 'Specimen ID must be a valid file name!' )
	    end if

	  end if

	end if


	end


	logical function LegalFileName( String )

	character*(*) String
	character*1 C
	integer I, Length

	do 10 I = 1 , length( String )

	  C = String(I:I)

	  if(  ( C .lt. '0' .or. C .gt. '9' ) .and.
     1	       ( C .lt. 'A' .or. C .gt. 'Z' ) .and.
     1	       ( C .lt. 'a' .or. C .gt. 'z' )  ) then

	    LegalFileName = .false.
	    return

	  end if

10	continue

	LegalFileName = .true.

	end


	subroutine DoTest

	integer Key

	call ClrScr
	call CsrPos( 3, 20 )
	call OutString( 'The test would be performed at this point' )

	call DspMessage( 'Press a key', 'to continue' )
	call GetChar( Key )

	end


	subroutine MoreGroups( More )

	logical More
	integer Item, Selection, Intense

	data Intense /2/, Normal /0/

	call EraseRegion( 23,1, 24,80 )
	call DspAttribute( Intense )
	call CsrPos( 23, 1 )
	call OutString( 'Another Specimen Group?' )
	Item = 1
10	call Menu1( 24, 'Yes   No', 'YN', Item, Selection, Abort )

 	if( Abort ) goto 10

	call DspAttribute( Normal )
	call EraseRegion( 23,1, 24,80 )

	if( Selection .eq. ichar('Y') ) then
	  More = .true.
	else
	  More = .false.
	end if

	end


	subroutine MoreSpecs( More )

	logical More
	integer Item, Selection, Intense

	data Intense /2/, Normal /0/

	call EraseRegion( 23,1, 24,80 )
	call DspAttribute( Intense )
	call CsrPos( 23, 1 )
	call OutString( 'Another Specimen?' )
	Item = 1
10	call Menu1( 24, 'Yes   No', 'YN', Item, Selection, Abort )

 	if( Abort ) goto 10

	call DspAttribute( Normal )
	call EraseRegion( 23,1, 24,80 )

	if( Selection .eq. ichar('Y') ) then
	  More = .true.
	else
	  More = .false.
	end if

	end

  
